/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.richcopy;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.richcopy.settings.RichCopySettings;

public abstract class ForcedCopyModeAction
extends AnAction {
    private final boolean myRichCopyEnabled;

    protected ForcedCopyModeAction(boolean richCopyEnabled) {
        this.myRichCopyEnabled = richCopyEnabled;
    }

    public void update(AnActionEvent e) {
        Presentation p = e.getPresentation();
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
        p.setVisible(RichCopySettings.getInstance().isEnabled() != this.myRichCopyEnabled && (e.isFromActionToolbar() || editor != null && editor.getSelectionModel().hasSelection(true)));
        p.setEnabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(AnActionEvent e) {
        RichCopySettings settings = RichCopySettings.getInstance();
        boolean savedValue = settings.isEnabled();
        try {
            settings.setEnabled(this.myRichCopyEnabled);
            ActionManager.getInstance().getAction("EditorCopy").actionPerformed(e);
        }
        finally {
            settings.setEnabled(savedValue);
        }
    }
}

