/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LightDirectoryIndex<T> {
    private final ConcurrentIntObjectMap<T> myInfoCache;
    private final T myDefValue;
    private final Consumer<LightDirectoryIndex<T>> myInitializer;

    public LightDirectoryIndex(@NotNull Disposable parentDisposable, @NotNull T defValue, @NotNull Consumer<LightDirectoryIndex<T>> initializer) {
        if (parentDisposable == null) {
            LightDirectoryIndex.$$$reportNull$$$0(0);
        }
        if (defValue == null) {
            LightDirectoryIndex.$$$reportNull$$$0(1);
        }
        if (initializer == null) {
            LightDirectoryIndex.$$$reportNull$$$0(2);
        }
        this.myInfoCache = ContainerUtil.createConcurrentIntObjectMap();
        this.myDefValue = defValue;
        this.myInitializer = initializer;
        this.resetIndex();
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect(parentDisposable);
        connection.subscribe(FileTypeManager.TOPIC, (Object)new FileTypeListener(){

            public void fileTypesChanged(@NotNull FileTypeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                LightDirectoryIndex.this.resetIndex();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/util/indexing/LightDirectoryIndex$1", "fileTypesChanged"));
            }
        });
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    2.$$$reportNull$$$0(0);
                }
                for (VFileEvent vFileEvent : events) {
                    VirtualFile file2 = vFileEvent.getFile();
                    if (file2 != null && !file2.isDirectory()) continue;
                    LightDirectoryIndex.this.resetIndex();
                    break;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/util/indexing/LightDirectoryIndex$2", "after"));
            }
        });
    }

    public void resetIndex() {
        this.myInfoCache.clear();
        this.myInitializer.consume((Object)this);
    }

    public void putInfo(@Nullable VirtualFile file2, @NotNull T value) {
        if (value == null) {
            LightDirectoryIndex.$$$reportNull$$$0(3);
        }
        if (!(file2 instanceof VirtualFileWithId)) {
            return;
        }
        this.cacheInfo(file2, value);
    }

    @NotNull
    public T getInfoForFile(@Nullable VirtualFile file2) {
        VirtualFile dir;
        if (!(file2 instanceof VirtualFileWithId)) {
            T t = this.myDefValue;
            if (t == null) {
                LightDirectoryIndex.$$$reportNull$$$0(4);
            }
            return t;
        }
        if (!file2.isDirectory()) {
            T info = this.getCachedInfo(file2);
            if (info != null) {
                T t = info;
                if (t == null) {
                    LightDirectoryIndex.$$$reportNull$$$0(5);
                }
                return t;
            }
            dir = file2.getParent();
        } else {
            dir = file2;
        }
        int count = 0;
        for (VirtualFile root = dir; root != null; root = root.getParent()) {
            if (++count > 1000) {
                throw new IllegalStateException("Possible loop in tree, started at " + dir.getName());
            }
            T info = this.getCachedInfo(root);
            if (info == null) continue;
            if (!dir.equals(root)) {
                this.cacheInfos(dir, root, info);
            }
            T t = info;
            if (t == null) {
                LightDirectoryIndex.$$$reportNull$$$0(6);
            }
            return t;
        }
        T t = this.cacheInfos(dir, null, this.myDefValue);
        if (t == null) {
            LightDirectoryIndex.$$$reportNull$$$0(7);
        }
        return t;
    }

    @NotNull
    private T cacheInfos(VirtualFile dir, @Nullable VirtualFile stopAt, @NotNull T info) {
        if (info == null) {
            LightDirectoryIndex.$$$reportNull$$$0(8);
        }
        while (dir != null) {
            this.cacheInfo(dir, info);
            if (dir.equals(stopAt)) break;
            dir = dir.getParent();
        }
        T t = info;
        if (t == null) {
            LightDirectoryIndex.$$$reportNull$$$0(9);
        }
        return t;
    }

    private void cacheInfo(VirtualFile file2, T info) {
        this.myInfoCache.put(((VirtualFileWithId)file2).getId(), info);
    }

    private T getCachedInfo(VirtualFile file2) {
        return (T)this.myInfoCache.get(((VirtualFileWithId)file2).getId());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defValue";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/LightDirectoryIndex";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/LightDirectoryIndex";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfoForFile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "cacheInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "putInfo";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "cacheInfos";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

