/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EmptyConsumer;
import com.intellij.util.Processor;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.EmptyIntHashSet;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.IntInlineKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.Page;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.PersistentMap;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogDetailsFilter;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.VcsUserRegistry;
import com.intellij.vcs.log.data.SingleTaskController;
import com.intellij.vcs.log.data.VcsLogProgress;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.VcsUserRegistryImpl;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.data.index.IntListDataExternalizer;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.data.index.VcsLogMessagesTrigramIndex;
import com.intellij.vcs.log.data.index.VcsLogPathsIndex;
import com.intellij.vcs.log.data.index.VcsLogUserIndex;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcs.log.impl.HeavyAwareExecutor;
import com.intellij.vcs.log.ui.filter.VcsLogTextFilterImpl;
import com.intellij.vcs.log.util.PersistentSet;
import com.intellij.vcs.log.util.PersistentSetImpl;
import com.intellij.vcs.log.util.PersistentUtil;
import com.intellij.vcs.log.util.StopWatch;
import com.intellij.vcs.log.util.TroveUtil;
import gnu.trove.TIntHashSet;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogPersistentIndex
implements VcsLogIndex,
Disposable {
    private static final Logger LOG = Logger.getInstance(VcsLogPersistentIndex.class);
    private static final int VERSION = 2;
    @NotNull
    private final Project myProject;
    @NotNull
    private final FatalErrorHandler myFatalErrorsConsumer;
    @NotNull
    private final VcsLogProgress myProgress;
    @NotNull
    private final Map<VirtualFile, VcsLogProvider> myProviders;
    @NotNull
    private final VcsLogStorage myStorage;
    @NotNull
    private final VcsUserRegistryImpl myUserRegistry;
    @NotNull
    private final Set<VirtualFile> myRoots;
    @Nullable
    private final IndexStorage myIndexStorage;
    @Nullable
    private final IndexDataGetter myDataGetter;
    @NotNull
    private final SingleTaskController<IndexingRequest, Void> mySingleTaskController;
    @NotNull
    private final Map<VirtualFile, AtomicInteger> myNumberOfTasks;
    @NotNull
    private final List<VcsLogIndex.IndexingFinishedListener> myListeners;
    @NotNull
    private Map<VirtualFile, TIntHashSet> myCommitsToIndex;

    public VcsLogPersistentIndex(@NotNull Project project, @NotNull VcsLogStorage storage2, @NotNull VcsLogProgress progress, @NotNull Map<VirtualFile, VcsLogProvider> providers, @NotNull FatalErrorHandler fatalErrorsConsumer, @NotNull Disposable disposableParent) {
        if (project == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(0);
        }
        if (storage2 == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(1);
        }
        if (progress == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(2);
        }
        if (providers == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(3);
        }
        if (fatalErrorsConsumer == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(4);
        }
        if (disposableParent == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(5);
        }
        this.myNumberOfTasks = ContainerUtil.newHashMap();
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myCommitsToIndex = ContainerUtil.newHashMap();
        this.myStorage = storage2;
        this.myProject = project;
        this.myProgress = progress;
        this.myProviders = providers;
        this.myFatalErrorsConsumer = fatalErrorsConsumer;
        this.myRoots = ContainerUtil.newLinkedHashSet();
        this.mySingleTaskController = new MySingleTaskController(project);
        for (Map.Entry<VirtualFile, VcsLogProvider> entry : providers.entrySet()) {
            if (!((Boolean)VcsLogProperties.get((VcsLogProvider)entry.getValue(), (VcsLogProperties.VcsLogProperty)VcsLogProperties.SUPPORTS_INDEXING)).booleanValue()) continue;
            this.myRoots.add(entry.getKey());
        }
        this.myUserRegistry = (VcsUserRegistryImpl)ServiceManager.getService((Project)this.myProject, VcsUserRegistry.class);
        this.myIndexStorage = this.createIndexStorage(fatalErrorsConsumer, PersistentUtil.calcLogId(this.myProject, providers));
        this.myDataGetter = this.myIndexStorage != null ? new IndexDataGetter(this.myProject, this.myRoots, this.myIndexStorage, this.myStorage, this.myFatalErrorsConsumer) : null;
        for (VirtualFile root : this.myRoots) {
            this.myNumberOfTasks.put(root, new AtomicInteger());
        }
        Disposer.register((Disposable)disposableParent, (Disposable)this);
    }

    protected IndexStorage createIndexStorage(@NotNull FatalErrorHandler fatalErrorHandler, @NotNull String logId) {
        if (fatalErrorHandler == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(6);
        }
        if (logId == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(7);
        }
        try {
            return (IndexStorage)IOUtil.openCleanOrResetBroken(() -> {
                if (logId == null) {
                    VcsLogPersistentIndex.$$$reportNull$$$0(37);
                }
                if (fatalErrorHandler == null) {
                    VcsLogPersistentIndex.$$$reportNull$$$0(38);
                }
                return new IndexStorage(logId, this.myUserRegistry, this.myRoots, fatalErrorHandler, this);
            }, () -> {
                if (logId == null) {
                    VcsLogPersistentIndex.$$$reportNull$$$0(36);
                }
                IndexStorage.cleanup(logId);
            });
        }
        catch (IOException e) {
            this.myFatalErrorsConsumer.consume(this, e);
            return null;
        }
    }

    public static int getVersion() {
        return 7;
    }

    @Override
    public synchronized void scheduleIndex(boolean full) {
        boolean isFull;
        if (Disposer.isDisposed((Disposable)this)) {
            return;
        }
        if (this.myCommitsToIndex.isEmpty() || this.myIndexStorage == null) {
            return;
        }
        if (this.myIndexStorage.isFresh() && !full) {
            return;
        }
        Map<VirtualFile, TIntHashSet> commitsToIndex = this.myCommitsToIndex;
        for (VirtualFile root : commitsToIndex.keySet()) {
            this.myNumberOfTasks.get(root).incrementAndGet();
        }
        this.myCommitsToIndex = ContainerUtil.newHashMap();
        boolean bl = isFull = full && this.myIndexStorage.isFresh();
        if (isFull) {
            LOG.debug("Index storage for project " + this.myProject.getName() + " is fresh, scheduling full reindex");
        }
        for (VirtualFile root : commitsToIndex.keySet()) {
            TIntHashSet commits = commitsToIndex.get(root);
            if (commits.isEmpty()) continue;
            this.mySingleTaskController.request(new IndexingRequest(root, commits, isFull));
        }
        if (isFull) {
            this.myIndexStorage.unmarkFresh();
        }
    }

    private void storeDetail(@NotNull VcsFullCommitDetails detail) {
        if (detail == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(8);
        }
        if (this.myIndexStorage == null) {
            return;
        }
        try {
            int index = this.myStorage.getCommitIndex((Hash)detail.getId(), detail.getRoot());
            this.myIndexStorage.messages.put((Object)index, (Object)detail.getFullMessage());
            this.myIndexStorage.trigrams.update(index, detail);
            this.myIndexStorage.users.update(index, detail);
            this.myIndexStorage.paths.update(index, detail);
            this.myIndexStorage.parents.put((Object)index, (Object)ContainerUtil.map((Collection)detail.getParents(), p -> {
                if (detail == null) {
                    VcsLogPersistentIndex.$$$reportNull$$$0(35);
                }
                return this.myStorage.getCommitIndex((Hash)p, detail.getRoot());
            }));
            this.myIndexStorage.commits.put(index);
        }
        catch (IOException e) {
            this.myFatalErrorsConsumer.consume(this, e);
        }
    }

    private void flush() {
        try {
            if (this.myIndexStorage != null) {
                this.myIndexStorage.messages.force();
                this.myIndexStorage.trigrams.flush();
                this.myIndexStorage.users.flush();
                this.myIndexStorage.paths.flush();
                this.myIndexStorage.parents.force();
                this.myIndexStorage.commits.flush();
            }
        }
        catch (StorageException e) {
            this.myFatalErrorsConsumer.consume(this, e);
        }
    }

    @Override
    public void markCorrupted() {
        if (this.myIndexStorage != null) {
            this.myIndexStorage.commits.markCorrupted();
        }
    }

    @Override
    public boolean isIndexed(int commit) {
        try {
            return this.myIndexStorage == null || this.myIndexStorage.commits.contains(commit);
        }
        catch (IOException e) {
            this.myFatalErrorsConsumer.consume(this, e);
            return false;
        }
    }

    @Override
    public synchronized boolean isIndexed(@NotNull VirtualFile root) {
        if (root == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(9);
        }
        return this.myRoots.contains(root) && !this.myCommitsToIndex.containsKey(root) && this.myNumberOfTasks.get(root).get() == 0;
    }

    @Override
    public synchronized void markForIndexing(int index, @NotNull VirtualFile root) {
        if (root == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(10);
        }
        if (this.isIndexed(index) || !this.myRoots.contains(root)) {
            return;
        }
        TIntHashSet set2 = this.myCommitsToIndex.get(root);
        if (set2 == null) {
            set2 = new TIntHashSet();
            this.myCommitsToIndex.put(root, set2);
        }
        set2.add(index);
    }

    @NotNull
    private <T> TIntHashSet filter(@NotNull PersistentMap<Integer, T> map2, @NotNull Condition<T> condition) {
        if (map2 == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(11);
        }
        if (condition == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(12);
        }
        TIntHashSet result2 = new TIntHashSet();
        if (this.myIndexStorage == null) {
            TIntHashSet tIntHashSet = result2;
            if (tIntHashSet == null) {
                VcsLogPersistentIndex.$$$reportNull$$$0(13);
            }
            return tIntHashSet;
        }
        try {
            Processor processor2 = integer -> {
                if (map2 == null) {
                    VcsLogPersistentIndex.$$$reportNull$$$0(33);
                }
                if (condition == null) {
                    VcsLogPersistentIndex.$$$reportNull$$$0(34);
                }
                try {
                    Object value = map2.get(integer);
                    if (value != null && condition.value(value)) {
                        result2.add(integer.intValue());
                    }
                }
                catch (IOException e) {
                    this.myFatalErrorsConsumer.consume(this, e);
                    return false;
                }
                return true;
            };
            if (this.myIndexStorage.messages instanceof PersistentHashMap) {
                ((PersistentHashMap)this.myIndexStorage.messages).processKeysWithExistingMapping(processor2);
            } else {
                this.myIndexStorage.messages.processKeys(processor2);
            }
        }
        catch (IOException e) {
            this.myFatalErrorsConsumer.consume(this, e);
        }
        TIntHashSet tIntHashSet = result2;
        if (tIntHashSet == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(14);
        }
        return tIntHashSet;
    }

    @NotNull
    private TIntHashSet filterUsers(@NotNull Set<VcsUser> users) {
        if (users == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(15);
        }
        if (this.myIndexStorage != null) {
            TIntHashSet tIntHashSet;
            try {
                tIntHashSet = this.myIndexStorage.users.getCommitsForUsers(users);
            }
            catch (StorageException | IOException e) {
                this.myFatalErrorsConsumer.consume(this, e);
            }
            catch (RuntimeException e) {
                this.processRuntimeException(e);
            }
            if (tIntHashSet == null) {
                VcsLogPersistentIndex.$$$reportNull$$$0(16);
            }
            return tIntHashSet;
        }
        TIntHashSet tIntHashSet = new TIntHashSet();
        if (tIntHashSet == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(17);
        }
        return tIntHashSet;
    }

    @NotNull
    private TIntHashSet filterPaths(@NotNull Collection<FilePath> paths) {
        if (paths == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(18);
        }
        if (this.myIndexStorage != null) {
            TIntHashSet tIntHashSet;
            try {
                tIntHashSet = this.myIndexStorage.paths.getCommitsForPaths(paths);
            }
            catch (StorageException | IOException e) {
                this.myFatalErrorsConsumer.consume(this, e);
            }
            catch (RuntimeException e) {
                this.processRuntimeException(e);
            }
            if (tIntHashSet == null) {
                VcsLogPersistentIndex.$$$reportNull$$$0(19);
            }
            return tIntHashSet;
        }
        TIntHashSet tIntHashSet = new TIntHashSet();
        if (tIntHashSet == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(20);
        }
        return tIntHashSet;
    }

    @NotNull
    public TIntHashSet filterMessages(@NotNull VcsLogTextFilter filter2) {
        if (filter2 == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(21);
        }
        if (this.myIndexStorage != null) {
            block8: {
                TIntHashSet tIntHashSet;
                try {
                    TIntHashSet commitsForSearch;
                    if (filter2.isRegex() || (commitsForSearch = this.myIndexStorage.trigrams.getCommitsForSubstring(filter2.getText())) == null) break block8;
                    TIntHashSet result2 = new TIntHashSet();
                    commitsForSearch.forEach(commit -> {
                        if (filter2 == null) {
                            VcsLogPersistentIndex.$$$reportNull$$$0(32);
                        }
                        try {
                            String value = (String)this.myIndexStorage.messages.get((Object)commit);
                            if (value != null && VcsLogTextFilterImpl.matches(filter2, value)) {
                                result2.add(commit);
                            }
                        }
                        catch (IOException e) {
                            this.myFatalErrorsConsumer.consume(this, e);
                            return false;
                        }
                        return true;
                    });
                    tIntHashSet = result2;
                }
                catch (StorageException e) {
                    this.myFatalErrorsConsumer.consume(this, e);
                }
                catch (RuntimeException e) {
                    this.processRuntimeException(e);
                }
                if (tIntHashSet == null) {
                    VcsLogPersistentIndex.$$$reportNull$$$0(22);
                }
                return tIntHashSet;
            }
            TIntHashSet tIntHashSet = this.filter(this.myIndexStorage.messages, message -> {
                if (filter2 == null) {
                    VcsLogPersistentIndex.$$$reportNull$$$0(31);
                }
                return VcsLogTextFilterImpl.matches(filter2, message);
            });
            if (tIntHashSet == null) {
                VcsLogPersistentIndex.$$$reportNull$$$0(23);
            }
            return tIntHashSet;
        }
        TIntHashSet tIntHashSet = EmptyIntHashSet.INSTANCE;
        if (tIntHashSet == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(24);
        }
        return tIntHashSet;
    }

    private void processRuntimeException(@NotNull RuntimeException e) {
        if (e == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(25);
        }
        if (e instanceof ProcessCanceledException) {
            throw e;
        }
        if (this.myIndexStorage != null) {
            this.myIndexStorage.markCorrupted();
        }
        if (!(e.getCause() instanceof IOException) && !(e.getCause() instanceof StorageException)) {
            throw new RuntimeException(e);
        }
        this.myFatalErrorsConsumer.consume(this, e);
    }

    @Override
    public boolean canFilter(@NotNull List<VcsLogDetailsFilter> filters) {
        if (filters == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(26);
        }
        if (filters.isEmpty() || this.myIndexStorage == null) {
            return false;
        }
        for (VcsLogDetailsFilter filter2 : filters) {
            if (filter2 instanceof VcsLogTextFilter || filter2 instanceof VcsLogUserFilter || filter2 instanceof VcsLogStructureFilter) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public Set<Integer> filter(@NotNull List<VcsLogDetailsFilter> detailsFilters) {
        if (detailsFilters == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(27);
        }
        VcsLogTextFilter textFilter = (VcsLogTextFilter)ContainerUtil.findInstance(detailsFilters, VcsLogTextFilter.class);
        VcsLogUserFilter userFilter = (VcsLogUserFilter)ContainerUtil.findInstance(detailsFilters, VcsLogUserFilter.class);
        VcsLogStructureFilter pathFilter = (VcsLogStructureFilter)ContainerUtil.findInstance(detailsFilters, VcsLogStructureFilter.class);
        TIntHashSet filteredByMessage = null;
        if (textFilter != null) {
            filteredByMessage = this.filterMessages(textFilter);
        }
        TIntHashSet filteredByUser = null;
        if (userFilter != null) {
            HashSet users = ContainerUtil.newHashSet();
            for (VirtualFile root : this.myRoots) {
                users.addAll(userFilter.getUsers(root));
            }
            filteredByUser = this.filterUsers(users);
        }
        TIntHashSet filteredByPath = null;
        if (pathFilter != null) {
            filteredByPath = this.filterPaths(pathFilter.getFiles());
        }
        Set<Integer> set2 = TroveUtil.intersect(filteredByMessage, filteredByPath, filteredByUser);
        if (set2 == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(28);
        }
        return set2;
    }

    @Override
    @Nullable
    public IndexDataGetter getDataGetter() {
        if (this.myIndexStorage == null) {
            return null;
        }
        return this.myDataGetter;
    }

    @Override
    public void addListener(@NotNull VcsLogIndex.IndexingFinishedListener l) {
        if (l == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(29);
        }
        this.myListeners.add(l);
    }

    @Override
    public void removeListener(@NotNull VcsLogIndex.IndexingFinishedListener l) {
        if (l == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(30);
        }
        this.myListeners.remove(l);
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fatalErrorsConsumer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposableParent";
                break;
            }
            case 6: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fatalErrorHandler";
                break;
            }
            case 7: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logId";
                break;
            }
            case 8: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detail";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 11: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 12: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/index/VcsLogPersistentIndex";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "users";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 21: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detailsFilters";
                break;
            }
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPersistentIndex";
                break;
            }
            case 13: 
            case 14: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "filter";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "filterUsers";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "filterPaths";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "filterMessages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createIndexStorage";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "storeDetail";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isIndexed";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "markForIndexing";
                break;
            }
            case 11: 
            case 12: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 28: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "filterUsers";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "filterPaths";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "filterMessages";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processRuntimeException";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "canFilter";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$filterMessages$5";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lambda$filterMessages$4";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$filter$3";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$storeDetail$2";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createIndexStorage$1";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createIndexStorage$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class IndexingRequest {
        private static final int BATCH_SIZE = 20000;
        private static final int FLUSHED_COMMITS_NUMBER = 15000;
        @NotNull
        private final VirtualFile myRoot;
        @NotNull
        private final TIntHashSet myCommits;
        private final boolean myFull;
        @NotNull
        private final AtomicInteger myNewIndexedCommits;
        @NotNull
        private final AtomicInteger myOldCommits;

        public IndexingRequest(@NotNull VirtualFile root, TIntHashSet commits, boolean full) {
            if (root == null) {
                IndexingRequest.$$$reportNull$$$0(0);
            }
            if (commits == null) {
                IndexingRequest.$$$reportNull$$$0(1);
            }
            this.myNewIndexedCommits = new AtomicInteger();
            this.myOldCommits = new AtomicInteger();
            this.myRoot = root;
            this.myCommits = commits;
            this.myFull = full;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                IndexingRequest.$$$reportNull$$$0(2);
            }
            indicator.setIndeterminate(false);
            indicator.setFraction(0.0);
            long startTime = System.currentTimeMillis();
            LOG.debug("Indexing " + (this.myFull ? "full repository" : this.myCommits.size() + " commits") + " in " + this.myRoot.getName());
            try {
                try {
                    if (this.myFull) {
                        this.indexAll(indicator);
                    } else {
                        IntStream commits = TroveUtil.stream(this.myCommits).filter(c -> {
                            if (VcsLogPersistentIndex.this.isIndexed(c)) {
                                this.myOldCommits.incrementAndGet();
                                return false;
                            }
                            return true;
                        });
                        this.indexOneByOne(commits, indicator);
                    }
                }
                catch (ProcessCanceledException e) {
                    this.scheduleReindex();
                    throw e;
                }
                catch (VcsException e) {
                    LOG.error((Throwable)e);
                    this.scheduleReindex();
                }
            }
            finally {
                ((AtomicInteger)VcsLogPersistentIndex.this.myNumberOfTasks.get(this.myRoot)).decrementAndGet();
                if (VcsLogPersistentIndex.this.isIndexed(this.myRoot)) {
                    VcsLogPersistentIndex.this.myListeners.forEach(listener2 -> listener2.indexingFinished(this.myRoot));
                }
                this.report(startTime);
                VcsLogPersistentIndex.this.flush();
            }
        }

        private void report(long startTime) {
            String formattedTime = StopWatch.formatTime(System.currentTimeMillis() - startTime);
            if (this.myFull) {
                LOG.debug(formattedTime + " for indexing " + this.myNewIndexedCommits + " commits in " + this.myRoot.getName());
            } else {
                int leftCommits = this.myCommits.size() - this.myNewIndexedCommits.get() - this.myOldCommits.get();
                String leftCommitsMessage = leftCommits > 0 ? ". " + leftCommits + " commits left" : "";
                LOG.debug(formattedTime + " for indexing " + this.myNewIndexedCommits + " new commits out of " + this.myCommits.size() + " in " + this.myRoot.getName() + leftCommitsMessage);
            }
        }

        private void scheduleReindex() {
            LOG.debug("Schedule reindexing of " + (this.myCommits.size() - this.myNewIndexedCommits.get() - this.myOldCommits.get()) + " commits in " + this.myRoot.getName());
            this.myCommits.forEach(value -> {
                VcsLogPersistentIndex.this.markForIndexing(value, this.myRoot);
                return true;
            });
            VcsLogPersistentIndex.this.scheduleIndex(false);
        }

        private void indexOneByOne(@NotNull IntStream commits, @NotNull ProgressIndicator indicator) throws VcsException {
            if (commits == null) {
                IndexingRequest.$$$reportNull$$$0(3);
            }
            if (indicator == null) {
                IndexingRequest.$$$reportNull$$$0(4);
            }
            TroveUtil.processBatches(commits, 20000, (ThrowableConsumer<TIntHashSet, VcsException>)((ThrowableConsumer)batch -> {
                if (indicator == null) {
                    IndexingRequest.$$$reportNull$$$0(8);
                }
                indicator.checkCanceled();
                List<String> hashes = TroveUtil.map(batch, value -> VcsLogPersistentIndex.this.myStorage.getCommitId(value).getHash().asString());
                ((VcsLogProvider)VcsLogPersistentIndex.this.myProviders.get(this.myRoot)).readFullDetails(this.myRoot, hashes, detail -> {
                    VcsLogPersistentIndex.this.storeDetail(detail);
                    this.myNewIndexedCommits.incrementAndGet();
                }, true);
                this.displayProgress(indicator);
            }));
        }

        public void indexAll(@NotNull ProgressIndicator indicator) throws VcsException {
            if (indicator == null) {
                IndexingRequest.$$$reportNull$$$0(5);
            }
            this.displayProgress(indicator);
            ((VcsLogProvider)VcsLogPersistentIndex.this.myProviders.get(this.myRoot)).readAllFullDetails(this.myRoot, details -> {
                if (indicator == null) {
                    IndexingRequest.$$$reportNull$$$0(7);
                }
                VcsLogPersistentIndex.this.storeDetail(details);
                if (this.myNewIndexedCommits.incrementAndGet() % 15000 == 0) {
                    VcsLogPersistentIndex.this.flush();
                }
                indicator.checkCanceled();
                this.displayProgress(indicator);
            });
        }

        public void displayProgress(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                IndexingRequest.$$$reportNull$$$0(6);
            }
            indicator.setFraction(((double)this.myNewIndexedCommits.get() + (double)this.myOldCommits.get()) / (double)this.myCommits.size());
        }

        public String toString() {
            return "IndexingRequest of " + this.myCommits.size() + " commits in " + this.myRoot.getName() + (this.myFull ? " (full)" : "");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commits";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexingRequest";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "indexOneByOne";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "indexAll";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "displayProgress";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$indexAll$6";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$indexOneByOne$5";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MySingleTaskController
    extends SingleTaskController<IndexingRequest, Void> {
        @NotNull
        private final HeavyAwareExecutor myHeavyAwareExecutor;

        public MySingleTaskController(Project project) {
            if (project == null) {
                MySingleTaskController.$$$reportNull$$$0(0);
            }
            super(EmptyConsumer.getInstance(), false);
            this.myHeavyAwareExecutor = new HeavyAwareExecutor(project, 50, 100, VcsLogPersistentIndex.this);
        }

        @Override
        @NotNull
        protected ProgressIndicator startNewBackgroundTask() {
            ProgressIndicator indicator = VcsLogPersistentIndex.this.myProgress.createProgressIndicator(false);
            ApplicationManager.getApplication().invokeLater(() -> {
                Task.Backgroundable task2 = new Task.Backgroundable(VcsLogPersistentIndex.this.myProject, "Indexing Commit Data", true, PerformInBackgroundOption.ALWAYS_BACKGROUND){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        try {
                            IndexingRequest request;
                            while ((request = (IndexingRequest)MySingleTaskController.this.popRequest()) != null) {
                                try {
                                    request.run(indicator);
                                    indicator.checkCanceled();
                                }
                                catch (ProcessCanceledException reThrown) {
                                    throw reThrown;
                                }
                                catch (Throwable t) {
                                    LOG.error("Error while indexing", t);
                                }
                            }
                        }
                        finally {
                            MySingleTaskController.this.taskCompleted(null);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$MySingleTaskController$1", "run"));
                    }
                };
                this.myHeavyAwareExecutor.executeOutOfHeavyOrPowerSave(task2, indicator);
            });
            ProgressIndicator progressIndicator = indicator;
            if (progressIndicator == null) {
                MySingleTaskController.$$$reportNull$$$0(1);
            }
            return progressIndicator;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$MySingleTaskController";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$MySingleTaskController";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "startNewBackgroundTask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class IndexStorage {
        private static final String COMMITS = "commits";
        private static final String MESSAGES = "messages";
        private static final String PARENTS = "parents";
        private static final int MESSAGES_VERSION = 0;
        @NotNull
        public final PersistentSet<Integer> commits;
        @NotNull
        public final PersistentMap<Integer, String> messages;
        @NotNull
        public final PersistentMap<Integer, List<Integer>> parents;
        @NotNull
        public final VcsLogMessagesTrigramIndex trigrams;
        @NotNull
        public final VcsLogUserIndex users;
        @NotNull
        public final VcsLogPathsIndex paths;
        private volatile boolean myIsFresh;

        public IndexStorage(@NotNull String logId, @NotNull VcsUserRegistryImpl userRegistry, @NotNull Set<VirtualFile> roots, @NotNull FatalErrorHandler fatalErrorHandler, @NotNull Disposable parentDisposable) throws IOException {
            if (logId == null) {
                IndexStorage.$$$reportNull$$$0(0);
            }
            if (userRegistry == null) {
                IndexStorage.$$$reportNull$$$0(1);
            }
            if (roots == null) {
                IndexStorage.$$$reportNull$$$0(2);
            }
            if (fatalErrorHandler == null) {
                IndexStorage.$$$reportNull$$$0(3);
            }
            if (parentDisposable == null) {
                IndexStorage.$$$reportNull$$$0(4);
            }
            Disposable disposable = Disposer.newDisposable();
            Disposer.register((Disposable)parentDisposable, (Disposable)disposable);
            try {
                int version = VcsLogPersistentIndex.getVersion();
                File commitsStorage = PersistentUtil.getStorageFile("index", COMMITS, logId, version);
                this.myIsFresh = !commitsStorage.exists();
                this.commits = new PersistentSetImpl<Integer>(commitsStorage, (KeyDescriptor<Integer>)EnumeratorIntegerDescriptor.INSTANCE, Page.PAGE_SIZE, null, version);
                Disposer.register((Disposable)disposable, () -> IndexStorage.catchAndWarn((ThrowableRunnable<IOException>)((ThrowableRunnable)this.commits::close)));
                File messagesStorage = PersistentUtil.getStorageFile("index", MESSAGES, logId, 5);
                this.messages = new PersistentHashMap(messagesStorage, (KeyDescriptor)new IntInlineKeyDescriptor(), (DataExternalizer)EnumeratorStringDescriptor.INSTANCE, Page.PAGE_SIZE);
                Disposer.register((Disposable)disposable, () -> IndexStorage.catchAndWarn((ThrowableRunnable<IOException>)((ThrowableRunnable)() -> this.messages.close())));
                this.trigrams = new VcsLogMessagesTrigramIndex(logId, fatalErrorHandler, disposable);
                this.users = new VcsLogUserIndex(logId, userRegistry, fatalErrorHandler, disposable);
                this.paths = new VcsLogPathsIndex(logId, roots, fatalErrorHandler, disposable);
                File parentsStorage = PersistentUtil.getStorageFile("index", PARENTS, logId, version);
                this.parents = new PersistentHashMap(parentsStorage, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)new IntListDataExternalizer(), Page.PAGE_SIZE, version);
                Disposer.register((Disposable)disposable, () -> IndexStorage.catchAndWarn((ThrowableRunnable<IOException>)((ThrowableRunnable)() -> this.parents.close())));
            }
            catch (Throwable t) {
                Disposer.dispose((Disposable)disposable);
                throw t;
            }
        }

        void markCorrupted() {
            IndexStorage.catchAndWarn((ThrowableRunnable<IOException>)((ThrowableRunnable)this.commits::markCorrupted));
        }

        private static void catchAndWarn(@NotNull ThrowableRunnable<IOException> runnable2) {
            if (runnable2 == null) {
                IndexStorage.$$$reportNull$$$0(5);
            }
            try {
                runnable2.run();
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        }

        private static void cleanup(@NotNull String logId) {
            if (logId == null) {
                IndexStorage.$$$reportNull$$$0(6);
            }
            if (!PersistentUtil.cleanupStorageFiles("index", logId)) {
                LOG.error("Could not clean up storage files in " + new File(PersistentUtil.LOG_CACHE, "index") + " starting with " + logId);
            }
        }

        public void unmarkFresh() {
            this.myIsFresh = false;
        }

        public boolean isFresh() {
            return this.myIsFresh;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "userRegistry";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fatalErrorHandler";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentDisposable";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexStorage";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "catchAndWarn";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "cleanup";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

