/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl.stubs;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.StringRef;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.stubs.CustomTargetExpressionStubType;
import com.jetbrains.python.psi.impl.stubs.PyNamedTupleStubType;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.stubs.PyNamedTupleStub;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyNamedTupleStubImpl
implements PyNamedTupleStub {
    @Nullable
    private final QualifiedName myCalleeName;
    @NotNull
    private final String myName;
    @NotNull
    private final LinkedHashMap<String, Optional<String>> myFields;

    private PyNamedTupleStubImpl(@Nullable QualifiedName calleeName, @NotNull String name, @NotNull LinkedHashMap<String, Optional<String>> fields) {
        if (name == null) {
            PyNamedTupleStubImpl.$$$reportNull$$$0(0);
        }
        if (fields == null) {
            PyNamedTupleStubImpl.$$$reportNull$$$0(1);
        }
        this.myCalleeName = calleeName;
        this.myName = name;
        this.myFields = fields;
    }

    @Nullable
    public static PyNamedTupleStub create(@NotNull PyTargetExpression expression) {
        PyExpression assignedValue;
        if (expression == null) {
            PyNamedTupleStubImpl.$$$reportNull$$$0(2);
        }
        if ((assignedValue = expression.findAssignedValue()) instanceof PyCallExpression) {
            return PyNamedTupleStubImpl.create((PyCallExpression)assignedValue);
        }
        return null;
    }

    @Nullable
    public static PyNamedTupleStub create(@NotNull PyCallExpression expression) {
        PyReferenceExpression calleeReference;
        if (expression == null) {
            PyNamedTupleStubImpl.$$$reportNull$$$0(3);
        }
        if ((calleeReference = PyUtil.as(expression.getCallee(), PyReferenceExpression.class)) == null) {
            return null;
        }
        Pair<QualifiedName, NamedTupleModule> calleeNameAndModule = PyNamedTupleStubImpl.getCalleeNameAndNTModule(calleeReference);
        if (calleeNameAndModule != null) {
            String name = PyNamedTupleStubImpl.resolveTupleName(expression);
            if (name == null) {
                return null;
            }
            LinkedHashMap<String, Optional<String>> fields = PyNamedTupleStubImpl.resolveTupleFields(expression, (NamedTupleModule)((Object)calleeNameAndModule.getSecond()));
            if (fields == null) {
                return null;
            }
            return new PyNamedTupleStubImpl((QualifiedName)calleeNameAndModule.getFirst(), name, fields);
        }
        return null;
    }

    @Nullable
    public static PyNamedTupleStub deserialize(@NotNull StubInputStream stream) throws IOException {
        if (stream == null) {
            PyNamedTupleStubImpl.$$$reportNull$$$0(4);
        }
        StringRef calleeName = stream.readName();
        StringRef name = stream.readName();
        LinkedHashMap<String, Optional<String>> fields = PyNamedTupleStubImpl.deserializeFields(stream, stream.readVarInt());
        if (calleeName == null || name == null) {
            return null;
        }
        return new PyNamedTupleStubImpl(QualifiedName.fromDottedString((String)calleeName.getString()), name.getString(), fields);
    }

    @Override
    @NotNull
    public Class<? extends CustomTargetExpressionStubType> getTypeClass() {
        if (PyNamedTupleStubType.class == null) {
            PyNamedTupleStubImpl.$$$reportNull$$$0(5);
        }
        return PyNamedTupleStubType.class;
    }

    @Override
    public void serialize(@NotNull StubOutputStream stream) throws IOException {
        if (stream == null) {
            PyNamedTupleStubImpl.$$$reportNull$$$0(6);
        }
        stream.writeName(this.myCalleeName == null ? null : this.myCalleeName.toString());
        stream.writeName(this.myName);
        stream.writeVarInt(this.myFields.size());
        for (Map.Entry<String, Optional<String>> entry : this.myFields.entrySet()) {
            stream.writeName(entry.getKey());
            stream.writeName((String)entry.getValue().orElse(null));
        }
    }

    @Override
    @Nullable
    public QualifiedName getCalleeName() {
        return this.myCalleeName;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            PyNamedTupleStubImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    public Map<String, Optional<String>> getFields() {
        LinkedHashMap<String, Optional<String>> linkedHashMap = this.myFields;
        if (linkedHashMap == null) {
            PyNamedTupleStubImpl.$$$reportNull$$$0(8);
        }
        return linkedHashMap;
    }

    @Nullable
    private static Pair<QualifiedName, NamedTupleModule> getCalleeNameAndNTModule(@NotNull PyReferenceExpression referenceExpression) {
        Pair<QualifiedName, NamedTupleModule> name;
        if (referenceExpression == null) {
            PyNamedTupleStubImpl.$$$reportNull$$$0(9);
        }
        if ((name = PyNamedTupleStubImpl.getFullyQCalleeNameAndNTModule(referenceExpression)) != null) {
            return name;
        }
        return PyNamedTupleStubImpl.getImportedCalleeNameAndNTModule(referenceExpression);
    }

    @Nullable
    private static String resolveTupleName(@NotNull PyCallExpression callExpression) {
        PyExpression nameExpression;
        if (callExpression == null) {
            PyNamedTupleStubImpl.$$$reportNull$$$0(10);
        }
        if ((nameExpression = PyPsiUtils.flattenParens(callExpression.getArgument(0, PyExpression.class))) instanceof PyReferenceExpression) {
            return PyPsiUtils.strValue(PyNamedTupleStubImpl.fullResolveLocally((PyReferenceExpression)nameExpression));
        }
        return PyPsiUtils.strValue(nameExpression);
    }

    @Nullable
    private static LinkedHashMap<String, Optional<String>> resolveTupleFields(@NotNull PyCallExpression callExpression, @NotNull NamedTupleModule module2) {
        if (callExpression == null) {
            PyNamedTupleStubImpl.$$$reportNull$$$0(11);
        }
        if (module2 == null) {
            PyNamedTupleStubImpl.$$$reportNull$$$0(12);
        }
        switch (module2) {
            case TYPING: {
                return PyNamedTupleStubImpl.resolveTypingNTFields(callExpression);
            }
            case COLLECTIONS: {
                return PyNamedTupleStubImpl.resolveCollectionsNTFields(callExpression);
            }
        }
        return null;
    }

    @NotNull
    private static LinkedHashMap<String, Optional<String>> deserializeFields(@NotNull StubInputStream stream, int fieldsSize) throws IOException {
        if (stream == null) {
            PyNamedTupleStubImpl.$$$reportNull$$$0(13);
        }
        LinkedHashMap<String, Optional<String>> fields = new LinkedHashMap<String, Optional<String>>(fieldsSize);
        for (int i = 0; i < fieldsSize; ++i) {
            String name = StringRef.toString((StringRef)stream.readName());
            String type = StringRef.toString((StringRef)stream.readName());
            if (name == null) continue;
            fields.put(name, Optional.ofNullable(type));
        }
        LinkedHashMap<String, Optional<String>> linkedHashMap = fields;
        if (linkedHashMap == null) {
            PyNamedTupleStubImpl.$$$reportNull$$$0(14);
        }
        return linkedHashMap;
    }

    @Nullable
    private static Pair<QualifiedName, NamedTupleModule> getFullyQCalleeNameAndNTModule(@NotNull PyReferenceExpression referenceExpression) {
        PyReferenceExpression qualifierReference;
        PyExpression qualifier;
        NamedTupleModule module2;
        String referenceName;
        if (referenceExpression == null) {
            PyNamedTupleStubImpl.$$$reportNull$$$0(15);
        }
        NamedTupleModule namedTupleModule = "namedtuple".equals(referenceName = referenceExpression.getName()) ? NamedTupleModule.COLLECTIONS : (module2 = "NamedTuple".equals(referenceName) ? NamedTupleModule.TYPING : null);
        if (module2 != null && (qualifier = referenceExpression.getQualifier()) instanceof PyReferenceExpression && !(qualifierReference = (PyReferenceExpression)qualifier).isQualified() && PyNamedTupleStubImpl.resolvesToModule(qualifierReference, module2)) {
            return Pair.createNonNull((Object)QualifiedName.fromComponents((String[])new String[]{qualifierReference.getName(), referenceName}), (Object)((Object)module2));
        }
        return null;
    }

    @Nullable
    private static Pair<QualifiedName, NamedTupleModule> getImportedCalleeNameAndNTModule(@NotNull PyReferenceExpression referenceExpression) {
        if (referenceExpression == null) {
            PyNamedTupleStubImpl.$$$reportNull$$$0(16);
        }
        for (PsiElement element : PyResolveUtil.resolveLocally(referenceExpression)) {
            PyFromImportStatement fromImportStatement;
            PyStatement importStatement;
            PyImportElement importElement;
            QualifiedName importedQName;
            NamedTupleModule module2;
            if (!(element instanceof PyImportElement) || (module2 = PyNamedTupleStubImpl.equals(importedQName = (importElement = (PyImportElement)element).getImportedQName(), "namedtuple") ? NamedTupleModule.COLLECTIONS : (PyNamedTupleStubImpl.equals(importedQName, "NamedTuple") ? NamedTupleModule.TYPING : null)) == null || !((importStatement = importElement.getContainingImportStatement()) instanceof PyFromImportStatement) || !PyNamedTupleStubImpl.equals((fromImportStatement = (PyFromImportStatement)importStatement).getImportSourceQName(), module2.getModuleName())) continue;
            return Pair.createNonNull((Object)QualifiedName.fromComponents((String[])new String[]{referenceExpression.getName()}), (Object)((Object)module2));
        }
        return null;
    }

    private static boolean resolvesToModule(@NotNull PyReferenceExpression referenceExpression, @NotNull NamedTupleModule module2) {
        if (referenceExpression == null) {
            PyNamedTupleStubImpl.$$$reportNull$$$0(17);
        }
        if (module2 == null) {
            PyNamedTupleStubImpl.$$$reportNull$$$0(18);
        }
        for (PsiElement element : PyResolveUtil.resolveLocally(referenceExpression)) {
            PyImportElement importElement;
            if (!(element instanceof PyImportElement) || !PyNamedTupleStubImpl.equals((importElement = (PyImportElement)element).getImportedQName(), module2.getModuleName())) continue;
            return true;
        }
        return false;
    }

    private static boolean equals(@Nullable QualifiedName qualifiedName, @NotNull String name) {
        if (name == null) {
            PyNamedTupleStubImpl.$$$reportNull$$$0(19);
        }
        return qualifiedName != null && name.equals(qualifiedName.toString());
    }

    @Nullable
    private static PyExpression fullResolveLocally(@NotNull PyReferenceExpression referenceExpression) {
        if (referenceExpression == null) {
            PyNamedTupleStubImpl.$$$reportNull$$$0(20);
        }
        for (PsiElement element : PyResolveUtil.resolveLocally(referenceExpression)) {
            if (!(element instanceof PyTargetExpression)) continue;
            PyExpression assignedValue = ((PyTargetExpression)element).findAssignedValue();
            if (assignedValue instanceof PyReferenceExpression) {
                return PyNamedTupleStubImpl.fullResolveLocally((PyReferenceExpression)assignedValue);
            }
            return assignedValue;
        }
        return null;
    }

    @Nullable
    private static LinkedHashMap<String, Optional<String>> resolveCollectionsNTFields(@NotNull PyCallExpression callExpression) {
        PyExpression fields;
        if (callExpression == null) {
            PyNamedTupleStubImpl.$$$reportNull$$$0(21);
        }
        PyExpression resolvedFields = (fields = PyPsiUtils.flattenParens(callExpression.getArgument(1, PyExpression.class))) instanceof PyReferenceExpression ? PyNamedTupleStubImpl.fullResolveLocally((PyReferenceExpression)fields) : fields;
        Collector<String, ?, LinkedHashMap> toFieldsOfUnknownType = Collectors.toMap(Function.identity(), key -> Optional.empty(), (v1, v2) -> v2, LinkedHashMap::new);
        List<String> listValue = PyUtil.strListValue(resolvedFields);
        if (listValue != null) {
            return listValue.contains(null) ? null : (LinkedHashMap)StreamEx.of(listValue).collect(toFieldsOfUnknownType);
        }
        String resolvedFieldsValue = PyPsiUtils.strValue(resolvedFields);
        if (resolvedFieldsValue == null) {
            return null;
        }
        return (LinkedHashMap)StreamEx.of(StringUtil.tokenize((String)resolvedFieldsValue, (String)", ").iterator()).collect(toFieldsOfUnknownType);
    }

    @Nullable
    private static LinkedHashMap<String, Optional<String>> resolveTypingNTFields(@NotNull PyCallExpression callExpression) {
        PyExpression resolvedFields;
        PyExpression secondArgument;
        if (callExpression == null) {
            PyNamedTupleStubImpl.$$$reportNull$$$0(22);
        }
        if ((secondArgument = PyPsiUtils.flattenParens(callExpression.getArgument(1, PyExpression.class))) instanceof PyKeywordArgument) {
            PyExpression[] arguments = callExpression.getArguments();
            return PyNamedTupleStubImpl.getTypingNTFieldsFromKwArguments(Arrays.asList(arguments).subList(1, arguments.length));
        }
        PyExpression pyExpression = resolvedFields = secondArgument instanceof PyReferenceExpression ? PyNamedTupleStubImpl.fullResolveLocally((PyReferenceExpression)secondArgument) : secondArgument;
        if (!(resolvedFields instanceof PySequenceExpression)) {
            return null;
        }
        return PyNamedTupleStubImpl.getTypingNTFieldsFromIterable((PySequenceExpression)resolvedFields);
    }

    @Nullable
    private static LinkedHashMap<String, Optional<String>> getTypingNTFieldsFromKwArguments(@NotNull List<PyExpression> arguments) {
        if (arguments == null) {
            PyNamedTupleStubImpl.$$$reportNull$$$0(23);
        }
        LinkedHashMap<String, Optional<String>> result2 = new LinkedHashMap<String, Optional<String>>();
        for (PyExpression argument : arguments) {
            if (!(argument instanceof PyKeywordArgument)) {
                return null;
            }
            PyKeywordArgument keywordArgument = (PyKeywordArgument)argument;
            String keyword = keywordArgument.getKeyword();
            if (keyword == null) {
                return null;
            }
            result2.put(keyword, Optional.ofNullable(PyNamedTupleStubImpl.textIfPresent((PsiElement)keywordArgument.getValueExpression())));
        }
        return result2;
    }

    @Nullable
    private static LinkedHashMap<String, Optional<String>> getTypingNTFieldsFromIterable(@NotNull PySequenceExpression fields) {
        if (fields == null) {
            PyNamedTupleStubImpl.$$$reportNull$$$0(24);
        }
        LinkedHashMap<String, Optional<String>> result2 = new LinkedHashMap<String, Optional<String>>();
        for (PyExpression element : fields.getElements()) {
            if (!(element instanceof PyParenthesizedExpression)) {
                return null;
            }
            PyExpression contained = ((PyParenthesizedExpression)element).getContainedExpression();
            if (!(contained instanceof PyTupleExpression)) {
                return null;
            }
            Object[] nameAndType = ((PyTupleExpression)contained).getElements();
            PyExpression name = (PyExpression)ArrayUtil.getFirstElement((Object[])nameAndType);
            if (nameAndType.length != 2 || !(name instanceof PyStringLiteralExpression)) {
                return null;
            }
            result2.put(((PyStringLiteralExpression)name).getStringValue(), Optional.ofNullable(PyNamedTupleStubImpl.textIfPresent((PsiElement)nameAndType[1])));
        }
        return result2;
    }

    @Nullable
    private static String textIfPresent(@Nullable PsiElement element) {
        return element == null ? null : element.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: 
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/stubs/PyNamedTupleStubImpl";
                break;
            }
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 10: 
            case 11: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/stubs/PyNamedTupleStubImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeClass";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFields";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "deserializeFields";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 14: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCalleeNameAndNTModule";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveTupleName";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "resolveTupleFields";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "deserializeFields";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getFullyQCalleeNameAndNTModule";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getImportedCalleeNameAndNTModule";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "resolvesToModule";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "equals";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "fullResolveLocally";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "resolveCollectionsNTFields";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "resolveTypingNTFields";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getTypingNTFieldsFromKwArguments";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getTypingNTFieldsFromIterable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum NamedTupleModule {
        COLLECTIONS{

            @Override
            public String getModuleName() {
                return "collections";
            }
        }
        ,
        TYPING{

            @Override
            public String getModuleName() {
                return "typing";
            }
        };


        public abstract String getModuleName();
    }
}

