/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.rename;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.usageView.UsageInfo;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.search.PyOverridingMethodsSearch;
import java.util.Collection;

public class PyParametersRenameFactory
implements AutomaticRenamerFactory {
    @Override
    public boolean isApplicable(PsiElement element) {
        if (element instanceof PyParameter) {
            PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class);
            return function != null && function.getContainingClass() != null;
        }
        return false;
    }

    @Override
    public String getOptionName() {
        return "Rename parameters in hierarchy";
    }

    @Override
    public boolean isEnabled() {
        return PyCodeInsightSettings.getInstance().RENAME_PARAMETERS_IN_HIERARCHY;
    }

    @Override
    public void setEnabled(boolean enabled) {
        PyCodeInsightSettings.getInstance().RENAME_PARAMETERS_IN_HIERARCHY = enabled;
    }

    @Override
    public AutomaticRenamer createRenamer(PsiElement element, String newName, Collection<UsageInfo> usages) {
        return new PyParametersRenamer((PyParameter)element, newName);
    }

    public static class PyParametersRenamer
    extends AutomaticRenamer {
        public PyParametersRenamer(PyParameter element, String newName) {
            PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class);
            PyOverridingMethodsSearch.search(function, true).forEach(pyFunction -> {
                PyParameter[] parameters;
                for (PyParameter parameter : parameters = pyFunction.getParameterList().getParameters()) {
                    PyNamedParameter named = parameter.getAsNamed();
                    if (named == null || !Comparing.equal((String)named.getName(), (String)element.getName())) continue;
                    this.myElements.add(named);
                }
                return true;
            });
            this.suggestAllNames(element.getName(), newName);
        }

        @Override
        public String getDialogTitle() {
            return "Rename Parameters";
        }

        @Override
        public String getDialogDescription() {
            return "Rename parameter in hierarchy to:";
        }

        @Override
        public String entityName() {
            return "Parameter";
        }

        @Override
        public boolean isSelectedByDefault() {
            return true;
        }
    }
}

