/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command;

import org.netbeans.lib.cvsclient.command.AbstractParser;
import org.netbeans.lib.cvsclient.event.ICvsListenerRegistry;
import org.netbeans.lib.cvsclient.event.IMessageListener;
import org.netbeans.lib.cvsclient.event.TaggedMessageParser;

public abstract class AbstractMessageParser
extends AbstractParser
implements IMessageListener {
    private final TaggedMessageParser taggedMessageParser = new TaggedMessageParser();

    protected abstract void parseLine(String var1, boolean var2);

    @Override
    public void registerListeners(ICvsListenerRegistry listenerRegistry) {
        listenerRegistry.addMessageListener(this);
        super.registerListeners(listenerRegistry);
    }

    @Override
    public void unregisterListeners(ICvsListenerRegistry listenerRegistry) {
        super.unregisterListeners(listenerRegistry);
        listenerRegistry.removeMessageListener(this);
    }

    @Override
    public final void messageSent(String message, byte[] byteMessage, boolean error, boolean tagged) {
        if (tagged) {
            String parsedMessage = this.taggedMessageParser.parseTaggedMessage(message);
            if (parsedMessage != null) {
                this.parseLine(parsedMessage, false);
            }
        } else {
            String taggedLine = this.taggedMessageParser.getString();
            if (taggedLine != null) {
                this.parseLine(taggedLine, false);
            }
            this.parseLine(message, error);
        }
    }

    @Override
    public final void commandTerminated(boolean error) {
        String taggedLine = this.taggedMessageParser.getString();
        if (taggedLine != null) {
            this.parseLine(taggedLine, false);
        }
        super.commandTerminated(error);
    }

    @Override
    public void binaryMessageSent(byte[] bytes) {
    }
}

