/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.framework;

import com.ibm.xmi.framework.AdapterFactoryRegister;
import com.ibm.xmi.framework.Data;
import com.ibm.xmi.framework.Factory;
import com.ibm.xmi.framework.FactoryRegister;
import com.ibm.xmi.framework.FileWriter;
import com.ibm.xmi.framework.MIME2Java;
import com.ibm.xmi.framework.Namespace;
import com.ibm.xmi.framework.ObjectWriterWrapper;
import com.ibm.xmi.framework.PrintXML;
import com.ibm.xmi.framework.WriterFactory;
import com.ibm.xmi.framework.XMIFiles;
import com.ibm.xmi.framework.XMILoad;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class XMIFile {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999-2002. All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int DEFAULT = 1;
    public static final int OBJECTS_ONLY = 2;
    public static final int PRESERVE_WHITESPACE = 4;
    public static final int REFERENCES_AT_TOP = 8;
    public static final int NAMESPACES_IN_FEATURES = 16;
    private String encoding = "UTF-8";
    protected int indent = 2;
    String xmiVersion = "2.0";
    String timestamp;
    String exporter = "XMI Framework";
    String exporterVersion = "1.2";
    String owner;
    String contact;
    String longDescription;
    String shortDescription;
    String notice;
    private boolean verified;
    private Vector topObjects;
    private Vector unmatchedElements;
    private Vector header;
    private ZipOutputStream zos;
    private OutputStream outputStream;
    private String dtd;
    private String entry;
    private String filename;
    private String loadFilename;
    private Factory factory = FactoryRegister.getFactory();
    private XMIFiles files;
    private boolean printTimestamp = true;
    private ObjectWriterWrapper wrapper;
    private Vector assignedObjects;

    public XMIFile(OutputStream outputStream, String string) {
        this.outputStream = outputStream;
        this.filename = string;
    }

    public XMIFile(String string) {
        this.filename = string;
    }

    XMIFile(String string, String string2) {
        this.filename = string;
        this.loadFilename = string2;
    }

    public XMIFile(ZipOutputStream zipOutputStream, String string) {
        this.zos = zipOutputStream;
        this.entry = string;
    }

    public void add(Object object) {
        if (this.topObjects == null) {
            this.topObjects = new Vector();
        }
        this.topObjects.addElement(object);
    }

    public void add(Model model) {
        if (this.header == null) {
            this.header = new Vector();
        }
        this.header.addElement(model);
    }

    public void add(Metamodel metamodel) {
        if (this.header == null) {
            this.header = new Vector();
        }
        this.header.addElement(metamodel);
    }

    public void add(Metametamodel metametamodel) {
        if (this.header == null) {
            this.header = new Vector();
        }
        this.header.addElement(metametamodel);
    }

    public void add(Namespace namespace) {
        if (this.header == null) {
            this.header = new Vector();
        }
        this.header.addElement(namespace);
    }

    public void add(Import import_) {
        if (this.header == null) {
            this.header = new Vector();
        }
        this.header.addElement(import_);
    }

    public void addUnmatchedElement(Data data) {
        if (this.unmatchedElements == null) {
            this.unmatchedElements = new Vector();
        }
        this.unmatchedElements.addElement(data);
    }

    public String getContact() {
        return this.contact;
    }

    public String getDTD() {
        return this.dtd;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getEntry() {
        return this.entry;
    }

    public String getExporter() {
        return this.exporter;
    }

    public String getExporterVersion() {
        return this.exporterVersion;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getLoadFilename() {
        return this.loadFilename;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public String getNotice() {
        return this.notice;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public XMIFiles getXMIFiles() {
        return this.files;
    }

    public String getXMIVersion() {
        return this.xmiVersion;
    }

    public boolean isVerified() {
        return this.verified;
    }

    public Collection getHeader() {
        if (this.header == null) {
            return new Vector(1);
        }
        return Collections.unmodifiableCollection(this.header);
    }

    public Collection getImports() {
        Vector vector = new Vector();
        if (this.header == null) {
            return vector;
        }
        int n = 0;
        while (n < this.header.size()) {
            if (this.header.elementAt(n) instanceof Import) {
                vector.addElement(this.header.elementAt(n));
            }
            ++n;
        }
        return vector;
    }

    public Collection getMetamodels() {
        Vector vector = new Vector();
        if (this.header == null) {
            return vector;
        }
        int n = 0;
        while (n < this.header.size()) {
            if (this.header.elementAt(n) instanceof Metamodel) {
                vector.addElement(this.header.elementAt(n));
            }
            ++n;
        }
        return vector;
    }

    public Collection getMetametamodels() {
        Vector vector = new Vector();
        if (this.header == null) {
            return vector;
        }
        int n = 0;
        while (n < this.header.size()) {
            if (this.header.elementAt(n) instanceof Metametamodel) {
                vector.addElement(this.header.elementAt(n));
            }
            ++n;
        }
        return vector;
    }

    public Collection getModels() {
        Vector vector = new Vector();
        if (this.header == null) {
            return vector;
        }
        int n = 0;
        while (n < this.header.size()) {
            if (this.header.elementAt(n) instanceof Model && !(this.header.elementAt(n) instanceof Metamodel) && !(this.header.elementAt(n) instanceof Metametamodel)) {
                vector.addElement(this.header.elementAt(n));
            }
            ++n;
        }
        return vector;
    }

    public Namespace getNamespace(String string) {
        if (this.header == null) {
            return null;
        }
        int n = 0;
        while (n < this.header.size()) {
            Namespace namespace;
            if (this.header.elementAt(n) instanceof Namespace && (namespace = (Namespace)this.header.elementAt(n)).getPrefix() != null && namespace.getPrefix().equals(string)) {
                return namespace;
            }
            ++n;
        }
        return null;
    }

    public Collection getNamespaces() {
        Vector vector = new Vector();
        if (this.header == null) {
            return vector;
        }
        int n = 0;
        while (n < this.header.size()) {
            if (this.header.elementAt(n) instanceof Namespace) {
                vector.addElement(this.header.elementAt(n));
            }
            ++n;
        }
        return vector;
    }

    public Collection getObjects() {
        if (this.topObjects == null) {
            return new Vector(1);
        }
        return Collections.unmodifiableCollection(this.topObjects);
    }

    public void setObjects(Iterator iterator) {
        this.topObjects = new Vector();
        while (iterator.hasNext()) {
            this.topObjects.addElement(iterator.next());
        }
    }

    public Collection getUnmatchedElements() {
        if (this.unmatchedElements == null) {
            return new Vector(1);
        }
        return Collections.unmodifiableCollection(this.unmatchedElements);
    }

    public boolean isPrintTimestamp() {
        return this.printTimestamp;
    }

    public static XMIFile load(String string, int n, boolean bl) throws Exception {
        return XMIFile.load(string, null, n, bl);
    }

    public static XMIFile load(String string, InputStream inputStream, int n, boolean bl) throws Exception {
        XMILoad xMILoad = new XMILoad(string, inputStream, n, bl, null);
        return xMILoad.load();
    }

    public void setContact(String string) {
        this.contact = string;
    }

    public void setDTD(String string) {
        this.dtd = string;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setEntry(String string) {
        this.entry = string;
    }

    public void setExporter(String string) {
        this.exporter = string;
    }

    public void setExporterVersion(String string) {
        this.exporterVersion = string;
    }

    public void setIndent(int n) {
        this.indent = n;
    }

    public void setLongDescription(String string) {
        this.longDescription = string;
    }

    public void setNotice(String string) {
        this.notice = string;
    }

    public void setOwner(String string) {
        this.owner = string;
    }

    public void setShortDescription(String string) {
        this.shortDescription = string;
    }

    public void setTimestamp(String string) {
        this.timestamp = string;
    }

    public void setXMIFiles(XMIFiles xMIFiles) {
        this.files = xMIFiles;
    }

    public void setXMIVersion(String string) {
        this.xmiVersion = string;
    }

    public void setVerified(boolean bl) {
        this.verified = bl;
    }

    public void setPrintTimestamp(boolean bl) {
        this.printTimestamp = bl;
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public void setZipOutputStream(ZipOutputStream zipOutputStream) {
        this.zos = zipOutputStream;
    }

    public void write(Iterator iterator, int n) throws Exception {
        Object object;
        this.topObjects = new Vector();
        if (iterator != null) {
            while (iterator.hasNext()) {
                this.topObjects.addElement(iterator.next());
            }
        }
        String string = MIME2Java.convert(this.encoding);
        PrintWriter printWriter = null;
        OutputStream outputStream = this.outputStream;
        if (this.zos != null) {
            printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)this.zos, string)));
            this.zos.putNextEntry(new ZipEntry(this.entry));
        } else {
            if (this.outputStream == null && this.filename != null) {
                object = new File(this.filename);
                String string2 = ((File)object).getParent();
                if (string2 != null) {
                    File file = new File(string2);
                    file.mkdirs();
                }
                object = new File(this.filename);
                outputStream = new FileOutputStream((File)object);
            }
            if (outputStream != null) {
                printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream, string)));
            }
        }
        PrintXML.setPrintWriter(printWriter);
        this.wrapper = new ObjectWriterWrapper(AdapterFactoryRegister.getAdapterFactory().createObjectWriterAdapter());
        object = WriterFactory.makeFileWriter(this);
        ((FileWriter)object).setOption(n);
        ((FileWriter)object).setWriterWrapper(this.wrapper);
        ((FileWriter)object).write(0, this.indent);
        printWriter.flush();
        if (this.zos != null) {
            this.zos.closeEntry();
        } else if (outputStream != this.outputStream) {
            outputStream.close();
        }
    }

    public String toString() {
        return "filename: " + this.filename + "  entry: " + this.entry;
    }

    public static class Import {
        private String name;
        private String version;
        private String href;

        public Import(String string, String string2, String string3) {
            this.name = string;
            this.version = string2;
            this.href = string3;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public String getHref() {
            return this.href;
        }

        public String toString() {
            return "Import name: " + this.name + " version: " + this.version + " href: " + this.href;
        }
    }

    public static class Metametamodel
    extends Model {
        public Metametamodel(String string, String string2, String string3) {
            super(string, string2, string3);
        }

        public String toString() {
            return "Metametamodel name: " + this.name + " version: " + this.version + " href: " + this.href;
        }
    }

    public static class Metamodel
    extends Model {
        public Metamodel(String string, String string2, String string3) {
            super(string, string2, string3);
        }

        public String toString() {
            return "Metamodel name: " + this.name + " version: " + this.version + " href: " + this.href;
        }
    }

    public static class Model {
        protected String name;
        protected String version;
        protected String href;

        public Model(String string, String string2, String string3) {
            this.name = string;
            this.version = string2;
            this.href = string3;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public String getHref() {
            return this.href;
        }

        public String toString() {
            return "Model name: " + this.name + " version: " + this.version + " href: " + this.href;
        }
    }
}

