Avogadro 2
==========
![Avogadro 2][Avogadro2Logo]

Introduction
------------

Avogadro is an advanced molecular editor designed for cross-platform use in
computational chemistry, molecular modeling, bioinformatics, materials science,
and related areas. It offers flexible rendering and a powerful plugin
architecture. The code in this repository is a rewrite of Avogadro with source
code split across a libraries repository and an application repository. Core
features and goals of the Avogadro project:

* Open source distributed under the liberal 3-clause BSD license
* Cross platform with nightly builds on Linux, Mac OS X and Windows
* Intuitive interface designed to be useful to whole community
* Fast and efficient embracing the latest technologies
* Extensible, making extensive use of a plugin architecture
* Flexible supporting a range of chemical data formats and packages

![Open Chemistry project][OpenChemistryLogo]
![Kitware, Inc.][KitwareLogo]

Avogadro 2 is being developed as part of the [Open Chemistry][OpenChemistry]
project at [Kitware][Kitware], along with companion tools and libraries to
support the work. The Avogadro 1.x series currently has more features, and can
be found [here][Avogadro1]. We will be porting more features to the Avogadro 2
code base, and making regular releases to get feedback from the community.

Installing
----------

We provide nightly binaries built by our [dashboards][Dashboard] for Mac OS
X and Windows. If you would like to build from source we recommend that you
follow our [building Open Chemistry][Build] guide that will take care of
building most dependencies.

Contributing
------------

Our project uses the standard GitHub pull request process for code review
and integration. Please check our [development][Development] guide for more
details on developing and contributing to the project. The GitHub issue
tracker can be used to report bugs, make feature requests, etc.

Our [wiki][Wiki] is used to document features, flesh out designs and host other
documentation. Our API is [documented using Doxygen][Doxygen] with updated
documentation generated nightly. We have several [mailing lists][MailingLists]
to coordinate development and to provide support.

  [Avogadro2Logo]: http://openchemistry.org/files/logos/avogadro2.png "Avogadro2"
  [OpenChemistry]: http://openchemistry.org/ "Open Chemistry Project"
  [OpenChemistryLogo]: http://openchemistry.org/files/logos/openchem128.png "Open Chemistry"
  [Kitware]: http://kitware.com/ "Kitware, Inc."
  [KitwareLogo]: http://www.kitware.com/img/small_logo_over.png "Kitware"
  [Avogadro1]: http://avogadro.openmolecules.net/ "Avogadro 1"
  [Dashboard]: http://cdash.openchemistry.org/index.php?project=AvogadroLibs "Avogadro Dashboard"
  [Build]: http://wiki.openchemistry.org/Build "Building Avogadro"
  [Development]: http://wiki.openchemistry.org/Development "Development guide"
  [Wiki]: http://wiki.openchemistry.org/ "Open Chemistry wiki"
  [Doxygen]: http://doc.openchemistry.org/avogadrolibs/api/ "API documentation"
  [MailingLists]: http://openchemistry.org/mailing-lists "Mailing Lists"
