/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.normalizer.content;

import java.io.IOException;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.State;
import org.jfree.layouting.StateException;
import org.jfree.layouting.StatefullComponent;
import org.jfree.layouting.input.style.PageAreaType;
import org.jfree.layouting.input.style.PseudoPage;
import org.jfree.layouting.input.style.keys.box.BoxStyleKeys;
import org.jfree.layouting.input.style.keys.box.DisplayRole;
import org.jfree.layouting.input.style.keys.content.ContentStyleKeys;
import org.jfree.layouting.input.style.keys.content.MoveToValues;
import org.jfree.layouting.input.style.values.CSSAutoValue;
import org.jfree.layouting.input.style.values.CSSStringValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.input.style.values.CSSValueList;
import org.jfree.layouting.layouter.content.ContentToken;
import org.jfree.layouting.layouter.content.computed.CloseQuoteToken;
import org.jfree.layouting.layouter.content.computed.ComputedToken;
import org.jfree.layouting.layouter.content.computed.ContentsToken;
import org.jfree.layouting.layouter.content.computed.CounterToken;
import org.jfree.layouting.layouter.content.computed.CountersToken;
import org.jfree.layouting.layouter.content.computed.OpenQuoteToken;
import org.jfree.layouting.layouter.content.computed.VariableToken;
import org.jfree.layouting.layouter.content.resolved.ResolvedCounterToken;
import org.jfree.layouting.layouter.content.resolved.ResolvedCountersToken;
import org.jfree.layouting.layouter.content.resolved.ResolvedStringToken;
import org.jfree.layouting.layouter.content.statics.StaticTextToken;
import org.jfree.layouting.layouter.context.ContentSpecification;
import org.jfree.layouting.layouter.context.ContextId;
import org.jfree.layouting.layouter.context.DefaultLayoutContext;
import org.jfree.layouting.layouter.context.DefaultPageContext;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.context.LayoutStyle;
import org.jfree.layouting.layouter.context.QuotesPair;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.resolver.StyleResolver;
import org.jfree.layouting.normalizer.content.NormalizationException;
import org.jfree.layouting.normalizer.content.Normalizer;
import org.jfree.layouting.normalizer.content.RecordingContentNormalizer;
import org.jfree.layouting.normalizer.displaymodel.ModelBuilder;
import org.jfree.layouting.renderer.Renderer;
import org.jfree.layouting.util.AttributeMap;
import org.jfree.layouting.util.ChainingCallException;
import org.jfree.layouting.util.IntList;

public class ContentNormalizer
implements Normalizer {
    private static final long NO_PARENT = -1L;
    private ModelBuilder modelBuilder;
    private LayoutElement currentElement;
    private LayoutElement currentSilbling;
    private LayoutProcess layoutProcess;
    private RecordingContentNormalizer recordingContentNormalizer;
    private long nextId;
    private int ignoreContext;
    private int quoteLevel;
    private StyleResolver styleResolver;

    public ContentNormalizer(LayoutProcess layoutProcess) {
        this(layoutProcess, true);
    }

    protected ContentNormalizer(LayoutProcess layoutProcess, boolean bl) {
        if (layoutProcess == null) {
            throw new NullPointerException("LayoutProcess must not be null.");
        }
        this.layoutProcess = layoutProcess;
        this.styleResolver = layoutProcess.getStyleResolver();
        if (bl) {
            this.modelBuilder = layoutProcess.getOutputProcessor().createModelBuilder(layoutProcess);
        }
    }

    public void startDocument() throws IOException, NormalizationException {
        this.styleResolver.initialize(this.layoutProcess);
        DefaultPageContext defaultPageContext = new DefaultPageContext();
        PageAreaType[] pageAreaTypeArray = PageAreaType.getPageAreas();
        for (int i = 0; i < pageAreaTypeArray.length; ++i) {
            PageAreaType pageAreaType = pageAreaTypeArray[i];
            LayoutStyle layoutStyle = this.styleResolver.resolvePageStyle(CSSAutoValue.getInstance(), new PseudoPage[0], pageAreaType);
            defaultPageContext.setAreaDefinition(pageAreaType, layoutStyle);
        }
        LayoutStyle layoutStyle = defaultPageContext.getAreaDefinition(PageAreaType.CONTENT);
        this.modelBuilder.startDocument(defaultPageContext);
    }

    public void startElement(String string, String string2, AttributeMap attributeMap) throws NormalizationException, IOException {
        if (this.recordingContentNormalizer != null) {
            this.recordingContentNormalizer.startElement(string, string2, attributeMap);
            return;
        }
        this.startElementInternal(string, string2, null, attributeMap);
    }

    protected void startElementInternal(String string, String string2, String string3, AttributeMap attributeMap) throws NormalizationException, IOException {
        LayoutElement layoutElement;
        ContextId contextId = new ContextId(1, -1L, this.nextId);
        ++this.nextId;
        DefaultLayoutContext defaultLayoutContext = new DefaultLayoutContext(contextId, string, string2, string3, attributeMap);
        this.currentElement = layoutElement = new LayoutElement(this.currentElement, this.currentSilbling, defaultLayoutContext);
        this.currentSilbling = null;
        this.styleResolver.resolveStyle(layoutElement);
        if (this.isStringRecordingNeeded(layoutElement)) {
            this.recordingContentNormalizer = new RecordingContentNormalizer();
        } else {
            this.startCurrentElement();
        }
    }

    private void startCurrentElement() throws NormalizationException, IOException {
        LayoutContext layoutContext = this.currentElement.getLayoutContext();
        CSSValue cSSValue = layoutContext.getValue(BoxStyleKeys.DISPLAY_ROLE);
        if (DisplayRole.NONE.equals(cSSValue)) {
            ++this.ignoreContext;
        } else if (this.ignoreContext > 0) {
            ++this.ignoreContext;
        }
        if (DisplayRole.LIST_ITEM.equals(cSSValue)) {
            this.currentElement.incrementCounter("list-item", 1);
        }
        if (this.ignoreContext > 0) {
            return;
        }
        ContentSpecification contentSpecification = this.currentElement.getLayoutContext().getContentSpecification();
        if (!contentSpecification.isAllowContentProcessing()) {
            if (contentSpecification.isInhibitContent() && layoutContext.isPseudoElement()) {
                this.modelBuilder.startElement(this.currentElement.detachLayoutContext());
                ++this.ignoreContext;
                return;
            }
            this.generateOutsidePseudoElements(this.currentElement);
            this.modelBuilder.startElement(this.currentElement.detachLayoutContext());
            this.generateBeforePseudoElements(this.currentElement);
            this.generateContentBefore(this.currentElement);
            ++this.ignoreContext;
            return;
        }
        this.generateOutsidePseudoElements(this.currentElement);
        this.modelBuilder.startElement(this.currentElement.detachLayoutContext());
        this.generateBeforePseudoElements(this.currentElement);
        this.generateContentBefore(this.currentElement);
        if (!this.currentElement.isContentsConsumed() && !this.generateAlternateContent(this.currentElement)) {
            ++this.ignoreContext;
        }
    }

    protected boolean generateBeforePseudoElements(LayoutElement layoutElement) throws IOException, NormalizationException {
        LayoutContext layoutContext = layoutElement.getLayoutContext();
        CSSValue cSSValue = layoutContext.getValue(BoxStyleKeys.DISPLAY_ROLE);
        if (DisplayRole.LIST_ITEM.equals(cSSValue) && this.styleResolver.isPseudoElementStyleResolvable(layoutElement, "marker")) {
            this.startElementInternal(layoutContext.getNamespace(), layoutContext.getTagName(), "marker", layoutContext.getAttributes());
            this.endElement();
        }
        if (this.styleResolver.isPseudoElementStyleResolvable(layoutElement, "before")) {
            this.startElementInternal(layoutContext.getNamespace(), layoutContext.getTagName(), "before", layoutContext.getAttributes());
            this.endElement();
        }
        return false;
    }

    private boolean generateAlternateContent(LayoutElement layoutElement) throws IOException, NormalizationException {
        if (layoutElement.isContentsConsumed()) {
            return false;
        }
        if (this.styleResolver.isPseudoElementStyleResolvable(layoutElement, "alternate")) {
            LayoutContext layoutContext = layoutElement.getLayoutContext();
            this.startElementInternal(layoutContext.getNamespace(), layoutContext.getTagName(), "alternate", layoutContext.getAttributes());
            if (layoutElement.isContentsConsumed()) {
                layoutElement.openAlternate();
                return true;
            }
            this.endElement();
        }
        return false;
    }

    private boolean generateOutsidePseudoElements(LayoutElement layoutElement) throws IOException, NormalizationException {
        LayoutContext layoutContext = layoutElement.getLayoutContext();
        CSSValue cSSValue = layoutContext.getValue(ContentStyleKeys.MOVE_TO);
        if (!MoveToValues.HERE.equals(cSSValue)) {
            String string;
            if (cSSValue == null) {
                string = null;
            } else if (cSSValue instanceof CSSStringValue) {
                CSSStringValue cSSStringValue = (CSSStringValue)cSSValue;
                string = cSSStringValue.getValue();
            } else {
                string = cSSValue.getCSSText();
            }
            layoutContext.getContentSpecification().setMoveTarget(string);
            if (this.styleResolver.isPseudoElementStyleResolvable(layoutElement, "alternate")) {
                this.startElementInternal(layoutContext.getNamespace(), layoutContext.getTagName(), "alternate", layoutContext.getAttributes());
                if (layoutElement.isContentsConsumed()) {
                    layoutElement.openAlternate();
                } else {
                    this.endElement();
                }
            }
        }
        return false;
    }

    private boolean isStringRecordingNeeded(LayoutElement layoutElement) {
        ContentSpecification contentSpecification = layoutElement.getLayoutContext().getContentSpecification();
        ContentToken[] contentTokenArray = contentSpecification.getStrings();
        LayoutContext layoutContext = layoutElement.getLayoutContext();
        CSSValue cSSValue = layoutContext.getValue(ContentStyleKeys.STRING_DEFINE);
        if (cSSValue == null) {
            return false;
        }
        if (cSSValue instanceof CSSValueList) {
            CSSValueList cSSValueList = (CSSValueList)cSSValue;
            if (cSSValueList.getLength() == 0) {
                return false;
            }
            for (int i = 0; i < cSSValueList.getLength(); ++i) {
                CSSValue cSSValue2 = cSSValueList.getItem(i);
                if (!(cSSValue2 instanceof ContentsToken)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean generateContentBefore(LayoutElement layoutElement) throws IOException, NormalizationException {
        ContentSpecification contentSpecification = layoutElement.getLayoutContext().getContentSpecification();
        ContentToken[] contentTokenArray = contentSpecification.getContents();
        for (int i = 0; i < contentTokenArray.length; ++i) {
            ContentToken contentToken = contentTokenArray[i];
            if (contentToken instanceof ContentsToken) {
                layoutElement.setContentsConsumed(true);
                return true;
            }
            if (contentToken instanceof ComputedToken) {
                ContentToken contentToken2 = this.computeToken(contentToken, contentSpecification);
                if (contentToken2 == null) continue;
                this.addContent(contentToken2);
                continue;
            }
            this.addContent(contentToken);
        }
        return false;
    }

    protected void generateContentAfter(LayoutElement layoutElement) throws IOException, NormalizationException {
        ContentToken contentToken;
        int n;
        ContentSpecification contentSpecification = layoutElement.getLayoutContext().getContentSpecification();
        ContentToken[] contentTokenArray = contentSpecification.getContents();
        for (n = 0; n < contentTokenArray.length && !((contentToken = contentTokenArray[n]) instanceof ContentsToken); ++n) {
        }
        ++n;
        while (n < contentTokenArray.length) {
            contentToken = contentTokenArray[n];
            if (!(contentToken instanceof ContentsToken)) {
                if (contentToken instanceof ComputedToken) {
                    ContentToken contentToken2 = this.computeToken(contentToken, contentSpecification);
                    if (contentToken2 != null) {
                        this.addContent(contentToken2);
                    }
                } else {
                    this.addContent(contentToken);
                }
            }
            ++n;
        }
    }

    protected void generateStrings(LayoutElement layoutElement) throws IOException, NormalizationException {
        ContentSpecification contentSpecification = layoutElement.getLayoutContext().getContentSpecification();
        ContentToken[] contentTokenArray = contentSpecification.getContents();
        boolean bl = false;
        for (int i = 0; i < contentTokenArray.length; ++i) {
            Object object;
            ContentToken contentToken = contentTokenArray[i];
            if (contentToken instanceof ContentsToken) {
                if (bl) continue;
                object = this.recordingContentNormalizer.getText();
                this.addContent(new ResolvedStringToken((ComputedToken)contentToken, (String)object));
                bl = true;
                continue;
            }
            if (contentToken instanceof ComputedToken) {
                object = this.computeToken(contentToken, contentSpecification);
                if (object == null) continue;
                this.addContent((ContentToken)object);
                continue;
            }
            this.addContent(contentToken);
        }
    }

    protected void generateAfterPseudoElements(LayoutElement layoutElement) throws IOException, NormalizationException {
        LayoutContext layoutContext = layoutElement.getLayoutContext();
        if (this.styleResolver.isPseudoElementStyleResolvable(layoutElement, "after")) {
            this.startElementInternal(layoutContext.getNamespace(), layoutContext.getTagName(), "after", layoutContext.getAttributes());
            this.endElement();
        }
    }

    public void addText(String string) throws NormalizationException, IOException {
        if (this.ignoreContext > 0) {
            if (this.recordingContentNormalizer != null) {
                this.recordingContentNormalizer.addText(string);
            }
            return;
        }
        this.modelBuilder.addContent(new StaticTextToken(string));
    }

    private void addContent(ContentToken contentToken) throws NormalizationException {
        if (contentToken instanceof ComputedToken) {
            throw new NormalizationException("ComputedContent cannot be added.");
        }
        if (this.ignoreContext == 0) {
            this.modelBuilder.addContent(contentToken);
        }
    }

    private ContentToken computeToken(ContentToken contentToken, ContentSpecification contentSpecification) {
        if (contentToken instanceof CloseQuoteToken) {
            CloseQuoteToken closeQuoteToken = (CloseQuoteToken)contentToken;
            if (closeQuoteToken.isSurpressQuoteText()) {
                --this.quoteLevel;
                return null;
            }
            --this.quoteLevel;
            QuotesPair quotesPair = this.getQuotesPair();
            if (quotesPair != null) {
                return new ResolvedStringToken(closeQuoteToken, quotesPair.getCloseQuote());
            }
        } else if (contentToken instanceof OpenQuoteToken) {
            OpenQuoteToken openQuoteToken = (OpenQuoteToken)contentToken;
            if (openQuoteToken.isSurpressQuoteText()) {
                ++this.quoteLevel;
                return null;
            }
            QuotesPair quotesPair = this.getQuotesPair();
            ++this.quoteLevel;
            if (quotesPair != null) {
                return new ResolvedStringToken(openQuoteToken, quotesPair.getOpenQuote());
            }
        } else {
            if (contentToken instanceof VariableToken) {
                VariableToken variableToken = (VariableToken)contentToken;
                String string = this.currentElement.getString(variableToken.getVariable());
                return new ResolvedStringToken(variableToken, string);
            }
            if (contentToken instanceof CounterToken) {
                CounterToken counterToken = (CounterToken)contentToken;
                String string = counterToken.getName();
                int n = this.currentElement.getCounterValue(string);
                return new ResolvedCounterToken(counterToken, n);
            }
            if (contentToken instanceof CountersToken) {
                CountersToken countersToken = (CountersToken)contentToken;
                String string = countersToken.getName();
                IntList intList = new IntList(10);
                while (this.currentElement != null) {
                    if (this.currentElement.isCounterDefined(string)) {
                        intList.add(this.currentElement.getCounterValue(string));
                    }
                    this.currentElement = this.currentElement.getParent();
                }
                int n = intList.size();
                int[] nArray = new int[n];
                for (int i = 0; i < n; ++i) {
                    nArray[i] = intList.get(n - i - 1);
                }
                return new ResolvedCountersToken(countersToken, nArray);
            }
        }
        return null;
    }

    private QuotesPair getQuotesPair() {
        ContentSpecification contentSpecification = this.currentElement.getLayoutContext().getContentSpecification();
        QuotesPair[] quotesPairArray = contentSpecification.getQuotes();
        int n = Math.min(quotesPairArray.length - 1, this.quoteLevel);
        if (n == -1) {
            return null;
        }
        return quotesPairArray[n];
    }

    public void endElement() throws NormalizationException, IOException {
        LayoutContext layoutContext;
        Object object;
        if (this.currentElement == null) {
            throw new NullPointerException("This is unexpected: I dont have a current element.");
        }
        if (this.ignoreContext > 1) {
            --this.ignoreContext;
            if (this.recordingContentNormalizer != null) {
                this.recordingContentNormalizer.endElement();
            }
            this.currentSilbling = this.currentElement;
            this.currentElement = this.currentElement.getParent();
            return;
        }
        if (this.ignoreContext == 1 && DisplayRole.NONE.equals(object = (layoutContext = this.currentElement.getLayoutContext()).getValue(BoxStyleKeys.DISPLAY_ROLE))) {
            this.currentSilbling = this.currentElement;
            this.currentElement = this.currentElement.getParent();
            this.ignoreContext = 0;
            this.recordingContentNormalizer = null;
            return;
        }
        if (this.currentElement.isAlternateOpen()) {
            this.endElement();
        }
        if (this.ignoreContext == 1) {
            layoutContext = this.currentElement.getLayoutContext();
            object = layoutContext.getContentSpecification();
            this.generateStrings(this.currentElement);
            if (!((ContentSpecification)object).isAllowContentProcessing()) {
                if (!((ContentSpecification)object).isInhibitContent() || !layoutContext.isPseudoElement()) {
                    this.generateAfterPseudoElements(this.currentElement);
                }
            } else {
                this.generateContentAfter(this.currentElement);
                this.generateAfterPseudoElements(this.currentElement);
            }
            this.ignoreContext = 0;
            if (this.recordingContentNormalizer != null) {
                try {
                    this.recordingContentNormalizer.replay(this);
                    this.recordingContentNormalizer = null;
                }
                catch (ChainingCallException chainingCallException) {}
            }
        } else {
            this.generateContentAfter(this.currentElement);
            this.generateAfterPseudoElements(this.currentElement);
        }
        this.modelBuilder.endElement();
        if (this.currentElement.isAlternateOpen()) {
            this.endElement();
        }
        this.currentSilbling = this.currentElement;
        this.currentElement = this.currentElement.getParent();
    }

    public void endDocument() throws IOException, NormalizationException {
        this.modelBuilder.endDocument();
    }

    public void handlePageBreak(CSSValue cSSValue, PseudoPage[] pseudoPageArray) {
        DefaultPageContext defaultPageContext = new DefaultPageContext();
        PageAreaType[] pageAreaTypeArray = PageAreaType.getPageAreas();
        for (int i = 0; i < pageAreaTypeArray.length; ++i) {
            PageAreaType pageAreaType = pageAreaTypeArray[i];
            if (this.styleResolver == null) {
                throw new IllegalStateException();
            }
            LayoutStyle layoutStyle = this.styleResolver.resolvePageStyle(cSSValue, pseudoPageArray, pageAreaType);
            defaultPageContext.setAreaDefinition(pageAreaType, layoutStyle);
        }
        try {
            this.modelBuilder.handlePageBreak(defaultPageContext);
        }
        catch (NormalizationException normalizationException) {
            throw new IllegalStateException();
        }
    }

    protected ContentNormalizerState createSaveState() {
        return new ContentNormalizerState();
    }

    protected void fillState(ContentNormalizerState contentNormalizerState) throws StateException {
        contentNormalizerState.setNextId(this.nextId);
        contentNormalizerState.setCurrentElement(this.currentElement);
        contentNormalizerState.setCurrentSilbling(this.currentSilbling);
        contentNormalizerState.setModelBuilderState(this.modelBuilder.saveState());
        if (this.recordingContentNormalizer != null) {
            contentNormalizerState.setRecordingContentNormalizerState(this.recordingContentNormalizer.saveState());
        }
    }

    public State saveState() throws StateException {
        ContentNormalizerState contentNormalizerState = this.createSaveState();
        this.fillState(contentNormalizerState);
        return contentNormalizerState;
    }

    protected void restore(ContentNormalizerState contentNormalizerState) throws StateException {
        this.currentElement = contentNormalizerState.getCurrentElement();
        this.currentSilbling = contentNormalizerState.getCurrentSilbling();
        this.nextId = contentNormalizerState.getNextId();
        this.modelBuilder = (ModelBuilder)contentNormalizerState.getModelBuilderState().restore(this.layoutProcess);
        if (contentNormalizerState.getRecordingContentNormalizerState() != null) {
            this.recordingContentNormalizer = (RecordingContentNormalizer)contentNormalizerState.getRecordingContentNormalizerState().restore(this.layoutProcess);
        }
    }

    public Renderer getRenderer() {
        return this.modelBuilder.getRenderer();
    }

    public StyleResolver getStyleResolver() {
        if (this.styleResolver == null) {
            throw new IllegalStateException("Document has not yet been initialized?");
        }
        return this.styleResolver;
    }

    protected static class ContentNormalizerState
    implements State {
        private State modelBuilderState;
        private LayoutElement currentElement;
        private LayoutElement currentSilbling;
        private long nextId;
        private State recordingContentNormalizerState;

        protected ContentNormalizerState() {
        }

        public State getRecordingContentNormalizerState() {
            return this.recordingContentNormalizerState;
        }

        public void setRecordingContentNormalizerState(State state) {
            this.recordingContentNormalizerState = state;
        }

        public State getModelBuilderState() {
            return this.modelBuilderState;
        }

        public void setModelBuilderState(State state) {
            this.modelBuilderState = state;
        }

        public LayoutElement getCurrentElement() {
            return this.currentElement;
        }

        public void setCurrentElement(LayoutElement layoutElement) {
            this.currentElement = layoutElement;
        }

        public LayoutElement getCurrentSilbling() {
            return this.currentSilbling;
        }

        public void setCurrentSilbling(LayoutElement layoutElement) {
            this.currentSilbling = layoutElement;
        }

        public long getNextId() {
            return this.nextId;
        }

        public void setNextId(long l) {
            this.nextId = l;
        }

        public StatefullComponent restore(LayoutProcess layoutProcess) throws StateException {
            ContentNormalizer contentNormalizer = new ContentNormalizer(layoutProcess, false);
            contentNormalizer.restore(this);
            return contentNormalizer;
        }
    }
}

