/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.Macro;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import java.io.IOException;

public class BgChar
extends Macro {
    private int charCode;

    public BgChar() {
        this('{');
    }

    public BgChar(char c) {
        this((int)c);
    }

    public BgChar(int n) {
        this.charCode = n;
    }

    @Override
    public Object clone() {
        return new BgChar(this.charCode);
    }

    @Override
    public String format() {
        return String.format("%c", Character.valueOf((char)this.charCode));
    }

    @Override
    public String toString(TeXParser teXParser) {
        return "" + teXParser.getBgChar();
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList();
        teXObjectList.add(teXParser.getListener().getOther(this.charCode));
        return teXObjectList;
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        Group group = this.createGroup(teXParser);
        teXObjectList.popRemainingGroup(teXParser, group, false, this);
        teXObjectList.push(group);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        Group group = this.createGroup(teXParser);
        teXParser.popRemainingGroup(group, false, this);
        teXParser.push(group);
    }

    public String show(TeXParser teXParser) throws IOException {
        return String.format("begin-group character %c", Character.valueOf((char)this.charCode));
    }

    public int getCharCode() {
        return this.charCode;
    }

    public Group createGroup(TeXParser teXParser) {
        return teXParser.getListener().createGroup();
    }
}

