/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.bib;

import com.dickimawbooks.texparserlib.CharObject;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.WhiteSpace;
import com.dickimawbooks.texparserlib.bib.BibData;
import com.dickimawbooks.texparserlib.bib.BibTeXSyntaxException;
import com.dickimawbooks.texparserlib.bib.BibUserString;
import com.dickimawbooks.texparserlib.bib.BibValue;
import com.dickimawbooks.texparserlib.bib.BibValueList;
import com.dickimawbooks.texparserlib.bib.Contributor;
import com.dickimawbooks.texparserlib.bib.EtAl;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class BibEntry
extends BibData {
    private HashMap<String, BibValueList> fields;
    private String entryType;
    private String id;
    private BibValueList idValue;
    private static final byte CASE_LOWER = 0;
    private static final byte CASE_UPPER = 1;
    private static final byte CASE_NA = 2;

    public BibEntry(String string) {
        this.entryType = string;
        this.fields = new HashMap();
    }

    @Override
    public String getEntryType() {
        return this.entryType;
    }

    public boolean isEntryType(String string) {
        if (this.entryType == null || string == null) {
            return false;
        }
        return this.entryType.toLowerCase().equals(string.toLowerCase());
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getId() {
        return this.id;
    }

    public BibValueList getIdField() {
        return this.idValue;
    }

    public BibValueList removeField(String string) {
        return this.fields.remove(string);
    }

    public void putField(String string, BibValueList bibValueList) {
        if (string == null) {
            throw new NullPointerException();
        }
        String string2 = this.getKey(string);
        if (string2 != null && !string.equals(string2)) {
            this.fields.remove(string2);
        }
        this.fields.put(string, bibValueList);
    }

    public Set<String> getKeySet() {
        return this.fields.keySet();
    }

    public String getKey(String string) {
        BibValue bibValue = this.fields.get(string);
        if (bibValue != null) {
            return string;
        }
        Set<String> set = this.fields.keySet();
        Iterator<String> iterator = set.iterator();
        String string2 = string.toLowerCase();
        while (iterator.hasNext()) {
            String string3 = iterator.next();
            if (!string2.equals(string3.toLowerCase())) continue;
            return string3;
        }
        return null;
    }

    public BibValueList getField(String string) {
        BibValueList bibValueList = this.fields.get(string);
        if (bibValueList != null) {
            return bibValueList;
        }
        String string2 = this.getKey(string);
        if (string2 != null) {
            return this.fields.get(string2);
        }
        return null;
    }

    @Override
    public void parseContents(TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject) throws IOException {
        TeXObjectList teXObjectList2 = this.readKeyObject(teXParser, teXObjectList);
        String string = teXObjectList2.format();
        if (string.isEmpty()) {
            throw new BibTeXSyntaxException(teXParser, "bibtex.error.missing_field_name");
        }
        this.setId(string);
        BibValueList bibValueList = new BibValueList();
        bibValueList.add(new BibUserString(teXObjectList2));
        this.idValue = bibValueList;
        TeXObject teXObject2 = teXObjectList.popStack(teXParser);
        while (teXObject2 != null && teXObject2 instanceof WhiteSpace) {
            teXObject2 = teXObjectList.popStack(teXParser);
        }
        if (teXObject2 == null) {
            return;
        }
        if (!(teXObject2 instanceof CharObject) || ((CharObject)teXObject2).getCharCode() != 44) {
            throw new BibTeXSyntaxException(teXParser, "bibtex.error.expecting_or", new String[]{",", teXObject.format()});
        }
        while (!teXObjectList.isEmpty()) {
            String string2 = this.readKey(teXParser, teXObjectList);
            teXObject2 = teXObjectList.popStack(teXParser);
            while (teXObject2 != null && teXObject2 instanceof WhiteSpace) {
                teXObject2 = teXObjectList.popStack(teXParser);
            }
            if (teXObject2 == null) {
                throw new BibTeXSyntaxException(teXParser, "bibtex.error.immediately_follows_field_name", teXObject.format());
            }
            if (!(teXObject2 instanceof CharObject) || ((CharObject)teXObject2).getCharCode() != 61) {
                throw new BibTeXSyntaxException(teXParser, "bibtex.error.immediately_follows_field_name", teXObject2.format());
            }
            bibValueList = new BibValueList();
            this.readValue(teXParser, teXObjectList, bibValueList, teXObject);
            if (bibValueList.isEmpty()) {
                throw new BibTeXSyntaxException(teXParser, "bibtex.error.missing_field_part");
            }
            this.putField(string2, bibValueList);
        }
    }

    @Override
    public String format(byte by, char c, char c2, byte by2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("@%s%c%s", BibEntry.applyCase(this.entryType, by), Character.valueOf(c), this.id));
        Set<String> set = this.fields.keySet();
        for (String string : set) {
            stringBuilder.append(String.format(",%n  %s = %s", BibEntry.applyCase(string, by), this.fields.get(string).applyDelim(by2)));
        }
        stringBuilder.append(String.format("%n%c%n", Character.valueOf(c2)));
        return stringBuilder.toString();
    }

    public String toString() {
        return String.format("%s[type=%s,id=%s]", this.getClass().getSimpleName(), this.entryType, this.id);
    }

    public Vector<Contributor> getEditors(TeXParser teXParser) throws IOException {
        BibValueList bibValueList = this.getField("editor");
        if (bibValueList == null) {
            return null;
        }
        return BibEntry.parseContributors(teXParser, bibValueList);
    }

    public Vector<Contributor> getAuthors(TeXParser teXParser) throws IOException {
        BibValueList bibValueList = this.getField("author");
        if (bibValueList == null) {
            return null;
        }
        return BibEntry.parseContributors(teXParser, bibValueList);
    }

    public static Vector<Contributor> parseContributors(TeXParser teXParser, BibValueList bibValueList) throws IOException {
        Vector<Contributor> vector = new Vector<Contributor>();
        TeXObjectList teXObjectList = bibValueList.expand(teXParser);
        TeXObjectList teXObjectList2 = null;
        Vector<TeXObjectList> vector2 = new Vector<TeXObjectList>();
        while (!teXObjectList.isEmpty()) {
            TeXObject teXObject = teXObjectList.pop();
            if (teXObjectList2 == null) {
                if (teXObject instanceof CharObject) {
                    if (((CharObject)teXObject).getCharCode() == 97) {
                        if (teXObjectList.size() > 3) {
                            TeXObject teXObject2 = teXObjectList.pop();
                            TeXObject teXObject3 = teXObjectList.pop();
                            TeXObject teXObject4 = teXObjectList.pop();
                            if (teXObject2 instanceof CharObject && ((CharObject)teXObject2).getCharCode() == 110 && teXObject3 instanceof CharObject && ((CharObject)teXObject3).getCharCode() == 100 && teXObject4 instanceof WhiteSpace) {
                                vector.add(BibEntry.parseContributor(teXParser, vector2));
                                vector2 = new Vector();
                                continue;
                            }
                            teXObjectList2 = new TeXObjectList();
                            teXObjectList2.add(teXObject);
                            teXObjectList2.add(teXObject2);
                            teXObjectList2.add(teXObject3);
                            teXObjectList2.add(teXObject4);
                            continue;
                        }
                        teXObjectList2 = new TeXObjectList();
                        teXObjectList2.add(teXObject);
                        continue;
                    }
                    teXObjectList2 = new TeXObjectList();
                    teXObjectList2.add(teXObject);
                    if (((CharObject)teXObject).getCharCode() != 44) continue;
                    vector2.add(teXObjectList2);
                    teXObjectList2 = null;
                    continue;
                }
                if (teXObject instanceof WhiteSpace) continue;
                teXObjectList2 = new TeXObjectList();
                teXObjectList2.add(teXObject);
                continue;
            }
            if (teXObject instanceof CharObject && ((CharObject)teXObject).getCharCode() == 44) {
                vector2.add(teXObjectList2);
                teXObjectList2 = new TeXObjectList();
                teXObjectList2.add(teXObject);
                vector2.add(teXObjectList2);
                teXObjectList2 = null;
                continue;
            }
            if (teXObject instanceof WhiteSpace) {
                vector2.add(teXObjectList2);
                teXObjectList2 = null;
                continue;
            }
            teXObjectList2.add(teXObject);
        }
        if (teXObjectList2 != null) {
            vector2.add(teXObjectList2);
        }
        vector.add(BibEntry.parseContributor(teXParser, vector2));
        return vector;
    }

    private static Contributor parseContributor(TeXParser teXParser, Vector<TeXObjectList> vector) throws IOException {
        TeXObject teXObject;
        TeXObject teXObject2;
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < vector.size(); ++i) {
            teXObject2 = vector.get(i);
            if (teXObject2.size() == 1) {
                teXObject = (TeXObject)teXObject2.firstElement();
                if (teXObject instanceof CharObject && ((CharObject)teXObject).getCharCode() == 44) {
                    ++n;
                    stringBuffer.append(",");
                    continue;
                }
                if (i > 0) {
                    stringBuffer.append(String.format(" %s", teXObject.format()));
                    continue;
                }
                stringBuffer.append(teXObject.format());
                continue;
            }
            if (i > 0) {
                stringBuffer.append(String.format(" %s", teXObject2.format()));
                continue;
            }
            stringBuffer.append(teXObject2.format());
        }
        if (stringBuffer.toString().equals("others")) {
            return new EtAl();
        }
        TeXObject teXObject3 = null;
        teXObject2 = null;
        teXObject = null;
        TeXObject teXObject4 = null;
        switch (n) {
            case 0: {
                if (vector.isEmpty()) {
                    return new Contributor();
                }
                if (vector.size() == 1) {
                    teXObject4 = vector.firstElement();
                    break;
                }
                teXObject4 = new TeXObjectList();
                int n2 = vector.size() - 1;
                for (int i = 0; i <= n2; ++i) {
                    TeXObjectList teXObjectList = vector.get(i);
                    if (teXObject4 == null && BibEntry.startsWithLower(teXObjectList)) {
                        teXObject2 = BibEntry.appendName(teXParser, teXObject2, teXObjectList);
                        continue;
                    }
                    if (teXObject2 != null || i == n2) {
                        teXObject4 = BibEntry.appendName(teXParser, teXObject4, teXObjectList);
                        continue;
                    }
                    teXObject3 = BibEntry.appendName(teXParser, teXObject3, teXObjectList);
                }
                break;
            }
            case 1: {
                int n3 = vector.size();
                for (int i = 0; i < n3; ++i) {
                    TeXObjectList teXObjectList = vector.get(i);
                    if (BibEntry.isComma(teXObjectList)) {
                        if (++i >= n3) continue;
                        teXObject3 = vector.get(i);
                        continue;
                    }
                    if (teXObject4 == null && BibEntry.startsWithLower(teXObjectList)) {
                        teXObject2 = BibEntry.appendName(teXParser, teXObject2, teXObjectList);
                        continue;
                    }
                    if (teXObject3 == null) {
                        teXObject4 = BibEntry.appendName(teXParser, teXObject4, teXObjectList);
                        continue;
                    }
                    teXObject3 = BibEntry.appendName(teXParser, teXObject3, teXObjectList);
                }
                break;
            }
            case 2: {
                int n4 = vector.size();
                for (int i = 0; i < n4; ++i) {
                    TeXObjectList teXObjectList = vector.get(i);
                    if (BibEntry.isComma(teXObjectList)) {
                        if (++i >= n4) continue;
                        if (teXObject == null) {
                            teXObject = vector.get(i);
                            continue;
                        }
                        teXObject3 = vector.get(i);
                        continue;
                    }
                    if (teXObject4 == null && BibEntry.startsWithLower(teXObjectList)) {
                        teXObject2 = BibEntry.appendName(teXParser, teXObject2, teXObjectList);
                        continue;
                    }
                    if (teXObject == null) {
                        teXObject4 = BibEntry.appendName(teXParser, teXObject4, teXObjectList);
                        continue;
                    }
                    if (teXObject3 == null) {
                        teXObject = BibEntry.appendName(teXParser, teXObject, teXObjectList);
                        continue;
                    }
                    teXObject3 = BibEntry.appendName(teXParser, teXObject3, teXObjectList);
                }
                break;
            }
            default: {
                throw new BibTeXSyntaxException(teXParser, "bibtex.error.too_many_commas", stringBuffer.toString());
            }
        }
        return new Contributor(teXObject3, teXObject2, teXObject4, teXObject);
    }

    private static TeXObject appendName(TeXParser teXParser, TeXObject teXObject, TeXObjectList teXObjectList) {
        if (teXObject == null) {
            teXObject = teXObjectList;
        } else {
            TeXObjectList teXObjectList2;
            if (teXObject instanceof TeXObjectList && !(teXObject instanceof Group)) {
                teXObjectList2 = (TeXObjectList)teXObject;
            } else {
                teXObjectList2 = new TeXObjectList();
                teXObjectList2.add(teXObject);
                teXObject = teXObjectList2;
            }
            teXObjectList2.add(teXParser.getListener().getSpace());
            teXObjectList2.add(teXObjectList);
        }
        return teXObject;
    }

    private static boolean isComma(TeXObjectList teXObjectList) {
        if (teXObjectList.size() == 1) {
            TeXObject teXObject = (TeXObject)teXObjectList.firstElement();
            return teXObject instanceof CharObject && ((CharObject)teXObject).getCharCode() == 44;
        }
        return false;
    }

    protected static boolean startsWithLower(TeXObjectList teXObjectList) {
        return BibEntry.getInitialCase(teXObjectList) == 0;
    }

    private static byte getInitialCase(TeXObjectList teXObjectList) {
        for (TeXObject teXObject : teXObjectList) {
            int n;
            if (teXObject instanceof CharObject) {
                n = ((CharObject)teXObject).getCharCode();
                if (Character.isLowerCase(n)) {
                    return 0;
                }
                if (!Character.isUpperCase(n)) continue;
                return 1;
            }
            if (!(teXObject instanceof TeXObjectList) || (n = (int)BibEntry.getInitialCase((TeXObjectList)teXObject)) == 2) continue;
            return (byte)n;
        }
        return 2;
    }
}

