/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.bib;

import com.dickimawbooks.texparserlib.CharObject;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.WhiteSpace;
import com.dickimawbooks.texparserlib.bib.BibData;
import com.dickimawbooks.texparserlib.bib.BibTeXSyntaxException;
import com.dickimawbooks.texparserlib.bib.BibValueList;
import java.io.IOException;

public class BibString
extends BibData {
    private String entryType;
    private String key;
    private BibValueList value;

    public BibString() {
        this("string");
    }

    public BibString(String string) {
        this.entryType = string;
    }

    @Override
    public String getEntryType() {
        return this.entryType;
    }

    @Override
    public void parseContents(TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject) throws IOException {
        this.key = this.readKey(teXParser, teXObjectList);
        TeXObject teXObject2 = teXObjectList.popStack(teXParser);
        while (teXObject2 != null && teXObject2 instanceof WhiteSpace) {
            teXObject2 = teXObjectList.popStack(teXParser);
        }
        if (teXObject2 == null) {
            throw new BibTeXSyntaxException(teXParser, "bibtex.error.immediately_follows_string_name", teXObject.format());
        }
        if (!(teXObject2 instanceof CharObject) || ((CharObject)teXObject2).getCharCode() != 61) {
            throw new BibTeXSyntaxException(teXParser, "bibtex.error.immediately_follows_string_name", teXObject2.format());
        }
        this.value = new BibValueList();
        this.readValue(teXParser, teXObjectList, this.value, teXObject);
        if (this.value.isEmpty()) {
            throw new BibTeXSyntaxException(teXParser, "bibtex.error.missing_field_part");
        }
    }

    public String getKey() {
        return this.key;
    }

    public BibValueList getValue() {
        return this.value;
    }

    @Override
    public String format(byte by, char c, char c2, byte by2) {
        return String.format("@%s%c%s = %s%c%n", BibString.applyCase(this.entryType, by), Character.valueOf(c), this.key, this.value.applyDelim(by2), Character.valueOf(c2));
    }

    public String toString() {
        return String.format("%s[type=%s,key=%s]", this.getClass().getSimpleName(), this.entryType, this.key);
    }
}

