/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.generic;

import com.dickimawbooks.texparserlib.ActiveChar;
import com.dickimawbooks.texparserlib.BgChar;
import com.dickimawbooks.texparserlib.Comment;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.DoubleParam;
import com.dickimawbooks.texparserlib.EgChar;
import com.dickimawbooks.texparserlib.Eol;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.Letter;
import com.dickimawbooks.texparserlib.MathGroup;
import com.dickimawbooks.texparserlib.Other;
import com.dickimawbooks.texparserlib.Par;
import com.dickimawbooks.texparserlib.Param;
import com.dickimawbooks.texparserlib.SbChar;
import com.dickimawbooks.texparserlib.SkippedEols;
import com.dickimawbooks.texparserlib.SkippedSpaces;
import com.dickimawbooks.texparserlib.SpChar;
import com.dickimawbooks.texparserlib.Space;
import com.dickimawbooks.texparserlib.SpecialListener;
import com.dickimawbooks.texparserlib.Tab;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXPath;
import com.dickimawbooks.texparserlib.Writeable;
import com.dickimawbooks.texparserlib.generic.Accent;
import com.dickimawbooks.texparserlib.generic.BigOperator;
import com.dickimawbooks.texparserlib.generic.BinarySymbol;
import com.dickimawbooks.texparserlib.generic.DoubleLetterAccent;
import com.dickimawbooks.texparserlib.generic.GreekSymbol;
import com.dickimawbooks.texparserlib.generic.MathAccent;
import com.dickimawbooks.texparserlib.generic.MathSymbol;
import com.dickimawbooks.texparserlib.generic.Nbsp;
import com.dickimawbooks.texparserlib.generic.ParAlign;
import com.dickimawbooks.texparserlib.generic.ParCs;
import com.dickimawbooks.texparserlib.generic.SpaceCs;
import com.dickimawbooks.texparserlib.generic.Symbol;
import com.dickimawbooks.texparserlib.primitives.Above;
import com.dickimawbooks.texparserlib.primitives.AboveWithDelims;
import com.dickimawbooks.texparserlib.primitives.ControlSpace;
import com.dickimawbooks.texparserlib.primitives.Csname;
import com.dickimawbooks.texparserlib.primitives.Def;
import com.dickimawbooks.texparserlib.primitives.DiscretionaryHyphen;
import com.dickimawbooks.texparserlib.primitives.Else;
import com.dickimawbooks.texparserlib.primitives.EndCsname;
import com.dickimawbooks.texparserlib.primitives.EndGraf;
import com.dickimawbooks.texparserlib.primitives.EndInput;
import com.dickimawbooks.texparserlib.primitives.ExpandAfter;
import com.dickimawbooks.texparserlib.primitives.Fi;
import com.dickimawbooks.texparserlib.primitives.If;
import com.dickimawbooks.texparserlib.primitives.IfFalse;
import com.dickimawbooks.texparserlib.primitives.IfTrue;
import com.dickimawbooks.texparserlib.primitives.Ifx;
import com.dickimawbooks.texparserlib.primitives.ItalicCorrection;
import com.dickimawbooks.texparserlib.primitives.Jobname;
import com.dickimawbooks.texparserlib.primitives.Let;
import com.dickimawbooks.texparserlib.primitives.Lowercase;
import com.dickimawbooks.texparserlib.primitives.NewIf;
import com.dickimawbooks.texparserlib.primitives.NumberCs;
import com.dickimawbooks.texparserlib.primitives.OverWithDelims;
import com.dickimawbooks.texparserlib.primitives.Relax;
import com.dickimawbooks.texparserlib.primitives.RomanNumeral;
import com.dickimawbooks.texparserlib.primitives.Show;
import com.dickimawbooks.texparserlib.primitives.Special;
import com.dickimawbooks.texparserlib.primitives.StringCs;
import com.dickimawbooks.texparserlib.primitives.TeXFontFamilyDeclaration;
import com.dickimawbooks.texparserlib.primitives.TeXFontShapeDeclaration;
import com.dickimawbooks.texparserlib.primitives.TeXFontWeightDeclaration;
import com.dickimawbooks.texparserlib.primitives.TheCs;
import com.dickimawbooks.texparserlib.primitives.Undefined;
import com.dickimawbooks.texparserlib.primitives.Uppercase;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.text.StringCharacterIterator;
import java.util.Vector;

public abstract class DefaultTeXParserListener
extends TeXParserListener {
    protected Writeable writeable;
    protected Vector<TeXPath> referencedFiles;
    protected Vector<SpecialListener> specialListeners;
    public static final IfTrue IFTRUE = new IfTrue();
    public static final IfFalse IFFALSE = new IfFalse();

    public DefaultTeXParserListener(Writeable writeable) {
        this.writeable = writeable;
        this.init();
    }

    private void init() {
        this.referencedFiles = new Vector();
        this.specialListeners = new Vector();
    }

    @Override
    protected void addPredefined() {
        this.parser.putActiveChar(new Nbsp());
        Accent.addCommands(this.parser);
        Symbol.addCommands(this.parser, this);
        ParAlign.addCommands(this.parser);
        this.parser.putControlSequence(new Above());
        this.parser.putControlSequence(new AboveWithDelims());
        this.parser.putControlSequence(new ControlSpace());
        this.parser.putControlSequence(new SpaceCs());
        this.parser.putControlSequence(new DiscretionaryHyphen());
        this.parser.putControlSequence(new ItalicCorrection());
        this.parser.putControlSequence(new OverWithDelims());
        this.parser.putControlSequence(new Accent("a"));
        this.parser.putControlSequence(new Relax());
        this.parser.putControlSequence(new StringCs());
        this.parser.putControlSequence(new EndInput());
        this.parser.putControlSequence(new ParCs());
        this.parser.putControlSequence(new EndGraf());
        this.parser.putControlSequence(new Special());
        this.parser.putControlSequence(new GenericCommand("empty"));
        this.parser.putControlSequence(new Def());
        this.parser.putControlSequence(new Def("gdef", true, false));
        this.parser.putControlSequence(new Let());
        this.parser.putControlSequence(new Special());
        this.parser.putControlSequence(new Jobname());
        this.parser.putControlSequence(new NumberCs());
        this.parser.putControlSequence(new RomanNumeral());
        this.parser.putControlSequence(new TheCs());
        this.parser.putControlSequence(new ExpandAfter());
        this.parser.putControlSequence(new Csname());
        this.parser.putControlSequence(new EndCsname());
        this.parser.putControlSequence(new If());
        this.parser.putControlSequence(new Ifx());
        this.parser.putControlSequence(IFTRUE);
        this.parser.putControlSequence(IFFALSE);
        this.parser.putControlSequence(new Else());
        this.parser.putControlSequence(new Fi());
        this.parser.putControlSequence(new NewIf());
        this.parser.putControlSequence(new MathAccent("vec", 8407));
        this.parser.putControlSequence(new MathAccent("hat", 770, 710));
        this.parser.putControlSequence(new MathAccent("check", 780, 711));
        this.parser.putControlSequence(new MathAccent("breve", 774, 728));
        this.parser.putControlSequence(new MathAccent("acute", 769, 180));
        this.parser.putControlSequence(new MathAccent("grave", 768, 96));
        this.parser.putControlSequence(new MathAccent("tilde", 771, 732));
        this.parser.putControlSequence(new MathAccent("bar", 772, 175));
        this.parser.putControlSequence(new MathAccent("dot", 775, 729));
        this.parser.putControlSequence(new MathAccent("ddot", 776, 168));
        this.parser.putControlSequence(new DoubleLetterAccent("t", 860, 8255));
        this.parser.putControlSequence(new Uppercase());
        this.parser.putControlSequence(new Lowercase());
        this.parser.putControlSequence(new Show());
        this.parser.putControlSequence(new GenericCommand(true, "lq", null, new TeXObject[]{this.getOther(96)}));
        this.parser.putControlSequence(new GenericCommand(true, "rq", null, new TeXObject[]{this.getOther(39)}));
        this.parser.putControlSequence(this.getTeXFontFamilyDeclaration("rm", 0));
        this.parser.putControlSequence(this.getTeXFontFamilyDeclaration("sf", 1));
        this.parser.putControlSequence(this.getTeXFontFamilyDeclaration("tt", 2));
        this.parser.putControlSequence(this.getTeXFontFamilyDeclaration("cal", 3));
        this.parser.putControlSequence(this.getTeXFontWeightDeclaration("bf", 1));
        this.parser.putControlSequence(this.getTeXFontShapeDeclaration("it", 1));
        this.parser.putControlSequence(this.getTeXFontShapeDeclaration("sl", 2));
        this.parser.putControlSequence(this.getTeXFontShapeDeclaration("em", 3));
        this.parser.putControlSequence(this.getTeXFontShapeDeclaration("sc", 4));
    }

    public ControlSequence getTeXFontFamilyDeclaration(String string, int n) {
        return new TeXFontFamilyDeclaration(string, n);
    }

    public ControlSequence getTeXFontShapeDeclaration(String string, int n) {
        return new TeXFontShapeDeclaration(string, n);
    }

    public ControlSequence getTeXFontWeightDeclaration(String string, int n) {
        return new TeXFontWeightDeclaration(string, n);
    }

    public void putControlSequence(ControlSequence controlSequence) {
        this.getParser().putControlSequence(controlSequence);
    }

    public void putControlSequence(boolean bl, ControlSequence controlSequence) {
        this.getParser().putControlSequence(bl, controlSequence);
    }

    @Override
    public ControlSequence createUndefinedCs(String string) {
        return new Undefined(string);
    }

    @Override
    public ActiveChar getActiveChar(int n) {
        return this.getParser().getActiveChar(new Integer(n));
    }

    public void putActiveChar(ActiveChar activeChar) {
        this.getParser().putActiveChar(activeChar);
    }

    @Override
    public BgChar getBgChar(int n) {
        return new BgChar(n);
    }

    @Override
    public EgChar getEgChar(int n) {
        return new EgChar(n);
    }

    @Override
    public Eol getEol() {
        return new Eol();
    }

    @Override
    public Par getPar() {
        return new Par();
    }

    @Override
    public Space getSpace() {
        return new Space();
    }

    @Override
    public Param getParam(int n) {
        return new Param(n);
    }

    @Override
    public DoubleParam getDoubleParam(Param param) {
        return new DoubleParam(param);
    }

    @Override
    public Tab getTab() {
        return new Tab();
    }

    @Override
    public Letter getLetter(int n) {
        return new Letter(n);
    }

    @Override
    public Other getOther(int n) {
        return new Other(n);
    }

    @Override
    public TeXObjectList createString(String string) {
        return new TeXObjectList(this, string);
    }

    @Override
    public SkippedSpaces createSkippedSpaces() {
        return new SkippedSpaces();
    }

    @Override
    public SkippedEols createSkippedEols() {
        return new SkippedEols();
    }

    @Override
    public BinarySymbol createBinarySymbol(String string, int n) {
        return new BinarySymbol(string, n);
    }

    @Override
    public Symbol createSymbol(String string, int n) {
        return new Symbol(string, n);
    }

    @Override
    public GreekSymbol createGreekSymbol(String string, int n) {
        return new GreekSymbol(string, n);
    }

    @Override
    public MathSymbol createMathSymbol(String string, int n) {
        return new MathSymbol(string, n);
    }

    public BigOperator createBigOperator(String string, int n) {
        return new BigOperator(string, n);
    }

    @Override
    public BigOperator createBigOperator(String string, int n, int n2) {
        return new BigOperator(string, n, n2);
    }

    @Override
    public Group createGroup() {
        return new Group();
    }

    @Override
    public Group createGroup(String string) {
        return new Group(this, string);
    }

    @Override
    public MathGroup createMathGroup() {
        return new MathGroup();
    }

    @Override
    public SpChar createSpChar() {
        return new SpChar();
    }

    @Override
    public SbChar createSbChar() {
        return new SbChar();
    }

    @Override
    public Comment createComment() {
        return new Comment();
    }

    @Override
    public boolean input(TeXPath teXPath) throws IOException {
        if (teXPath != null && Files.exists(teXPath.getPath(), new LinkOption[0])) {
            Charset charset = this.getCharSet();
            this.getParser().parse(teXPath, charset);
            return true;
        }
        return false;
    }

    @Override
    public Writeable getWriteable() {
        return this.writeable;
    }

    public void setWriteable(Writeable writeable) {
        this.writeable = writeable;
    }

    @Override
    public void addFileReference(TeXPath teXPath) {
        if (!this.referencedFiles.contains(teXPath)) {
            this.referencedFiles.add(teXPath);
        }
    }

    public void addSpecialListener(SpecialListener specialListener) {
        this.specialListeners.add(specialListener);
    }

    public void removeSpecialListener(SpecialListener specialListener) {
        this.specialListeners.remove(specialListener);
    }

    @Override
    public TeXObjectList special(String string) throws IOException {
        for (SpecialListener specialListener : this.specialListeners) {
            TeXObjectList teXObjectList = specialListener.process(this.parser, string);
            if (teXObjectList == null) continue;
            return teXObjectList;
        }
        return null;
    }

    @Override
    public void verb(String string, boolean bl, char c, String string2) throws IOException {
        if (bl) {
            StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string2);
            char c2 = stringCharacterIterator.first();
            while (c2 != '\uffff') {
                if (c2 == ' ') {
                    this.writeable.writeCodePoint(9251);
                } else {
                    this.writeable.write(c2);
                }
                c2 = stringCharacterIterator.next();
            }
        } else {
            this.writeable.write(string2);
        }
    }

    public Vector<TeXPath> getFileList() {
        return this.referencedFiles;
    }

    public TeXObjectList requestUserInputAsList(String string) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList();
        this.requestUserInput(string, teXObjectList);
        return teXObjectList;
    }

    public void requestUserInput(String string, TeXObjectList teXObjectList) throws IOException {
        String string2 = this.getTeXApp().requestUserInput(string);
        if (string2 != null && !string2.isEmpty()) {
            this.getParser().scan(string2, teXObjectList);
        }
    }

    public boolean isIfTrue(ControlSequence controlSequence) {
        return IFTRUE.equals(controlSequence);
    }

    public boolean isIfFalse(ControlSequence controlSequence) {
        return IFFALSE.equals(controlSequence);
    }
}

