/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2GlsAdapter;
import com.dickimawbooks.bib2gls.Bib2GlsException;
import com.dickimawbooks.bib2gls.Bib2GlsMessages;
import com.dickimawbooks.bib2gls.Bib2GlsSyntaxException;
import com.dickimawbooks.bib2gls.EnableTagging;
import com.dickimawbooks.bib2gls.GlsRecord;
import com.dickimawbooks.bib2gls.GlsResource;
import com.dickimawbooks.bib2gls.GlsSeeRecord;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.TeXApp;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXPath;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.aux.AuxData;
import com.dickimawbooks.texparserlib.aux.AuxParser;
import com.dickimawbooks.texparserlib.bib.BibValueList;
import com.dickimawbooks.texparserlib.html.L2HStringConverter;
import com.dickimawbooks.texparserlib.latex.CsvList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Bib2Gls
implements TeXApp {
    public static final String NAME = "bib2gls";
    public static final String VERSION = "1.0";
    public static final String DATE = "2017-09-09";
    public int debugLevel = 0;
    public int verboseLevel = 0;
    private char openout_any = (char)112;
    private char openin_any = (char)97;
    private Path cwd;
    private Path texmfoutput = null;
    private Path basePath;
    private File auxFile;
    private File logFile;
    private PrintWriter logWriter = null;
    public static final Pattern PATTERN_PACKAGE = Pattern.compile("Package: ([^\\s]+)(?:\\s+(\\d{4})/(\\d{2})/(\\d{2}))?.*");
    private boolean fontspec = false;
    private boolean hyperref = false;
    private boolean createHyperGroups = true;
    private Vector<GlsResource> glsresources;
    private Vector<String> fields;
    private Vector<GlsRecord> records;
    private Vector<GlsSeeRecord> seeRecords;
    private HashMap<String, String> fieldMap;
    private Vector<String> dependencies;
    private HashMap<String, String> formatMap;
    private Vector<File> texFiles;
    private boolean addGroupField = false;
    private Charset texCharset = null;
    private Bib2GlsMessages messages;
    private boolean mfirstucProtect = true;
    private boolean mfirstucMProtect = true;
    private String[] mfirstucProtectFields = null;
    private String shortcuts = null;
    private boolean checkAcroShortcuts = false;
    private boolean checkAbbrvShortcuts = false;
    private GlsResource currentResource = null;
    private String docLocale;
    private boolean trimFields = false;
    private boolean interpret = true;
    private Vector<String> packages = null;
    private TeXParser interpreter = null;
    private int exitCode;
    private boolean shownVersion = false;
    private String[] nestedLinkCheckFields = new String[]{"name", "text", "plural", "first", "firstplural", "long", "longplural", "short", "shortplural", "symbol"};

    public Bib2Gls(int n, int n2, String string) throws IOException, InterruptedException, Bib2GlsException {
        this.debugLevel = n;
        this.verboseLevel = n2;
        this.shownVersion = false;
        if (n > 0 && n2 > -1) {
            this.version();
            this.shownVersion = true;
        }
        this.initMessages(string);
        this.initSecuritySettings();
        if (this.verboseLevel >= 0 && !this.shownVersion) {
            this.version();
            this.shownVersion = true;
        }
        this.formatMap = new HashMap();
        this.texFiles = new Vector();
    }

    private void initSecuritySettings() throws IOException, InterruptedException, Bib2GlsException {
        File file;
        String string;
        int n;
        String string2 = this.kpsewhich("--var-value=openin_any");
        String string3 = this.kpsewhich("--var-value=openout_any");
        int n2 = string2 == null || string2.isEmpty() ? -1 : (int)string2.charAt(0);
        int n3 = n = string3 == null || string3.isEmpty() ? -1 : (int)string3.charAt(0);
        if (n2 == 97 || n2 == 112 || n2 == 114) {
            this.openin_any = (char)n2;
        } else if (n2 == -1) {
            this.debug(this.getMessage("error.missing.value", "openin_any"));
            this.openin_any = (char)97;
        } else {
            this.warning(this.getMessage("error.invalid.opt.value", "openin_any", string2));
            this.openin_any = (char)97;
        }
        if (n == 97 || n == 112 || n == 114) {
            this.openout_any = (char)n;
        } else if (n == -1) {
            this.debug(this.getMessage("error.missing.value", "openout_any"));
            this.openout_any = (char)112;
        } else {
            this.warning(this.getMessage("error.invalid.opt.value", "openout_any", string3));
            this.openout_any = (char)112;
        }
        try {
            string = this.kpsewhich("--var-value=TEXMFOUTPUT");
            if (string != null && !string.isEmpty()) {
                file = new TeXPath(null, string, false).getFile();
                if (!file.isDirectory()) {
                    System.err.println("TEXMFOUT not a directory: " + string);
                }
                this.texmfoutput = file.toPath();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        string = System.getProperty("user.dir");
        if (string == null) {
            throw new IOException("Can't determine current working directory");
        }
        file = new File(string);
        if (!file.isDirectory()) {
            throw new IOException("CWD is not a directory: " + string);
        }
        this.cwd = file.toPath();
    }

    public void checkReadAccess(TeXPath teXPath) throws IOException {
        if (!this.isReadAccessAllowed(teXPath)) {
            throw new IOException(this.getMessage("error.openin.forbidden", teXPath));
        }
    }

    public void checkReadAccess(Path path) throws IOException {
        if (!this.isReadAccessAllowed(path)) {
            throw new IOException(this.getMessage("error.openin.forbidden", path));
        }
    }

    public void checkReadAccess(File file) throws IOException {
        if (!this.isReadAccessAllowed(file.toPath())) {
            throw new IOException(this.getMessage("error.openin.forbidden", Character.valueOf(this.openin_any), file));
        }
    }

    @Override
    public boolean isReadAccessAllowed(TeXPath teXPath) {
        Path path;
        this.debug(this.getMessage("message.checking.read", teXPath));
        if (this.openin_any == 'a') {
            return true;
        }
        if (teXPath.isHidden()) {
            return false;
        }
        if (this.openin_any == 'r') {
            return true;
        }
        if (teXPath.wasFoundByKpsewhich()) {
            return true;
        }
        Path path2 = teXPath.getBaseDir();
        Path path3 = teXPath.getRelativePath();
        Path path4 = path = path2 == null ? path3.normalize() : path2.resolve(path3).normalize();
        if (path.isAbsolute()) {
            if (path.startsWith(this.cwd)) {
                return true;
            }
            if (this.texmfoutput != null) {
                return path.startsWith(this.texmfoutput);
            }
            return false;
        }
        return path.toAbsolutePath().normalize().startsWith(this.cwd);
    }

    @Override
    public boolean isReadAccessAllowed(File file) {
        return this.isReadAccessAllowed(file.toPath());
    }

    public boolean isReadAccessAllowed(Path path) {
        this.debug(this.getMessage("message.checking.read", path));
        if (this.openin_any == 'a') {
            return true;
        }
        if (this.isHidden(path)) {
            return false;
        }
        if (this.openin_any == 'r') {
            return true;
        }
        if (path.isAbsolute()) {
            if ((path = path.normalize()).startsWith(this.cwd)) {
                return true;
            }
            if (this.texmfoutput != null) {
                return path.startsWith(this.texmfoutput);
            }
            return false;
        }
        return path.toAbsolutePath().normalize().startsWith(this.cwd);
    }

    public void checkWriteAccess(Path path) throws IOException {
        if (!this.isWriteAccessAllowed(path)) {
            throw new IOException(this.getMessage("error.openout.forbidden", path));
        }
    }

    public void checkWriteAccess(File file) throws IOException {
        if (!this.isWriteAccessAllowed(file.toPath())) {
            throw new IOException(this.getMessage("error.openout.forbidden", file));
        }
    }

    public void registerTeXFile(File file) throws IOException {
        this.checkWriteAccess(file);
        if (this.texFiles.contains(file)) {
            throw new IOException(this.getMessage("error.duplicate.resource", file));
        }
        this.texFiles.add(file);
    }

    @Override
    public boolean isWriteAccessAllowed(TeXPath teXPath) {
        return this.isWriteAccessAllowed(teXPath.getPath());
    }

    @Override
    public boolean isWriteAccessAllowed(File file) {
        return this.isWriteAccessAllowed(file.toPath());
    }

    public boolean isWriteAccessAllowed(Path path) {
        this.debug(this.getMessage("message.checking.write", path));
        String string = path.getName(path.getNameCount() - 1).toString().toLowerCase();
        int n = string.lastIndexOf(".");
        if (n > -1 && ((string = string.substring(n + 1)).equals("tex") || string.equals("ltx") || string.equals("sty") || string.equals("cls") || string.equals("bib") || string.equals("dtx") || string.equals("ins") || string.equals("def") || string.equals("ldf"))) {
            this.debug(this.getMessageWithFallback("error.forbidden.ext", "Write access forbidden for extension: {0}", string));
            return false;
        }
        if (this.openout_any == 'a') {
            return true;
        }
        if (this.isHidden(path)) {
            return false;
        }
        if (this.openout_any == 'r') {
            return true;
        }
        if (path.isAbsolute()) {
            if ((path = path.normalize()).startsWith(this.cwd)) {
                return true;
            }
            if (this.texmfoutput != null) {
                return path.startsWith(this.texmfoutput);
            }
            return false;
        }
        return path.toAbsolutePath().normalize().startsWith(this.cwd);
    }

    public boolean isHidden(Path path) {
        for (int i = path.getNameCount() - 1; i >= 0; --i) {
            String string = path.getName(i).toString();
            if (!string.startsWith(".") || string.equals(".") || string.equals("..")) continue;
            return true;
        }
        return false;
    }

    public File getWritableFile(File file) throws IOException {
        File file2 = file.getParentFile();
        if (file2 == null) {
            file2 = this.cwd.toFile();
        }
        if (this.texmfoutput != null && !file2.canWrite()) {
            this.warning(this.getMessage("warning.dir.no.write", file2, this.texmfoutput));
            file = new File(this.texmfoutput.toFile(), file.getName());
        }
        this.checkWriteAccess(file);
        return file;
    }

    public Path resolvePath(Path path) {
        return this.basePath.resolve(path).normalize();
    }

    public File resolveFile(File file) {
        file = file.getParentFile() == null ? new File(this.basePath.toFile(), file.getName()) : this.basePath.resolve(file.toPath()).toFile();
        return file;
    }

    public File resolveFile(String string) {
        return this.resolveFile(new File(string));
    }

    private String texToJavaCharset(String string) throws Bib2GlsException {
        if (string.equals("ascii")) {
            return "US-ASCII";
        }
        if (string.equals("latin1")) {
            return "ISO-8859-1";
        }
        if (string.equals("latin2")) {
            return "ISO-8859-2";
        }
        if (string.equals("latin3")) {
            return "ISO-8859-3";
        }
        if (string.equals("latin4")) {
            return "ISO-8859-4";
        }
        if (string.equals("latin5")) {
            return "ISO-8859-5";
        }
        if (string.equals("latin9")) {
            return "ISO-8859-9";
        }
        if (string.equals("latin10")) {
            return "ISO-8859-10";
        }
        if (string.equals("decmulti")) {
            return "DEC-MCS";
        }
        if (string.equals("cp850")) {
            return "Cp850";
        }
        if (string.equals("cp852")) {
            return "Cp852";
        }
        if (string.equals("cp858")) {
            return "Cp858";
        }
        if (string.equals("cp437") || string.equals("cp437de")) {
            return "Cp437";
        }
        if (string.equals("865")) {
            return "Cp865";
        }
        if (string.equals("applemac")) {
            return "MacRoman";
        }
        if (string.equals("macce")) {
            return "MacCentralEurope";
        }
        if (!string.equals("next")) {
            if (string.equals("cp1250")) {
                return "Cp1250";
            }
            if (string.equals("cp1252") || string.equals("ansinew")) {
                return "Cp1252";
            }
            if (string.equals("cp1257")) {
                return "Cp1257";
            }
            if (string.equals("utf8")) {
                return "UTF-8";
            }
        }
        throw new Bib2GlsException(string);
    }

    public boolean useInterpreter() {
        return this.interpret;
    }

    public L2HStringConverter getInterpreterListener() {
        return this.interpreter == null ? null : (L2HStringConverter)this.interpreter.getListener();
    }

    public Vector<String> getPackages() {
        return this.packages;
    }

    public boolean fontSpecLoaded() {
        return this.fontspec;
    }

    public boolean hyperrefLoaded() {
        return this.hyperref;
    }

    public boolean createHyperGroupsOn() {
        return this.createHyperGroups;
    }

    public void setCreateHyperGroups(boolean bl) {
        this.createHyperGroups = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseLog() throws IOException {
        String string = this.auxFile.getName();
        String string2 = string;
        int n = string2.lastIndexOf(".aux");
        if (n < 1) {
            this.debug("Can't determine log file from " + this.auxFile);
            return;
        }
        String string3 = string2.substring(0, n);
        string2 = string3 + ".log";
        File file = new File(this.auxFile.getParentFile(), string2);
        this.packages = new Vector();
        try (BufferedReader bufferedReader = null;){
            this.checkReadAccess(file);
            bufferedReader = new BufferedReader(new FileReader(file));
            Object object = null;
            while ((object = bufferedReader.readLine()) != null) {
                Matcher object2 = PATTERN_PACKAGE.matcher((CharSequence)object);
                if (object2.matches()) {
                    String string4 = object2.group(1).toLowerCase();
                    if (string4.equals("amsmath") || string4.equals("amssymb") || string4.equals("pifont") || string4.equals("textcase") || string4.equals("wasysym") || string4.equals("lipsum") || string4.equals("natbib") || string4.equals("mhchem") || string4.equals("bpchem") || string4.equals("stix") || string4.equals("textcomp") || string4.equals("mnsymbol") || string4.equals("xspace") || string4.equals("siunitx")) {
                        this.packages.add(string4);
                        continue;
                    }
                    if (string4.equals("hyperref")) {
                        this.hyperref = true;
                        continue;
                    }
                    if (string4.equals("fontspec")) {
                        this.fontspec = true;
                        continue;
                    }
                    if (!string4.equals("glossaries-extra")) continue;
                    try {
                        Calendar calendar = Calendar.getInstance();
                        calendar.set(2017, 2, 3);
                        int n2 = Integer.parseInt(object2.group(2));
                        int n3 = Integer.parseInt(object2.group(3));
                        int n4 = Integer.parseInt(object2.group(4));
                        Calendar calendar2 = Calendar.getInstance();
                        calendar2.set(n2, n3, n4);
                        if (calendar2.compareTo(calendar) >= 0) continue;
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd");
                        this.warning(this.getMessage("error.sty.too.old", "glossaries-extra", simpleDateFormat.format(calendar2.getTime()), simpleDateFormat.format(calendar.getTime())));
                    }
                    catch (Exception exception) {
                        this.warning(this.getMessage("error.no.sty.version", "glossaries-extra"));
                        this.debug(exception);
                    }
                    continue;
                }
                if (!((String)object).contains(string)) continue;
                break;
            }
        }
        if (this.debugLevel > 0 && this.packages.size() > 0) {
            if (this.packages.size() == 1) {
                this.debug(this.getMessage("message.1.sty"));
            } else {
                this.debug(this.getMessage("message.2.sty", this.packages.size()));
            }
            for (String string5 : this.packages) {
                this.debug(string5);
            }
            this.debug();
        }
    }

    private void initInterpreter(Vector<AuxData> vector) throws IOException {
        L2HStringConverter l2HStringConverter = new L2HStringConverter(new Bib2GlsAdapter(this), vector){

            @Override
            public void writeCodePoint(int n) throws IOException {
                if (this.getWriter() == null) {
                    return;
                }
                if (n == 38) {
                    this.getWriter().write("&amp;");
                } else if (n == 60) {
                    this.getWriter().write("&le;");
                } else if (n == 62) {
                    this.getWriter().write("&ge;");
                } else if (n > 65535) {
                    this.getWriter().write(String.format("%c%c", Character.valueOf(Character.highSurrogate(n)), Character.valueOf(Character.lowSurrogate(n))));
                } else {
                    this.getWriter().write(n);
                }
            }
        };
        l2HStringConverter.setUseMathJax(false);
        l2HStringConverter.setIsInDocEnv(true);
        this.interpreter = new TeXParser(l2HStringConverter);
        this.interpreter.setCatCode('@', 11);
        Vector<String> vector2 = this.getPackages();
        if (vector2 != null) {
            for (String string : vector2) {
                l2HStringConverter.usepackage(null, string);
            }
        }
        l2HStringConverter.putControlSequence(new EnableTagging());
    }

    public void provideCommand(String string, String string2) {
        if (this.interpreter != null) {
            L2HStringConverter l2HStringConverter = (L2HStringConverter)this.interpreter.getListener();
            l2HStringConverter.putControlSequence(new GenericCommand(string, null, l2HStringConverter.createString(string2)));
        }
    }

    public void processPreamble(BibValueList bibValueList) throws IOException {
        if (this.interpreter == null) {
            return;
        }
        this.interpreter.addAll(bibValueList.expand(this.interpreter));
        if (this.getDebugLevel() > 0) {
            this.debug(String.format("%n%s%n%s%n%n", this.getMessage("message.parsing.code"), this.interpreter.toString(this.interpreter)));
        }
        while (this.interpreter.size() > 0) {
            TeXObject teXObject = this.interpreter.pop();
            teXObject.process(this.interpreter);
        }
    }

    public String interpret(String string, BibValueList bibValueList) {
        if (this.interpreter == null) {
            return string;
        }
        try {
            Object object;
            StringWriter stringWriter = new StringWriter();
            ((L2HStringConverter)this.interpreter.getListener()).setWriter(stringWriter);
            TeXObjectList teXObjectList = bibValueList.expand(this.interpreter);
            if (teXObjectList == null) {
                return string;
            }
            this.interpreter.addAll(teXObjectList);
            if (this.getDebugLevel() > 0) {
                this.debug(String.format("%n%s%n%s%n%n", this.getMessage("message.parsing.code"), this.interpreter.toString(this.interpreter)));
            }
            while (this.interpreter.size() > 0) {
                object = this.interpreter.pop();
                object.process(this.interpreter);
            }
            object = stringWriter.toString();
            if (this.getDebugLevel() > 0) {
                this.debug(String.format("texparserlib:--> %s", object));
            }
            object = ((String)object).replaceAll("<[^>]+>", "").trim();
            object = ((String)object).replaceAll("\\&le;", "<");
            object = ((String)object).replaceAll("\\&ge;", ">");
            object = ((String)object).replaceAll("\\&amp;", "&");
            this.logMessage(String.format("texparserlib: %s -> %s", string, object));
            return object;
        }
        catch (IOException iOException) {
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(String[] stringArray) throws IOException, InterruptedException, Bib2GlsException {
        int n;
        this.parseArgs(stringArray);
        if (this.interpret) {
            try {
                this.parseLog();
            }
            catch (IOException iOException) {
                this.debug(iOException);
            }
        }
        AuxParser auxParser = new AuxParser(this){

            @Override
            protected void addPredefined() {
                super.addPredefined();
                this.addAuxCommand("glsxtr@resource", 2);
                this.addAuxCommand("glsxtr@fields", 1);
                this.addAuxCommand("glsxtr@record", 5);
                this.addAuxCommand("glsxtr@recordsee", 2);
                this.addAuxCommand("glsxtr@texencoding", 1);
                this.addAuxCommand("glsxtr@langtag", 1);
                this.addAuxCommand("glsxtr@shortcutsval", 1);
                this.addAuxCommand("glsxtr@pluralsuffixes", 4);
            }
        };
        TeXParser teXParser = auxParser.parseAuxFile(this.auxFile);
        this.glsresources = new Vector();
        this.fields = new Vector();
        this.fieldMap = new HashMap();
        this.records = new Vector();
        this.seeRecords = new Vector();
        this.dependencies = new Vector();
        Vector<AuxData> vector = auxParser.getAuxData();
        if (this.interpret) {
            this.initInterpreter(vector);
        }
        Vector<AuxData> vector2 = new Vector<AuxData>();
        String string = "s";
        String string2 = "s";
        String string3 = "s";
        String string4 = "s";
        for (AuxData auxData : vector) {
            String string5;
            String string6;
            Object object;
            Object object2;
            String string7 = auxData.getName();
            if (string7.equals("glsxtr@resource")) {
                vector2.add(auxData);
                continue;
            }
            if (string7.equals("glsxtr@shortcutsval")) {
                if (this.shortcuts != null) continue;
                this.setShortCuts(auxData.getArg(0).toString(teXParser));
                continue;
            }
            if (string7.equals("glsxtr@pluralsuffixes")) {
                string = auxData.getArg(0).toString(teXParser);
                string2 = auxData.getArg(1).toString(teXParser);
                string3 = auxData.getArg(2).toString(teXParser);
                string4 = auxData.getArg(3).toString(teXParser);
                continue;
            }
            if (string7.equals("glsxtr@langtag")) {
                this.setDocDefaultLocale(auxData.getArg(0).toString(teXParser));
                continue;
            }
            if (this.texCharset == null && string7.equals("glsxtr@texencoding")) {
                try {
                    object2 = auxData.getArg(0).toString(teXParser).trim();
                    if (((String)object2).equals("\\inputencodingname")) {
                        this.texCharset = Charset.defaultCharset();
                        continue;
                    }
                    this.texCharset = Charset.forName(this.texToJavaCharset((String)object2));
                }
                catch (Bib2GlsException bib2GlsException) {
                    this.texCharset = Charset.defaultCharset();
                    this.warning(this.getMessage("error.unknown.tex.charset", bib2GlsException.getMessage(), this.texCharset, "--tex-encoding"));
                }
                continue;
            }
            if (string7.equals("glsxtr@fields")) {
                object2 = CsvList.getList(teXParser, auxData.getArg(0));
                Iterator iterator = ((Vector)object2).iterator();
                while (iterator.hasNext()) {
                    TeXObject teXObject = (TeXObject)iterator.next();
                    TeXObjectList teXObjectList = (TeXObjectList)teXObject;
                    object = teXObjectList.popArg(teXParser);
                    string6 = object.toString(teXParser);
                    this.fields.add(string6);
                    object = teXObjectList.popArg(teXParser);
                    string5 = object.toString(teXParser);
                    if (!string5.equals(string6)) {
                        this.fieldMap.put(string6, string5);
                    }
                    this.debug("Adding field: " + string6 + " (" + string5 + ")");
                }
                continue;
            }
            if (string7.equals("glsxtr@recordsee")) {
                this.seeRecords.add(new GlsSeeRecord(auxData.getArg(0).toString(teXParser), auxData.getArg(1)));
                continue;
            }
            if (!string7.equals("glsxtr@record")) continue;
            object2 = new GlsRecord(auxData.getArg(0).toString(teXParser), auxData.getArg(1).toString(teXParser), auxData.getArg(2).toString(teXParser), auxData.getArg(3).toString(teXParser), auxData.getArg(4).toString(teXParser));
            boolean bl = false;
            for (GlsRecord glsRecord : this.records) {
                if (glsRecord.equals(object2)) {
                    bl = true;
                    break;
                }
                if (!glsRecord.partialMatch((GlsRecord)object2)) continue;
                object = ((GlsRecord)object2).getFormat();
                string6 = glsRecord.getFormat();
                string5 = "";
                if (((String)object).startsWith("(") || ((String)object).startsWith(")")) {
                    string5 = ((String)object).substring(0, 1);
                    object = ((String)object).length() == 1 ? "glsnumberformat" : ((String)object).substring(1);
                }
                String string8 = "";
                if (string6.startsWith("(") || string6.startsWith(")")) {
                    string8 = string6.substring(0, 1);
                    string6 = string6.length() == 1 ? "glsnumberformat" : string6.substring(1);
                }
                if (string8.equals(")") && string5.equals("(")) {
                    this.records.add((GlsRecord)object2);
                } else if (string8.equals("(") && string5.equals(")")) {
                    if (string6.equals(object)) {
                        this.records.add((GlsRecord)object2);
                    } else {
                        this.warning(this.getMessage("warning.conflicting.range.format", string8 + string6, string5 + (String)object, string5 + string6));
                        ((GlsRecord)object2).setFormat(string5 + string6);
                        this.records.add((GlsRecord)object2);
                    }
                } else if (string5.isEmpty() && !string8.isEmpty()) {
                    this.debug();
                    this.debug(this.getMessage("warning.discarding.conflicting.record", object, string8 + string6, object2, glsRecord));
                    this.debug();
                } else if (!string5.isEmpty() && string8.isEmpty()) {
                    this.debug();
                    this.debug(this.getMessage("warning.discarding.conflicting.record", string5 + (String)object, string8 + string6, glsRecord, object2));
                    this.debug();
                    glsRecord.setFormat(string5 + (String)object);
                } else if (((String)object).equals("glsignore")) {
                    this.debug();
                    this.debug(this.getMessage("warning.discarding.conflicting.record", string5 + (String)object, string8 + string6, object2, glsRecord));
                    this.debug();
                } else if (string6.equals("glsignore")) {
                    this.debug();
                    this.debug(this.getMessage("warning.discarding.conflicting.record", string5 + (String)object, string8 + string6, glsRecord, object2));
                    this.debug();
                    glsRecord.setFormat(string5 + (String)object);
                } else if (((String)object).equals("glsnumberformat")) {
                    this.debug();
                    this.debug(this.getMessage("warning.discarding.conflicting.record", string5 + (String)object, string8 + string6, object2, glsRecord));
                    this.debug();
                } else if (string6.equals("glsnumberformat")) {
                    this.debug();
                    this.debug(this.getMessage("warning.discarding.conflicting.record", string5 + (String)object, string8 + string6, glsRecord, object2));
                    this.debug();
                    glsRecord.setFormat(string5 + (String)object);
                } else {
                    String string9 = this.formatMap.get(object);
                    String string10 = this.formatMap.get(string6);
                    if (string9 != null && string9.equals(string6)) {
                        if (this.debugLevel > 0) {
                            this.debug();
                            this.debug(this.getMessage("warning.discarding.conflicting.record.using.map", string5 + (String)object, string5 + string9, object2, glsRecord));
                            this.debug();
                        }
                    } else if (string10 != null && string10.equals(object)) {
                        if (this.debugLevel > 0) {
                            this.debug();
                            this.debug(this.getMessage("warning.discarding.conflicting.record.using.map", string6, string10, glsRecord, object2));
                            this.debug();
                        }
                        glsRecord.setFormat(string5 + (String)object);
                    } else if (string10 != null && string9 != null && string10.equals(string9)) {
                        if (this.debugLevel > 0) {
                            this.debug();
                            this.debug(this.getMessage("warning.discarding.conflicting.record.using.map2", string6, string10, object, string9, glsRecord, object2, String.format("{%s}{%s}{%s}{%s}{%s}", glsRecord.getLabel(), glsRecord.getPrefix(), glsRecord.getCounter(), string9, glsRecord.getLocation())));
                            this.debug();
                        }
                        glsRecord.setFormat(string5 + string9);
                    } else {
                        this.warning();
                        this.warning(this.getMessage("warning.discarding.conflicting.record", string5 + (String)object, string8 + string6, object2, glsRecord));
                        this.warning();
                    }
                }
                bl = true;
                break;
            }
            if (bl) continue;
            this.records.add((GlsRecord)object2);
        }
        this.provideCommand("glspluralsuffix", string);
        this.provideCommand("abbrvpluralsuffix", string2);
        this.provideCommand("acrpluralsuffix", string3);
        this.provideCommand("glsxtrabbrvpluralsuffix", string4);
        if (this.texCharset == null) {
            this.texCharset = Charset.defaultCharset();
            this.logMessage(this.getMessage("message.unknown.tex.charset", this.texCharset, "--tex-encoding"));
        } else {
            this.verbose(this.getMessage("message.tex.charset", this.texCharset));
        }
        for (AuxData auxData : vector2) {
            this.glsresources.add(new GlsResource(teXParser, auxData, string, string2));
        }
        if (this.glsresources.size() == 0) {
            throw new Bib2GlsException(this.getMessage("error.missing.aux.cs.require_cs_or", "glsxtr@resource", "glsxtrresourcefile", "GlsXtrLoadResources"));
        }
        if (this.fields.size() == 0) {
            this.warning(teXParser, this.getMessage("error.missing.aux.new.cs", "glsxtr@fields", "1.11"));
            this.fields.add("name");
            this.fields.add("sort");
            this.fieldMap.put("sort", "sortvalue");
            this.fields.add("type");
            this.fields.add("first");
            this.fields.add("firstplural");
            this.fieldMap.put("firstplural", "firstpl");
            this.fields.add("text");
            this.fields.add("plural");
            this.fields.add("description");
            this.fieldMap.put("description", "desc");
            this.fields.add("descriptionplural");
            this.fieldMap.put("description", "descplural");
            this.fields.add("symbol");
            this.fields.add("symbolplural");
            this.fields.add("user1");
            this.fieldMap.put("user1", "useri");
            this.fields.add("user2");
            this.fieldMap.put("user2", "userii");
            this.fields.add("user3");
            this.fieldMap.put("user3", "useriii");
            this.fields.add("user4");
            this.fieldMap.put("user4", "useriv");
            this.fields.add("user5");
            this.fieldMap.put("user5", "userv");
            this.fields.add("user6");
            this.fieldMap.put("user6", "uservi");
            this.fields.add("long");
            this.fields.add("longplural");
            this.fieldMap.put("long", "longpl");
            this.fields.add("short");
            this.fields.add("shortplural");
            this.fieldMap.put("short", "shortpl");
            this.fields.add("counter");
            this.fields.add("parent");
            this.fields.add("loclist");
            this.fields.add("see");
            this.fields.add("category");
        }
        this.addField("dualshort");
        this.addField("dualshortplural");
        this.addField("duallong");
        this.addField("duallongplural");
        for (n = 0; n < this.glsresources.size(); ++n) {
            this.currentResource = this.glsresources.get(n);
            this.currentResource.parse(teXParser);
        }
        this.currentResource = null;
        n = 0;
        for (int i = 0; i < this.glsresources.size(); ++i) {
            this.currentResource = this.glsresources.get(i);
            int n2 = this.currentResource.processData();
            if (n2 <= 0) continue;
            n += n2;
        }
        this.currentResource = null;
        if (n == 0 && this.records.size() == 0) {
            this.error(this.getMessage("error.missing.records"));
        }
        if (this.glsresources.size() > 1) {
            this.message(this.getChoiceMessage("message.written.total", 0, "entry", 3, n));
        }
        if (this.logWriter != null) {
            try {
                this.logWriter.close();
            }
            finally {
                this.logWriter = null;
            }
            this.message(this.getMessage("message.log.file", this.logFile));
        }
    }

    public GlsResource getCurrentResource() {
        return this.currentResource;
    }

    public boolean isDependent(String string) {
        return this.dependencies.contains(string);
    }

    public void addDependent(String string) {
        if (!this.dependencies.contains(string)) {
            this.verbose(this.getMessage("message.added.dep", string));
            this.dependencies.add(string);
        }
    }

    public Vector<String> getDependencies() {
        return this.dependencies;
    }

    public Charset getTeXCharset() {
        return this.texCharset;
    }

    public boolean checkAcroShortcuts() {
        return this.checkAcroShortcuts;
    }

    public boolean checkAbbrvShortcuts() {
        return this.checkAbbrvShortcuts;
    }

    public boolean checkNestedLinkTextField(String string) {
        if (this.nestedLinkCheckFields == null) {
            return false;
        }
        for (int i = 0; i < this.nestedLinkCheckFields.length; ++i) {
            if (!string.equals(this.nestedLinkCheckFields[i])) continue;
            return true;
        }
        return false;
    }

    public boolean useGroupField() {
        return this.addGroupField;
    }

    public Vector<String> getFields() {
        return this.fields;
    }

    public void addField(String string) {
        if (!this.fields.contains(string)) {
            this.fields.add(string);
        }
    }

    public HashMap<String, String> getFieldMap() {
        return this.fieldMap;
    }

    public boolean isKnownField(String string) {
        if (this.fields.isEmpty()) {
            this.debug("Empty field list when checking for field '" + string + "'");
        }
        for (String string2 : this.fields) {
            if (string2.equals(string)) {
                return true;
            }
            if (!string.equals(this.fieldMap.get(string2))) continue;
            return true;
        }
        return false;
    }

    public GlsSeeRecord getSeeRecord(String string) {
        for (GlsSeeRecord glsSeeRecord : this.seeRecords) {
            if (!glsSeeRecord.getLabel().equals(string)) continue;
            return glsSeeRecord;
        }
        return null;
    }

    public Vector<GlsRecord> getRecords() {
        return this.records;
    }

    public boolean hasRecord(String string) {
        for (GlsRecord glsRecord : this.records) {
            if (!string.equals(glsRecord.getLabel())) continue;
            return true;
        }
        return false;
    }

    public boolean mfirstucProtection() {
        return this.mfirstucProtect;
    }

    public boolean mfirstucMathShiftProtection() {
        return this.mfirstucMProtect;
    }

    public String[] mfirstucProtectionFields() {
        return this.mfirstucProtectFields;
    }

    public void logMessage(String string) {
        if (this.logWriter != null) {
            this.logWriter.println(string);
        }
    }

    public void logMessage() {
        if (this.logWriter != null) {
            this.logWriter.println();
        }
    }

    public void logAndPrintMessage(String string) {
        if (this.logWriter != null) {
            this.logWriter.println(string);
        }
        System.out.println(string);
    }

    public int getDebugLevel() {
        return this.debugLevel;
    }

    public int getVerboseLevel() {
        return this.verboseLevel;
    }

    public void debug(String string) {
        if (this.debugLevel > 0) {
            this.logAndPrintMessage(string);
        }
    }

    public void debug(Throwable throwable) {
        if (this.debugLevel > 0) {
            String string = throwable.getMessage();
            if (string == null) {
                string = throwable.getClass().getSimpleName();
            }
            this.logAndPrintMessage(string);
            throwable.printStackTrace();
        }
    }

    public void debug(String string, Throwable throwable) {
        if (this.debugLevel > 0) {
            String string2 = throwable.getMessage();
            if (string2 == null) {
                string2 = throwable.getClass().getSimpleName();
            }
            if (string != null) {
                string2 = string + string2;
            }
            this.logAndPrintMessage(string2);
            throwable.printStackTrace();
        }
    }

    public void debug() {
        if (this.debugLevel > 0) {
            System.out.println();
            this.logMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String kpsewhich(String string) throws IOException, InterruptedException {
        this.debug(this.getMessageWithFallback("message.running", "Running {0}", String.format("kpsewhich '%s'", string)));
        Process process = new ProcessBuilder("kpsewhich", string).start();
        int n = process.waitFor();
        String string2 = null;
        if (n == 0) {
            InputStream inputStream = process.getInputStream();
            if (inputStream == null) {
                throw new IOException(this.getMessageWithFallback("error.cant.open.process.stream", "Unable to open input stream from process: {0}", String.format("kpsewhich '%s'", string)));
            }
            try (BufferedReader bufferedReader = null;){
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                string2 = bufferedReader.readLine();
                this.debug(this.getMessageWithFallback("message.process.result", "Processed returned: {0}", string2));
            }
        } else {
            String string3 = this.getMessageWithFallback("error.app_failed", "{0} failed with exit code {1}", String.format("kpsewhich '%s'", string), n);
            this.debug(string3);
            throw new FileNotFoundException(string3);
        }
        return string2;
    }

    public TeXPath getBibFilePath(TeXParser teXParser, String string) throws IOException, InterruptedException {
        TeXPath teXPath = new TeXPath(teXParser, string, "bib", false);
        File file = teXPath.getFile();
        if (!file.exists()) {
            Object object;
            this.debug(this.getMessage("error.file.not.found", file));
            File file2 = file;
            if (this.basePath.equals(this.cwd)) {
                object = this.auxFile.getParentFile();
                file2 = new File((File)object, file.getName());
            } else {
                file2 = this.resolvePath(teXPath.getRelativePath()).toFile();
                if (!file2.exists()) {
                    this.debug(this.getMessage("error.file.not.found", file2));
                    object = this.auxFile.getParentFile();
                    file2 = new File((File)object, file.getName());
                }
            }
            if (!file2.exists() && (object = this.kpsewhich(file.getName())) != null && !((String)object).isEmpty()) {
                return new TeXPath(teXParser, (String)object, "", false);
            }
            if (file2.exists()) {
                teXPath = new TeXPath(teXParser, file2);
            } else {
                this.debug(this.getMessage("error.file.not.found", file2));
            }
        }
        return teXPath;
    }

    @Override
    public void epstopdf(File file, File file2) throws IOException, InterruptedException {
        if (this.debugLevel > 0) {
            System.err.format("Ignoring unexpected request to convert %s to %s%n", file.toString(), file2.toString());
        }
    }

    @Override
    public void wmftoeps(File file, File file2) throws IOException, InterruptedException {
        if (this.debugLevel > 0) {
            System.err.format("Ignoring unexpected request to convert %s to %s%n", file.toString(), file2.toString());
        }
    }

    @Override
    public void substituting(TeXParser teXParser, String string, String string2) {
        this.verbose(this.getMessage("warning.substituting", string, string2));
    }

    @Override
    public String getMessage(String string) {
        if (this.messages == null) {
            return string;
        }
        String string2 = string;
        try {
            string2 = this.messages.getMessage(string, new Object[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.warning(String.format("Error fetching message for label '%s': %s", string, illegalArgumentException.getMessage()), illegalArgumentException);
        }
        return string2;
    }

    @Override
    public String getMessage(String string, String string2) {
        if (this.messages == null) {
            return String.format("%s[%s]", string, string2);
        }
        String string3 = string;
        try {
            string3 = this.messages.getMessage(string, string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.warning("Can't find message for label: " + string, illegalArgumentException);
        }
        return string3;
    }

    @Override
    public String getMessage(String string, String[] stringArray) {
        if (this.messages == null) {
            String string2 = stringArray.length == 0 ? "" : stringArray[0];
            for (int i = 1; i < stringArray.length; ++i) {
                string2 = string2 + "," + stringArray[0];
            }
            return String.format("%s[%s]", string, string2);
        }
        String string3 = string;
        try {
            string3 = this.messages.getMessage(string, stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.warning("Can't find message for label: " + string, illegalArgumentException);
        }
        return string3;
    }

    @Override
    public String getMessage(String string, Object ... objectArray) {
        if (this.messages == null) {
            String string2 = objectArray.length == 0 ? "" : objectArray[0].toString();
            for (int i = 1; i < objectArray.length; ++i) {
                string2 = string2 + "," + objectArray[0].toString();
            }
            return String.format("%s[%s]", string, string2);
        }
        String string3 = string;
        try {
            string3 = this.messages.getMessage(string, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.warning("Can't find message for label: " + string, illegalArgumentException);
        }
        return string3;
    }

    public String getMessage(TeXParser teXParser, String string, Object ... objectArray) {
        if (teXParser == null) {
            return this.getMessage(string, objectArray);
        }
        int n = teXParser.getLineNumber();
        File file = teXParser.getCurrentFile();
        if (n == -1 || file == null) {
            return this.getMessage(string, objectArray);
        }
        return Bib2Gls.fileLineMessage(file, n, this.getMessage(string, objectArray));
    }

    public String getMessageWithFallback(String string, String string2, Object ... objectArray) {
        if (this.messages == null) {
            MessageFormat messageFormat = new MessageFormat(string2);
            return MessageFormat.format(string2, objectArray);
        }
        try {
            return this.messages.getMessage(string, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.warning("Can't find message for label: " + string, illegalArgumentException);
            MessageFormat messageFormat = new MessageFormat(string2);
            return MessageFormat.format(string2, objectArray);
        }
    }

    public String getMessageIfExists(String string) {
        if (this.messages == null) {
            return null;
        }
        return this.messages.getMessageIfExists(string, new Object[0]);
    }

    public String getChoiceMessage(String string, int n, String string2, int n2, Object ... objectArray) {
        if (this.messages == null) {
            String string3 = objectArray.length == 0 ? "" : objectArray[0].toString();
            for (int i = 1; i < objectArray.length; ++i) {
                string3 = string3 + "," + objectArray[0].toString();
            }
            return String.format("%s[%s]", string, string3);
        }
        String string4 = string;
        try {
            string4 = this.messages.getChoiceMessage(string, n, string2, n2, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.warning("Can't find message for label: " + string, illegalArgumentException);
        }
        return string4;
    }

    @Override
    public void message(String string) {
        if (this.verboseLevel >= 0) {
            System.out.println(string);
        }
        this.logMessage(string);
    }

    public void verbose(String string) {
        if (this.verboseLevel > 0) {
            System.out.println(string);
        }
        this.logMessage(string);
    }

    public void verbose() {
        if (this.verboseLevel > 0) {
            System.out.println();
        }
        this.logMessage();
    }

    public void verbose(TeXParser teXParser, String string) {
        int n = teXParser.getLineNumber();
        File file = teXParser.getCurrentFile();
        if (n != -1 && file != null) {
            string = Bib2Gls.fileLineMessage(file, n, string);
        }
        this.verbose(string);
    }

    public static String fileLineMessage(File file, int n, String string) {
        return String.format("%s:%d: %s", file.toString(), n, string);
    }

    @Override
    public void warning(TeXParser teXParser, String string) {
        if (this.verboseLevel >= 0) {
            int n = teXParser.getLineNumber();
            File file = teXParser.getCurrentFile();
            if (n == -1 || file == null) {
                this.warning(string);
            } else {
                this.warning(file, n, string);
            }
        }
    }

    public void warning(File file, int n, String string) {
        if (this.verboseLevel >= 0) {
            this.warning(Bib2Gls.fileLineMessage(file, n, string));
        }
    }

    public void warning(File file, int n, String string, Exception exception) {
        if (this.verboseLevel >= 0) {
            this.warning(Bib2Gls.fileLineMessage(file, n, string), exception);
        }
    }

    public void warning(String string) {
        string = this.getMessageWithFallback("warning.title", "Warning: {0}", string);
        if (this.verboseLevel >= 0) {
            System.err.println(string);
        }
        this.logMessage(string);
    }

    public void warning() {
        if (this.verboseLevel >= 0) {
            System.err.println();
        }
        this.logMessage();
    }

    public void warning(String string, Exception exception) {
        if (this.verboseLevel >= 0) {
            System.err.println(string);
        }
        this.logMessage(string);
        if (this.debugLevel > 0) {
            exception.printStackTrace();
            for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
                this.logMessage(stackTraceElement.toString());
            }
        }
    }

    @Override
    public void error(Exception exception) {
        if (exception instanceof TeXSyntaxException) {
            this.error(((TeXSyntaxException)exception).getMessage(this));
        } else {
            StackTraceElement[] stackTraceElementArray = exception.getMessage();
            if (stackTraceElementArray == null) {
                stackTraceElementArray = exception.getClass().getSimpleName();
            }
            this.error((String)stackTraceElementArray);
        }
        if (this.debugLevel > 0) {
            exception.printStackTrace();
            for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
                this.logMessage(stackTraceElement.toString());
            }
        }
        this.exitCode = 2;
    }

    public void error(String string) {
        string = this.getMessageWithFallback("error.title", "Error: {0}", string);
        System.err.println(string);
        this.logMessage(string);
    }

    @Override
    public void copyFile(File file, File file2) throws IOException, InterruptedException {
        if (this.debugLevel > 0) {
            System.err.format("Ignoring unexpected request to copy files %s -> %s%n", file.toString(), file2.toString());
        }
    }

    @Override
    public String requestUserInput(String string) throws IOException {
        if (this.debugLevel > 0) {
            System.err.format("Ignoring unexpected request for user input. Message: %s%n", string);
        }
        return "";
    }

    public void version() {
        System.out.println(this.getMessageWithFallback("about.version", "{0} version {1} ({2})", NAME, VERSION, DATE));
    }

    public void license() {
        System.out.println("Copyright 2017 Nicola Talbot");
        System.out.println(this.getMessage("about.license"));
    }

    public void help() {
        System.out.println(this.getMessage("syntax.usage", NAME));
        System.out.println();
        System.out.println(this.getMessage("syntax.info"));
        System.out.println();
        System.out.println(this.getMessage("syntax.options"));
        System.out.println();
        System.out.println(this.getMessage("syntax.help", "--help", "-h"));
        System.out.println(this.getMessage("syntax.version", "--version", "-v"));
        System.out.println(this.getMessage("syntax.debug", "--debug"));
        System.out.println(this.getMessage("syntax.nodebug", "--no-debug", "--nodebug"));
        System.out.println(this.getMessage("syntax.verbose", "--verbose"));
        System.out.println(this.getMessage("syntax.noverbose", "--no-verbose", "--noverbose"));
        System.out.println(this.getMessage("syntax.silent", "--silent"));
        System.out.println();
        System.out.println(this.getMessage("syntax.locale", "--locale", "-l"));
        System.out.println(this.getMessage("syntax.log", "--log-file", "-t"));
        System.out.println(this.getMessage("syntax.dir", "--dir", "-d"));
        System.out.println();
        System.out.println(this.getMessage("syntax.interpret", "--interpret"));
        System.out.println(this.getMessage("syntax.no.interpret", "--no-interpret"));
        System.out.println();
        System.out.println();
        System.out.println(this.getMessage("syntax.mfirstuc", "--mfirstuc-protection", "-u"));
        System.out.println();
        System.out.println(this.getMessage("syntax.no.mfirstuc", "--no-mfirstuc-protection"));
        System.out.println();
        System.out.println(this.getMessage("syntax.no.math.mfirstuc", "--no-mfirstuc-math-protection"));
        System.out.println();
        System.out.println(this.getMessage("syntax.math.mfirstuc", "--mfirstuc-math-protection", "--no-mfirstuc-protection"));
        System.out.println();
        System.out.println(this.getMessage("syntax.check.shortcuts", "--shortcuts"));
        System.out.println();
        System.out.println(this.getMessage("syntax.check.nested", "--nested-link-check"));
        System.out.println();
        System.out.println(this.getMessage("syntax.nocheck.nested", "--no-nested-link-check", "--nested-link-check"));
        System.out.println();
        System.out.println(this.getMessage("syntax.format.map", "--map-format", "-m"));
        System.out.println();
        System.out.println(this.getMessage("syntax.group", "--group", "-g"));
        System.out.println();
        System.out.println(this.getMessage("syntax.no.group", "--no-group"));
        System.out.println();
        System.out.println(this.getMessage("syntax.trim.fields", "--trim-fields"));
        System.out.println();
        System.out.println(this.getMessage("syntax.no.trim.fields", "--no-trim-fields"));
        System.out.println();
        System.out.println(this.getMessage("syntax.tex.encoding", "--tex-encoding"));
        System.exit(0);
    }

    private String getLanguageFileName(String string) {
        return String.format("/resources/bib2gls-%s.xml", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMessages(String string) throws Bib2GlsException, IOException {
        Object object;
        Locale locale = string == null || "".equals(string) ? Locale.getDefault() : Locale.forLanguageTag(string);
        this.docLocale = locale.toLanguageTag();
        String string2 = locale.toLanguageTag();
        String string3 = this.getLanguageFileName(string2);
        URL uRL = this.getClass().getResource(string3);
        String string4 = "";
        if (this.debugLevel > 0) {
            string4 = this.getClass().getProtectionDomain().getCodeSource().getLocation().toString();
        }
        if (uRL == null) {
            this.debug(String.format("Can't find language resource: %s!%s", string4, string3));
            string2 = locale.getLanguage();
            string3 = this.getLanguageFileName(string2);
            this.debug("Trying: " + string3);
            uRL = this.getClass().getResource(string3);
            if (uRL == null) {
                this.debug(String.format("Can't find language resource: %s!%s", string4, string3));
                object = locale.getScript();
                if (object != null && !((String)object).isEmpty()) {
                    string3 = this.getLanguageFileName(String.format("%s-%s", string2, object));
                    this.debug("Trying: " + string3);
                    uRL = this.getClass().getResource(string3);
                    if (uRL == null && !string2.equals("en")) {
                        this.debug(String.format("Can't find language resource: %s!%s%nDefaulting to 'en'", string4, string3));
                        uRL = this.getClass().getResource(this.getLanguageFileName("en"));
                    }
                } else if (!string2.equals("en")) {
                    this.debug("Defaulting to 'en'");
                    uRL = this.getClass().getResource(this.getLanguageFileName("en"));
                }
                if (uRL == null) {
                    throw new Bib2GlsException("Can't find language resource file.");
                }
            }
        }
        object = null;
        try {
            this.debug("Reading " + uRL);
            object = uRL.openStream();
            Properties properties = new Properties();
            properties.loadFromXML((InputStream)object);
            ((InputStream)object).close();
            object = null;
            this.messages = new Bib2GlsMessages(properties);
        }
        finally {
            if (object != null) {
                ((InputStream)object).close();
            }
        }
    }

    private void setShortCuts(String string) {
        if (string.equals("acro") || string.equals("acronyms") || string.equals("ac")) {
            this.shortcuts = string;
            this.checkAcroShortcuts = true;
        } else if (string.equals("abbr") || string.equals("abbreviations")) {
            this.shortcuts = string;
            this.checkAbbrvShortcuts = true;
        } else if (string.equals("all") || string.equals("true")) {
            this.shortcuts = string;
            this.checkAcroShortcuts = true;
            this.checkAbbrvShortcuts = true;
        } else if (string.equals("none") || string.equals("false")) {
            this.shortcuts = string;
            this.checkAcroShortcuts = false;
            this.checkAbbrvShortcuts = false;
        } else {
            throw new IllegalArgumentException("Invalid shortcut value: " + string);
        }
    }

    public void setDocDefaultLocale(String string) {
        this.docLocale = string;
    }

    public String getDocDefaultLocale() {
        return this.docLocale;
    }

    public void setTrimFields(boolean bl) {
        this.trimFields = bl;
    }

    public boolean trimFields() {
        return this.trimFields;
    }

    private static int parseArgVal(String[] stringArray, int n, Object[] objectArray) {
        String[] stringArray2 = stringArray[n].startsWith("--") ? stringArray[n].split("=", 2) : new String[]{stringArray[n]};
        objectArray[0] = stringArray2[0];
        if (stringArray2.length == 2) {
            objectArray[1] = stringArray2[1];
            return n;
        }
        if (n == stringArray.length - 1 || stringArray[n + 1].startsWith("-")) {
            objectArray[1] = null;
            return n;
        }
        objectArray[1] = stringArray[++n];
        return n;
    }

    private int parseArgInt(String[] stringArray, int n, Object[] objectArray) {
        return Bib2Gls.parseArgInt(stringArray, n, objectArray, this);
    }

    private int parseArgInt(String[] stringArray, int n, Object[] objectArray, int n2) {
        return Bib2Gls.parseArgInt(stringArray, n, objectArray, n2, this);
    }

    private static int parseArgInt(String[] stringArray, int n, Object[] objectArray, Bib2Gls bib2Gls) {
        n = Bib2Gls.parseArgVal(stringArray, n, objectArray);
        if (objectArray[1] != null) {
            try {
                objectArray[1] = new Integer((String)objectArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                if (bib2Gls == null) {
                    throw new IllegalArgumentException("Invalid integer argument", numberFormatException);
                }
                throw new IllegalArgumentException(bib2Gls.getMessage("error.invalid.opt.int.value", objectArray[0], objectArray[1]), numberFormatException);
            }
        }
        return n;
    }

    private static int parseArgInt(String[] stringArray, int n, Object[] objectArray, int n2, Bib2Gls bib2Gls) {
        n = Bib2Gls.parseArgVal(stringArray, n, objectArray);
        if (objectArray[1] == null) {
            objectArray[1] = new Integer(n2);
        } else {
            try {
                objectArray[1] = new Integer((String)objectArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                objectArray[1] = new Integer(n2);
                return n - 1;
            }
        }
        return n;
    }

    private static boolean isArg(String string, String string2, String string3) {
        return string.equals("-" + string2) || string.equals("--" + string3) || string.startsWith("--" + string3 + "=");
    }

    private static boolean isArg(String string, String string2) {
        return string.equals("--" + string2) || string.startsWith("--" + string2 + "=");
    }

    private void parseArgs(String[] stringArray) throws IOException, Bib2GlsSyntaxException {
        String string = null;
        String string2 = null;
        String string3 = null;
        Object[] objectArray = new Object[2];
        for (int i = 0; i < stringArray.length; ++i) {
            if (Bib2Gls.isArg(stringArray[i], "debug")) {
                i = this.parseArgInt(stringArray, i, objectArray, 1);
                int n = (Integer)objectArray[1];
                if (n < 0) {
                    throw new IllegalArgumentException(this.getMessage("error.invalid.opt.minint.value", objectArray[0], n, 0));
                }
                this.verboseLevel = this.debugLevel = n;
                continue;
            }
            if (stringArray[i].equals("--no-debug") || stringArray[i].equals("--nodebug")) {
                this.debugLevel = 0;
                continue;
            }
            if (stringArray[i].equals("--verbose")) {
                this.verboseLevel = 1;
                continue;
            }
            if (stringArray[i].equals("--no-verbose") || stringArray[i].equals("--noverbose")) {
                this.verboseLevel = 0;
                continue;
            }
            if (stringArray[i].equals("--silent")) {
                this.verboseLevel = -1;
                continue;
            }
            if (Bib2Gls.isArg(stringArray[i], "l", "locale")) {
                i = Bib2Gls.parseArgVal(stringArray, i, objectArray);
                if (objectArray[1] != null) continue;
                throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", objectArray[0]));
            }
            if (stringArray[i].equals("-h") || stringArray[i].equals("--help")) {
                this.help();
                continue;
            }
            if (stringArray[i].equals("-v") || stringArray[i].equals("--version")) {
                if (!this.shownVersion) {
                    this.version();
                }
                this.license();
                System.exit(0);
                continue;
            }
            if (Bib2Gls.isArg(stringArray[i], "t", "log-file")) {
                i = Bib2Gls.parseArgVal(stringArray, i, objectArray);
                if (objectArray[1] == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", objectArray[0]));
                }
                string3 = (String)objectArray[1];
                continue;
            }
            if (stringArray[i].equals("--interpret")) {
                this.interpret = true;
                continue;
            }
            if (stringArray[i].equals("--no-interpret")) {
                this.interpret = false;
                continue;
            }
            if (stringArray[i].equals("--no-mfirstuc-protection")) {
                this.mfirstucProtect = false;
                continue;
            }
            if (Bib2Gls.isArg(stringArray[i], "u", "mfirstuc-protection")) {
                i = Bib2Gls.parseArgVal(stringArray, i, objectArray);
                this.mfirstucProtect = true;
                String string4 = (String)objectArray[1];
                if (string4 == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", objectArray[0]));
                }
                if (string4.equals("all")) {
                    this.mfirstucProtectFields = null;
                    continue;
                }
                if (string4.isEmpty()) {
                    this.mfirstucProtect = false;
                    continue;
                }
                this.mfirstucProtectFields = string4.split(" *, *");
                continue;
            }
            if (stringArray[i].equals("--no-mfirstuc-math-protection")) {
                this.mfirstucMProtect = false;
                continue;
            }
            if (stringArray[i].equals("--mfirstuc-math-protection")) {
                this.mfirstucMProtect = true;
                continue;
            }
            if (Bib2Gls.isArg(stringArray[i], "shortcuts")) {
                i = Bib2Gls.parseArgVal(stringArray, i, objectArray);
                String string5 = (String)objectArray[1];
                if (string5 == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", objectArray[0]));
                }
                try {
                    this.setShortCuts(string5);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.invalid.choice.value", objectArray[0], string5), illegalArgumentException);
                }
            }
            if (Bib2Gls.isArg(stringArray[i], "nested-link-check")) {
                i = Bib2Gls.parseArgVal(stringArray, i, objectArray);
                String string6 = (String)objectArray[1];
                if (string6 == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", objectArray[0]));
                }
                if (string6.equals("none") || string6.isEmpty()) {
                    this.nestedLinkCheckFields = null;
                    continue;
                }
                this.nestedLinkCheckFields = string6.split(" *, *");
                continue;
            }
            if (stringArray[i].equals("--no-nested-link-check")) {
                this.nestedLinkCheckFields = null;
                continue;
            }
            if (Bib2Gls.isArg(stringArray[i], "d", "dir")) {
                i = Bib2Gls.parseArgVal(stringArray, i, objectArray);
                if (objectArray[1] == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", objectArray[0]));
                }
                string = (String)objectArray[1];
                continue;
            }
            if (Bib2Gls.isArg(stringArray[i], "m", "map-format")) {
                String[] stringArray2;
                i = Bib2Gls.parseArgVal(stringArray, i, objectArray);
                String string7 = (String)objectArray[1];
                if (string7 == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", objectArray[0]));
                }
                for (String string8 : stringArray2 = string7.trim().split(" *, *")) {
                    String[] stringArray3 = string8.split(" *: *");
                    if (stringArray3.length != 2) {
                        throw new Bib2GlsSyntaxException(this.getMessage("error.invalid.opt.value", objectArray[0], string7));
                    }
                    this.formatMap.put(stringArray3[0], stringArray3[1]);
                }
                continue;
            }
            if (stringArray[i].equals("--group") || stringArray[i].equals("-g")) {
                this.addGroupField = true;
                continue;
            }
            if (stringArray[i].equals("--no-group")) {
                this.addGroupField = false;
                continue;
            }
            if (Bib2Gls.isArg(stringArray[i], "tex-encoding")) {
                i = Bib2Gls.parseArgVal(stringArray, i, objectArray);
                String string9 = (String)objectArray[1];
                if (string9 == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", objectArray[0]));
                }
                this.texCharset = Charset.forName(string9);
                continue;
            }
            if (stringArray[i].equals("--trim-fields")) {
                this.trimFields = true;
                continue;
            }
            if (stringArray[i].equals("--no-trim-fields")) {
                this.trimFields = false;
                continue;
            }
            if (stringArray[i].startsWith("-")) {
                throw new Bib2GlsSyntaxException(this.getMessage("error.syntax.unknown_option", stringArray[i]));
            }
            if (string2 == null) {
                string2 = stringArray[i];
                continue;
            }
            throw new Bib2GlsSyntaxException(this.getMessage("error.only.one.aux"));
        }
        if (string2 == null) {
            throw new Bib2GlsSyntaxException(this.getMessage("error.no.aux"));
        }
        if (!string2.endsWith(".aux")) {
            string2 = string2 + ".aux";
        }
        File file = null;
        this.auxFile = new File(string2);
        if (string != null) {
            file = new File(string);
            this.basePath = file.toPath();
            if (!file.exists()) {
                System.err.println(this.getMessage("error.dir.not.found", string));
                System.exit(1);
            }
            if (!file.isDirectory()) {
                System.err.println(this.getMessage("error.not.dir", string));
                System.exit(1);
            }
            this.auxFile = this.auxFile.getParentFile() == null ? new File(file, string2) : file.toPath().resolve(this.auxFile.toPath()).toFile();
        } else {
            file = this.auxFile.getParentFile();
            this.basePath = this.cwd;
        }
        if (!this.auxFile.exists()) {
            System.err.println(this.getMessage("error.file.not.found", string2));
            System.exit(0);
        }
        this.logFile = null;
        if (string3 == null) {
            String string10 = this.auxFile.getName();
            this.logFile = new File(file, string10.substring(0, string10.lastIndexOf(".")) + ".glg");
        } else {
            this.logFile = this.resolveFile(string3);
        }
        this.logFile = this.getWritableFile(this.logFile);
        try {
            this.logWriter = new PrintWriter(new FileWriter(this.logFile));
            this.logMessage(this.getMessage("about.version", NAME, VERSION, DATE));
            this.debug(String.format("openin_any=%s%nopenout_any=%s%nTEXMFOUTPUT=%s%ncwd=%s", Character.valueOf(this.openin_any), Character.valueOf(this.openout_any), this.texmfoutput == null ? "" : this.texmfoutput, this.cwd));
        }
        catch (IOException iOException) {
            this.logWriter = null;
            System.err.println(this.getMessage("error.cant.open.log", this.logFile.toString()));
            this.error(iOException);
        }
    }

    public static void exit(Bib2Gls bib2Gls, int n) {
        if (bib2Gls != null && bib2Gls.logWriter != null) {
            bib2Gls.logWriter.close();
            bib2Gls.message(bib2Gls.getMessageWithFallback("message.log.file", "Transcript written to {0}.", bib2Gls.logFile));
            bib2Gls.logWriter = null;
        }
        System.exit(n);
    }

    public static void main(String[] stringArray) {
        Bib2Gls bib2Gls = null;
        int n = 0;
        int n2 = 0;
        String string = null;
        Object[] objectArray = new Object[2];
        for (int i = 0; i < stringArray.length; ++i) {
            if (Bib2Gls.isArg(stringArray[i], "debug")) {
                try {
                    i = Bib2Gls.parseArgInt(stringArray, i, objectArray, 1, null);
                    n = (Integer)objectArray[1];
                }
                catch (Exception exception) {
                    n = 1;
                }
                continue;
            }
            if (stringArray[i].equals("--no-debug") || stringArray[i].equals("--nodebug")) {
                n = 0;
                continue;
            }
            if (stringArray[i].equals("--silent")) {
                n2 = -1;
                continue;
            }
            if (stringArray[i].equals("--verbose")) {
                n2 = 1;
                continue;
            }
            if (stringArray[i].equals("--noverbose")) {
                n2 = 0;
                continue;
            }
            if (!Bib2Gls.isArg(stringArray[i], "l", "locale")) continue;
            i = Bib2Gls.parseArgVal(stringArray, i, objectArray);
            string = (String)objectArray[1];
        }
        try {
            bib2Gls = new Bib2Gls(n, n2, string);
            bib2Gls.process(stringArray);
            if (bib2Gls.exitCode != 0) {
                Bib2Gls.exit(bib2Gls, bib2Gls.exitCode);
            }
        }
        catch (Bib2GlsSyntaxException bib2GlsSyntaxException) {
            System.err.println(bib2GlsSyntaxException.getMessage());
            System.err.println(bib2Gls.getMessage("syntax.use.help"));
            System.exit(1);
        }
        catch (Exception exception) {
            if (bib2Gls == null) {
                System.err.println("Fatal error: " + exception.getMessage());
                if (n > 0) {
                    exception.printStackTrace();
                }
            } else {
                bib2Gls.error(exception);
            }
            Bib2Gls.exit(bib2Gls, 3);
        }
    }
}

