/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.results.ResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.CPUResultsDiff;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.lib.profiler.ui.components.HTMLLabel;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.lib.profiler.ui.cpu.CCTDisplay;
import org.netbeans.lib.profiler.ui.cpu.CPUResUserActionsHandler;
import org.netbeans.lib.profiler.ui.cpu.DiffCCTDisplay;
import org.netbeans.lib.profiler.ui.cpu.DiffFlatProfilePanel;
import org.netbeans.lib.profiler.ui.cpu.ScreenshotProvider;
import org.netbeans.lib.profiler.ui.cpu.SnapshotFlatProfilePanel;
import org.netbeans.lib.profiler.ui.cpu.SubtreeCallGraphPanel;
import org.netbeans.modules.profiler.Bundle;
import org.netbeans.modules.profiler.ExportAction;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.SaveViewAction;
import org.netbeans.modules.profiler.SnapshotPanel;
import org.netbeans.modules.profiler.SnapshotResultsWindow;
import org.netbeans.modules.profiler.actions.FindNextAction;
import org.netbeans.modules.profiler.actions.FindPreviousAction;
import org.netbeans.modules.profiler.api.GoToSource;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProfilingSettingsManager;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.ui.FindDialog;
import org.netbeans.modules.profiler.utilities.ProfilerUtils;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.actions.FindAction;
import org.openide.filesystems.FileUtil;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;

public final class CPUDiffPanel
extends SnapshotPanel
implements ActionListener,
ChangeListener,
SnapshotResultsWindow.FindPerformer,
SaveViewAction.ViewProvider,
ExportAction.ExportProvider {
    private static final Icon CLASSES_ICON = Icons.getIcon((String)"LanguageIcons.Class");
    private static final Icon METHODS_ICON = Icons.getIcon((String)"LanguageIcons.Methods");
    private static final Icon PACKAGES_ICON = Icons.getIcon((String)"LanguageIcons.Package");
    private static final Icon THREADS_ICON = Icons.getIcon((String)"ProfilerIcons.Thread");
    private static final Icon CALL_TREE_TAB_ICON = Icons.getIcon((String)"ProfilerIcons.TabCallTree");
    private static final Icon HOTSPOTS_TAB_ICON = Icons.getIcon((String)"ProfilerIcons.TabHotSpots");
    private static final Icon SUBTREE_TAB_ICON = Icons.getIcon((String)"ProfilerIcons.TabSubtree");
    private CCTDisplay cctPanel;
    private CPUResultsDiff snapshot;
    private JComboBox aggregationCombo;
    private LoadedSnapshot loadedSnapshot;
    private SnapshotFlatProfilePanel flatPanel;
    private SubtreeCallGraphPanel subtreeView;
    private boolean internalChange = false;
    private int currentAggregationMode;
    private Boolean sampling;

    public CPUDiffPanel(Lookup lookup, LoadedSnapshot loadedSnapshot, LoadedSnapshot loadedSnapshot2, LoadedSnapshot loadedSnapshot3, int n, boolean bl) {
        String string;
        WeakReference[] weakReferenceArray;
        this.loadedSnapshot = loadedSnapshot;
        this.snapshot = (CPUResultsDiff)loadedSnapshot.getSnapshot();
        CPUActionsHandler cPUActionsHandler = new CPUActionsHandler();
        boolean bl2 = loadedSnapshot2.getSettings().getCPUProfilingType() == 2;
        boolean bl3 = loadedSnapshot3.getSettings().getCPUProfilingType() == 2;
        this.sampling = bl2 != bl3 ? null : Boolean.valueOf(bl2);
        this.flatPanel = new DiffFlatProfilePanel((CPUResUserActionsHandler)cPUActionsHandler, this.sampling);
        this.cctPanel = new DiffCCTDisplay((CPUResUserActionsHandler)cPUActionsHandler, this.sampling);
        this.flatPanel.setSorting(n, bl);
        this.cctPanel.setSorting(n, bl);
        if (this.cctPanel.getPopupFindItem() != null) {
            this.cctPanel.getPopupFindItem().setText(Bundle.CPUSnapshotPanel_FindInStatement(Bundle.CPUSnapshotPanel_HotSpotsString()));
            this.cctPanel.getPopupFindItem().setVisible(true);
        }
        if (this.flatPanel.getPopupFindItem() != null) {
            this.flatPanel.getPopupFindItem().setText(Bundle.CPUSnapshotPanel_FindInStatement(Bundle.CPUSnapshotPanel_CallTreeString()));
            this.flatPanel.getPopupFindItem().setVisible(true);
        }
        this.flatPanel.setDataToDisplay((CPUResultsSnapshot)this.snapshot, -1, 0);
        this.cctPanel.setDataToDisplay((CPUResultsSnapshot)this.snapshot, 0);
        this.flatPanel.prepareResults();
        this.cctPanel.prepareResults();
        this.addView(Bundle.CPUSnapshotPanel_CallTreeString(), CALL_TREE_TAB_ICON, Bundle.CPUSnapshotPanel_CallTreeTabDescr(), (Component)this.cctPanel, null);
        this.addView(Bundle.CPUSnapshotPanel_HotSpotsString(), HOTSPOTS_TAB_ICON, Bundle.CPUSnapshotPanel_HotSpotTabDescr(), (Component)this.flatPanel, null);
        this.addChangeListener(this);
        ProfilerToolbar profilerToolbar = ProfilerToolbar.create((boolean)true);
        profilerToolbar.add((Action)new ExportAction(this, this.loadedSnapshot));
        profilerToolbar.add((Action)new SaveViewAction(this));
        profilerToolbar.addSeparator();
        this.aggregationCombo = new JComboBox(new Object[]{Bundle.CPUSnapshotPanel_MethodsString(), Bundle.CPUSnapshotPanel_ClassesString(), Bundle.CPUSnapshotPanel_PackagesString()}){

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(this.getPreferredSize().width + 20, this.getPreferredSize().height);
            }
        };
        this.aggregationCombo.getAccessibleContext().setAccessibleName(Bundle.CPUSnapshotPanel_AggregationComboAccessName());
        this.aggregationCombo.getAccessibleContext().setAccessibleDescription(Bundle.CPUSnapshotPanel_AggregationComboAccessDescr());
        this.currentAggregationMode = 0;
        String[] stringArray = this.snapshot.getThreadNames();
        Object[] objectArray = new Object[stringArray.length + 1];
        objectArray[0] = new Object(){

            public String toString() {
                return Bundle.CPUSnapshotPanel_AllThreadsItem();
            }
        };
        for (int i = 0; i < stringArray.length; ++i) {
            final String string2 = stringArray[i];
            objectArray[i + 1] = new Object(){

                public String toString() {
                    return string2;
                }
            };
        }
        this.aggregationCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                DefaultListCellRenderer defaultListCellRenderer = (DefaultListCellRenderer)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (Bundle.CPUSnapshotPanel_MethodsString().equals(object)) {
                    defaultListCellRenderer.setIcon(METHODS_ICON);
                } else if (Bundle.CPUSnapshotPanel_ClassesString().equals(object)) {
                    defaultListCellRenderer.setIcon(CLASSES_ICON);
                } else if (Bundle.CPUSnapshotPanel_PackagesString().equals(object)) {
                    defaultListCellRenderer.setIcon(PACKAGES_ICON);
                }
                return defaultListCellRenderer;
            }
        });
        JLabel jLabel = new JLabel(Bundle.CPUSnapshotPanel_ViewLabelString());
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
        jLabel.setLabelFor(this.aggregationCombo);
        int n2 = 0;
        jLabel.setDisplayedMnemonic(jLabel.getText().charAt(n2));
        jLabel.setDisplayedMnemonicIndex(n2);
        profilerToolbar.add((Component)jLabel);
        profilerToolbar.add((Component)this.aggregationCombo);
        this.aggregationCombo.addActionListener(this);
        profilerToolbar.addSpace(6);
        profilerToolbar.addSeparator();
        ContextAwareAction contextAwareAction = (ContextAwareAction)SystemAction.get(FindAction.class);
        Component component = profilerToolbar.add(contextAwareAction.createContextAwareInstance(lookup));
        profilerToolbar.add((Action)new FindPreviousAction(this));
        profilerToolbar.add((Action)new FindNextAction(this));
        if (component instanceof AbstractButton) {
            weakReferenceArray = (WeakReference[])component;
            weakReferenceArray.setIcon(Icons.getIcon((String)"GeneralIcons.Find"));
            weakReferenceArray.setText("");
            weakReferenceArray.setToolTipText(Bundle.CPUSnapshotPanel_FindActionTooltip());
        }
        profilerToolbar.addFiller();
        weakReferenceArray = new WeakReference[2];
        final String string3 = loadedSnapshot2.getFile() == null ? null : loadedSnapshot2.getFile().getAbsolutePath();
        String string4 = string = loadedSnapshot3.getFile() == null ? null : loadedSnapshot3.getFile().getAbsolutePath();
        if (string3 == null) {
            weakReferenceArray[0] = new WeakReference<LoadedSnapshot>(loadedSnapshot2);
        }
        if (string == null) {
            weakReferenceArray[1] = new WeakReference<LoadedSnapshot>(loadedSnapshot3);
        }
        final ResultsManager resultsManager = ResultsManager.getDefault();
        String string5 = "<a href='file:/1'>" + resultsManager.getSnapshotDisplayName(loadedSnapshot2) + "</a>";
        String string6 = "<a href='file:/2'>" + resultsManager.getSnapshotDisplayName(loadedSnapshot3) + "</a>";
        HTMLLabel hTMLLabel = new HTMLLabel(Bundle.MemoryDiffPanel_SnapshotsComparisonString(string5, string6)){

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }

            protected void showURL(URL uRL) {
                Object object;
                LoadedSnapshot loadedSnapshot = null;
                if ("file:/1".equals(uRL.toString())) {
                    if (string3 != null) {
                        object = new File(string3);
                        if (((File)object).exists()) {
                            loadedSnapshot = resultsManager.loadSnapshot(FileUtil.toFileObject((File)object));
                        }
                    } else {
                        loadedSnapshot = (LoadedSnapshot)weakReferenceArray[0].get();
                    }
                } else if ("file:/2".equals(uRL.toString())) {
                    if (string != null) {
                        object = new File(string);
                        if (((File)object).exists()) {
                            loadedSnapshot = resultsManager.loadSnapshot(FileUtil.toFileObject((File)object));
                        }
                    } else {
                        loadedSnapshot = (LoadedSnapshot)weakReferenceArray[1].get();
                    }
                }
                if (loadedSnapshot != null) {
                    object = SnapshotResultsWindow.get(loadedSnapshot);
                    object.open();
                    object.requestActive();
                } else {
                    ProfilerDialogs.displayWarning((String)Bundle.MemoryDiffPanel_SnapshotNotAvailableMsg());
                }
            }
        };
        hTMLLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
        profilerToolbar.add((Component)hTMLLabel);
        this.updateToolbar();
        this.setMainToolbar(profilerToolbar.getComponent());
        this.getInputMap(2).put(KeyStroke.getKeyStroke(114, 1), "FIND_PREVIOUS");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(114, 1), "FIND_PREVIOUS");
        this.getActionMap().put("FIND_PREVIOUS", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CPUDiffPanel.this.performFindPrevious();
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(114, 0), "FIND_NEXT");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(114, 0), "FIND_NEXT");
        this.getActionMap().put("FIND_NEXT", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CPUDiffPanel.this.performFindNext();
            }
        });
    }

    @Override
    public ResultsSnapshot getSnapshot() {
        return this.snapshot;
    }

    @Override
    public BufferedImage getViewImage(boolean bl) {
        Component component = this.getSelectedView();
        if (!(component instanceof ScreenshotProvider)) {
            return null;
        }
        return ((ScreenshotProvider)component).getCurrentViewScreenshot(bl);
    }

    @Override
    public String getViewName() {
        Component component = this.getSelectedView();
        if (!(component instanceof ScreenshotProvider)) {
            return null;
        }
        String string = ((ScreenshotProvider)component).getDefaultViewName();
        return this.getDefaultSnapshotFileName(this.getSnapshot()) + "-" + string;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.internalChange) {
            return;
        }
        Object object = actionEvent.getSource();
        if (object == this.aggregationCombo) {
            Object object2 = this.aggregationCombo.getSelectedItem();
            if (Bundle.CPUSnapshotPanel_MethodsString().equals(object2)) {
                this.changeView(0);
            } else if (Bundle.CPUSnapshotPanel_ClassesString().equals(object2)) {
                this.changeView(1);
            } else if (Bundle.CPUSnapshotPanel_PackagesString().equals(object2)) {
                this.changeView(2);
            }
        }
    }

    public void changeView(int n) {
        if (this.currentAggregationMode == n) {
            return;
        }
        this.currentAggregationMode = n;
        this.flatPanel.clearSelection();
        this.flatPanel.changeView(n);
        this.cctPanel.clearSelection();
        this.cctPanel.changeView(n);
        this.viewChanged(n);
    }

    @Override
    public boolean fitsVisibleArea() {
        Component component = this.getSelectedView();
        if (!(component instanceof ScreenshotProvider)) {
            return false;
        }
        return ((ScreenshotProvider)component).fitsVisibleArea();
    }

    @Override
    public boolean hasView() {
        Component component = this.getSelectedView();
        return component != null && component instanceof ScreenshotProvider;
    }

    @Override
    public void performFind() {
        String string = FindDialog.getFindString();
        if (string == null) {
            return;
        }
        this.setFindString(string);
        this.performFindFirst();
    }

    public void performFindFirst() {
        boolean bl = false;
        Component component = this.getSelectedView();
        if (component == this.cctPanel) {
            if (!this.cctPanel.isFindStringDefined()) {
                String string = FindDialog.getFindString();
                if (string == null) {
                    return;
                }
                this.setFindString(string);
            }
            bl = this.cctPanel.findFirst();
        } else if (component == this.flatPanel) {
            if (!this.flatPanel.isFindStringDefined()) {
                String string = FindDialog.getFindString();
                if (string == null) {
                    return;
                }
                this.setFindString(string);
            }
            bl = this.flatPanel.findFirst();
        } else if (component == this.subtreeView) {
            if (!this.subtreeView.isFindStringDefined()) {
                String string = FindDialog.getFindString();
                if (string == null) {
                    return;
                }
                this.setFindString(string);
            }
            bl = this.subtreeView.findFirst();
        }
        if (!bl) {
            ProfilerDialogs.displayInfo((String)Bundle.CPUSnapshotPanel_StringNotFoundMsg());
        }
    }

    @Override
    public void performFindNext() {
        boolean bl = false;
        Component component = this.getSelectedView();
        if (component == this.cctPanel) {
            if (!this.cctPanel.isFindStringDefined()) {
                String string = FindDialog.getFindString();
                if (string == null) {
                    return;
                }
                this.setFindString(string);
            }
            bl = this.cctPanel.findNext();
        } else if (component == this.flatPanel) {
            if (!this.flatPanel.isFindStringDefined()) {
                String string = FindDialog.getFindString();
                if (string == null) {
                    return;
                }
                this.setFindString(string);
            }
            bl = this.flatPanel.findNext();
        } else if (component == this.subtreeView) {
            if (!this.subtreeView.isFindStringDefined()) {
                String string = FindDialog.getFindString();
                if (string == null) {
                    return;
                }
                this.setFindString(string);
            }
            bl = this.subtreeView.findNext();
        }
        if (!bl) {
            ProfilerDialogs.displayInfo((String)Bundle.CPUSnapshotPanel_StringNotFoundMsg());
        }
    }

    @Override
    public void performFindPrevious() {
        boolean bl = false;
        Component component = this.getSelectedView();
        if (component == this.cctPanel) {
            if (!this.cctPanel.isFindStringDefined()) {
                String string = FindDialog.getFindString();
                if (string == null) {
                    return;
                }
                this.setFindString(string);
            }
            bl = this.cctPanel.findPrevious();
        } else if (component == this.flatPanel) {
            if (!this.flatPanel.isFindStringDefined()) {
                String string = FindDialog.getFindString();
                if (string == null) {
                    return;
                }
                this.setFindString(string);
            }
            bl = this.flatPanel.findPrevious();
        } else if (component == this.subtreeView) {
            if (!this.subtreeView.isFindStringDefined()) {
                String string = FindDialog.getFindString();
                if (string == null) {
                    return;
                }
                this.setFindString(string);
            }
            bl = this.subtreeView.findPrevious();
        }
        if (!bl) {
            ProfilerDialogs.displayInfo((String)Bundle.CPUSnapshotPanel_StringNotFoundMsg());
        }
    }

    public void requestFocus() {
        if (this.cctPanel != null) {
            this.cctPanel.requestFocus();
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.updateToolbar();
        Component component = this.getSelectedView();
        if (component != null) {
            component.requestFocus();
        }
    }

    @Override
    public void updateSavedState() {
    }

    private String getDefaultSnapshotFileName(ResultsSnapshot resultsSnapshot) {
        return "snapshot-" + resultsSnapshot.getTimeTaken();
    }

    private void setFindString(String string) {
        this.cctPanel.setFindString(string);
        this.flatPanel.setFindString(string);
        if (this.subtreeView != null) {
            this.subtreeView.setFindString(string);
        }
    }

    private void updateToolbar() {
        Component component = this.getSelectedView();
        this.aggregationCombo.setEnabled(component != this.subtreeView);
    }

    private void viewChanged(int n) {
        this.viewTypeHasChanged();
        this.internalChange = true;
        switch (n) {
            case 2: {
                this.aggregationCombo.setSelectedItem(Bundle.CPUSnapshotPanel_PackagesString());
                break;
            }
            case 1: {
                this.aggregationCombo.setSelectedItem(Bundle.CPUSnapshotPanel_ClassesString());
                break;
            }
            default: {
                this.aggregationCombo.setSelectedItem(Bundle.CPUSnapshotPanel_MethodsString());
            }
        }
        this.internalChange = false;
    }

    private void viewTypeHasChanged() {
        this.cctPanel.prepareResults();
        this.flatPanel.prepareResults();
        this.revalidate();
        this.repaint();
    }

    @Override
    public void exportData(int n, ExportDataDumper exportDataDumper) {
        Component component = this.getSelectedView();
        if (component instanceof CCTDisplay) {
            this.cctPanel.exportData(n, exportDataDumper, false, Bundle.CPUSnapshotPanel_CallTreeString());
        } else if (component instanceof SnapshotFlatProfilePanel) {
            this.flatPanel.exportData(n, exportDataDumper, false, Bundle.CPUSnapshotPanel_HotSpotsString());
        } else if (component instanceof SubtreeCallGraphPanel) {
            this.subtreeView.exportData(n, exportDataDumper, this.subtreeView.getShortTitle());
        }
    }

    @Override
    public boolean hasLoadedSnapshot() {
        return false;
    }

    @Override
    public boolean hasExportableView() {
        Component component = this.getSelectedView();
        return component != null;
    }

    private final class CPUActionsHandler
    extends CPUResUserActionsHandler.Adapter {
        private CPUActionsHandler() {
        }

        public void addMethodToRoots(final String string, final String string2, final String string3) {
            ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

                @Override
                public void run() {
                    final Lookup.Provider provider = CPUDiffPanel.this.loadedSnapshot.getProject();
                    final ProfilingSettings[] profilingSettingsArray = ProfilingSettingsManager.getProfilingSettings((Lookup.Provider)provider).getProfilingSettings();
                    final ArrayList<ProfilingSettings> arrayList = new ArrayList<ProfilingSettings>();
                    for (ProfilingSettings profilingSettings : profilingSettingsArray) {
                        if (!ProfilingSettings.isCPUSettings((int)profilingSettings.getProfilingType())) continue;
                        arrayList.add(profilingSettings);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            final ProfilingSettings profilingSettings = IDEUtils.selectSettings(16, arrayList.toArray(new ProfilingSettings[arrayList.size()]), null);
                            if (profilingSettings == null) {
                                return;
                            }
                            ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    profilingSettings.addRootMethod(string, string2, string3);
                                    if (arrayList.contains(profilingSettings)) {
                                        ProfilingSettingsManager.storeProfilingSettings((ProfilingSettings[])profilingSettingsArray, (ProfilingSettings)profilingSettings, (Lookup.Provider)provider);
                                    } else {
                                        ProfilingSettings[] profilingSettingsArray = new ProfilingSettings[profilingSettingsArray.length + 1];
                                        System.arraycopy(profilingSettingsArray, 0, profilingSettingsArray, 0, profilingSettingsArray.length);
                                        profilingSettingsArray[profilingSettingsArray.length] = profilingSettings;
                                        ProfilingSettingsManager.storeProfilingSettings((ProfilingSettings[])profilingSettingsArray, (ProfilingSettings)profilingSettings, (Lookup.Provider)provider);
                                    }
                                }
                            });
                        }
                    });
                }
            });
        }

        public void find(Object object, String string) {
            if (object == CPUDiffPanel.this.cctPanel) {
                CPUDiffPanel.this.setFindString(string);
                CPUDiffPanel.this.selectView((Component)CPUDiffPanel.this.flatPanel);
                CPUDiffPanel.this.flatPanel.selectMethod(string);
            } else if (object == CPUDiffPanel.this.flatPanel) {
                CPUDiffPanel.this.setFindString(string);
                CPUDiffPanel.this.selectView((Component)CPUDiffPanel.this.cctPanel);
                CPUDiffPanel.this.performFindFirst();
            }
        }

        public void showReverseCallGraph(CPUResultsSnapshot cPUResultsSnapshot, int n, int n2, int n3, int n4, boolean bl) {
        }

        public void showSourceForMethod(String string, String string2, String string3) {
            GoToSource.openSource((Lookup.Provider)CPUDiffPanel.this.loadedSnapshot.getProject(), (String)string, (String)string2, (String)string3);
        }

        public void showSubtreeCallGraph(CPUResultsSnapshot cPUResultsSnapshot, CCTNode cCTNode, int n, int n2, boolean bl) {
            if (!(cCTNode instanceof PrestimeCPUCCTNode)) {
                return;
            }
            if (CPUDiffPanel.this.subtreeView != null) {
                CPUDiffPanel.this.removeView((Component)CPUDiffPanel.this.subtreeView);
            }
            CPUDiffPanel.this.subtreeView = new SubtreeCallGraphPanel((CPUResUserActionsHandler)this, CPUDiffPanel.this.sampling);
            CPUDiffPanel.this.subtreeView.setDataToDisplay(cPUResultsSnapshot, (PrestimeCPUCCTNode)cCTNode, n);
            CPUDiffPanel.this.subtreeView.setSorting(n2, bl);
            CPUDiffPanel.this.subtreeView.prepareResults();
            CPUDiffPanel.this.subtreeView.setFindString(CPUDiffPanel.this.cctPanel.getFindString());
            CPUDiffPanel.this.addView(CPUDiffPanel.this.subtreeView.getShortTitle(), SUBTREE_TAB_ICON, CPUDiffPanel.this.subtreeView.getTitle(), (Component)CPUDiffPanel.this.subtreeView, null);
            CPUDiffPanel.this.selectView((Component)CPUDiffPanel.this.subtreeView);
        }
    }
}

