/*
 * Decompiled with CFR 0.152.
 */
package gps.convert;

import bt747.sys.Generic;
import gps.convert.Geoid;
import gps.convert.GeoidIF;

public class ExternalUtils {
    private static GeoidIF geoid = Geoid.getInstance();

    public static final double bilinear(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        if (d2 == d4 && d == d3) {
            return d7;
        }
        if (d2 == d4 && d != d3) {
            return (d10 * (d5 - d) + d7 * (d3 - d5)) / (d3 - d);
        }
        if (d == d3 && d2 != d4) {
            return (d10 * (d6 - d2) + d7 * (d4 - d6)) / (d4 - d2);
        }
        double d11 = (d4 - d2) * (d3 - d);
        return (d10 * (d6 - d2) * (d5 - d) + d8 * (d4 - d6) * (d5 - d) + d9 * (d6 - d2) * (d3 - d5) + d7 * (d4 - d6) * (d3 - d5)) / d11;
    }

    public static final double wgs84Separation(double d, double d2) {
        return geoid.wgs84Separation(d, d2);
    }

    public static final void setGeoidIF(GeoidIF geoidIF) {
        geoid = geoidIF;
    }

    public static final double earthDistance(double d, double d2, double d3, double d4) {
        double d5;
        double d6 = ExternalUtils.calcR(d) * Math.cos(ExternalUtils.rad2deg(d2)) * Math.sin(ExternalUtils.rad2deg(90.0 - d));
        double d7 = ExternalUtils.calcR(d3) * Math.cos(ExternalUtils.rad2deg(d4)) * Math.sin(ExternalUtils.rad2deg(90.0 - d3));
        double d8 = ExternalUtils.calcR(d) * Math.sin(ExternalUtils.rad2deg(d2)) * Math.sin(ExternalUtils.rad2deg(90.0 - d));
        double d9 = ExternalUtils.calcR(d3) * Math.sin(ExternalUtils.rad2deg(d4)) * Math.sin(ExternalUtils.rad2deg(90.0 - d3));
        double d10 = ExternalUtils.calcR(d) * Math.cos(ExternalUtils.rad2deg(90.0 - d));
        double d11 = ExternalUtils.calcR(d3) * Math.cos(ExternalUtils.rad2deg(90.0 - d3));
        double d12 = ExternalUtils.calcR((d + d3) / 2.0);
        double d13 = d12 * d12;
        double d14 = (d6 * d7 + d8 * d9 + d10 * d11) / d13;
        if (d5 > 1.0) {
            d14 = 1.0;
        } else if (d14 < -1.0) {
            d14 = -1.0;
        }
        double d15 = Generic.acos(d14);
        return ExternalUtils.calcR((d + d3) / 2.0) * d15;
    }

    private static double calcR(double d) {
        double d2 = Math.sin(d * Math.PI / 180.0);
        double d3 = Generic.pow(1.0 - d2 * 0.006574290724000001 * d2, 1.5);
        return 6336205.273084499 / d3;
    }

    private static double rad2deg(double d) {
        return d * Math.PI / 180.0;
    }

    public static final int getDayOfWeek(int n, int n2, int n3) {
        int n4 = (n3 - 1582) * 365;
        int n5 = (n3 - 1581) / 4;
        int n6 = (n3 - 1501) / 100;
        int n7 = (n3 - 1201) / 400;
        int n8 = (n2 - 1) * 31;
        int n9 = (n2 + 7) / 10;
        int n10 = 1 / (n3 % 4 + 1) * n9;
        int n11 = 1 / (n3 % 100 + 1) * n9;
        if ((n = (n4 + n5 - n6 + n7 + n8 + n - (n2 = ((n2 << 2) + 23) * n9 / 10) + n10 - n11 + (n3 = 1 / (n3 % 400 + 1) * n9) + 5) % 7) > 0) {
            return n - 1;
        }
        return 6;
    }
}

