/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.resync;

import java.io.IOException;
import java.util.Arrays;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.replication.ReplicatedWriteRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;

public final class ResyncReplicationRequest
extends ReplicatedWriteRequest<ResyncReplicationRequest> {
    private Translog.Operation[] operations;

    ResyncReplicationRequest() {
    }

    public ResyncReplicationRequest(ShardId shardId, Translog.Operation[] operations) {
        super(shardId);
        this.operations = operations;
    }

    public Translog.Operation[] getOperations() {
        return this.operations;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        if (in.getVersion().equals(Version.V_6_0_0)) {
            throw new IllegalStateException("resync replication request serialization is broken in 6.0.0");
        }
        super.readFrom(in);
        this.operations = in.readArray(Translog.Operation::readOperation, Translog.Operation[]::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeArray(Translog.Operation::writeOperation, this.operations);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResyncReplicationRequest that = (ResyncReplicationRequest)o;
        return Arrays.equals(this.operations, that.operations);
    }

    public int hashCode() {
        return Arrays.hashCode(this.operations);
    }

    @Override
    public String toString() {
        return "TransportResyncReplicationAction.Request{shardId=" + this.shardId + ", timeout=" + this.timeout + ", index='" + this.index + '\'' + ", ops=" + this.operations.length + "}";
    }
}

