/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.ToXContentToBytes;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class TranslogStats
extends ToXContentToBytes
implements Streamable {
    private long translogSizeInBytes;
    private int numberOfOperations;
    private long uncommittedSizeInBytes;
    private int uncommittedOperations;

    public TranslogStats() {
    }

    public TranslogStats(int numberOfOperations, long translogSizeInBytes, int uncommittedOperations, long uncommittedSizeInBytes) {
        if (numberOfOperations < 0) {
            throw new IllegalArgumentException("numberOfOperations must be >= 0");
        }
        if (translogSizeInBytes < 0L) {
            throw new IllegalArgumentException("translogSizeInBytes must be >= 0");
        }
        if (uncommittedOperations < 0) {
            throw new IllegalArgumentException("uncommittedOperations must be >= 0");
        }
        if (uncommittedSizeInBytes < 0L) {
            throw new IllegalArgumentException("uncommittedSizeInBytes must be >= 0");
        }
        this.numberOfOperations = numberOfOperations;
        this.translogSizeInBytes = translogSizeInBytes;
        this.uncommittedSizeInBytes = uncommittedSizeInBytes;
        this.uncommittedOperations = uncommittedOperations;
    }

    public void add(TranslogStats translogStats) {
        if (translogStats == null) {
            return;
        }
        this.numberOfOperations += translogStats.numberOfOperations;
        this.translogSizeInBytes += translogStats.translogSizeInBytes;
        this.uncommittedOperations += translogStats.uncommittedOperations;
        this.uncommittedSizeInBytes += translogStats.uncommittedSizeInBytes;
    }

    public long getTranslogSizeInBytes() {
        return this.translogSizeInBytes;
    }

    public int estimatedNumberOfOperations() {
        return this.numberOfOperations;
    }

    public long getUncommittedSizeInBytes() {
        return this.uncommittedSizeInBytes;
    }

    public int getUncommittedOperations() {
        return this.uncommittedOperations;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("translog");
        builder.field("operations", this.numberOfOperations);
        builder.byteSizeField("size_in_bytes", "size", this.translogSizeInBytes);
        builder.field("uncommitted_operations", this.uncommittedOperations);
        builder.byteSizeField("uncommitted_size_in_bytes", "uncommitted_size", this.uncommittedSizeInBytes);
        builder.endObject();
        return builder;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.numberOfOperations = in.readVInt();
        this.translogSizeInBytes = in.readVLong();
        if (in.getVersion().onOrAfter(Version.V_6_0_0_beta1)) {
            this.uncommittedOperations = in.readVInt();
            this.uncommittedSizeInBytes = in.readVLong();
        } else {
            this.uncommittedOperations = this.numberOfOperations;
            this.uncommittedSizeInBytes = this.translogSizeInBytes;
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.numberOfOperations);
        out.writeVLong(this.translogSizeInBytes);
        if (out.getVersion().onOrAfter(Version.V_6_0_0_beta1)) {
            out.writeVInt(this.uncommittedOperations);
            out.writeVLong(this.uncommittedSizeInBytes);
        }
    }
}

