/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.classloading;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.gradle.api.GradleException;
import org.gradle.api.internal.classloading.GroovySystemLoader;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeakyOnJava7GroovySystemLoader
implements GroovySystemLoader {
    private static final Logger LOG = Logging.getLogger(LeakyOnJava7GroovySystemLoader.class);
    private final Method removeFromGlobalClassValue;
    private final Method globalClassSetIteratorMethod;
    private final Object globalClassValue;
    private final Object globalClassSetItems;
    private final Field clazzField;
    private final ClassLoader leakingLoader;

    public LeakyOnJava7GroovySystemLoader(ClassLoader leakingLoader) throws Exception {
        this.leakingLoader = leakingLoader;
        Class<?> classInfoClass = leakingLoader.loadClass("org.codehaus.groovy.reflection.ClassInfo");
        Field globalClassValueField = classInfoClass.getDeclaredField("globalClassValue");
        globalClassValueField.setAccessible(true);
        this.globalClassValue = globalClassValueField.get(null);
        this.removeFromGlobalClassValue = globalClassValueField.getType().getDeclaredMethod("remove", Class.class);
        this.removeFromGlobalClassValue.setAccessible(true);
        Field globalClassSetField = classInfoClass.getDeclaredField("globalClassSet");
        globalClassSetField.setAccessible(true);
        Object globalClassSet = globalClassSetField.get(null);
        globalClassSetField = globalClassSet.getClass().getDeclaredField("items");
        globalClassSetField.setAccessible(true);
        this.globalClassSetItems = globalClassSetField.get(globalClassSet);
        this.globalClassSetIteratorMethod = this.globalClassSetItems.getClass().getDeclaredMethod("iterator", new Class[0]);
        this.clazzField = classInfoClass.getDeclaredField("klazz");
        this.clazzField.setAccessible(true);
    }

    @Override
    public void shutdown() {
        if (this.leakingLoader == this.getClass().getClassLoader()) {
            throw new IllegalStateException("Cannot shut down the main Groovy loader.");
        }
        try {
            Iterator<?> it = this.globalClassSetIterator();
            while (it.hasNext()) {
                Object classInfo = it.next();
                if (classInfo == null) continue;
                Class clazz = (Class)this.clazzField.get(classInfo);
                this.removeFromGlobalClassValue.invoke(this.globalClassValue, clazz);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Removed ClassInfo from {} loaded by {}", (Object)clazz.getName(), (Object)clazz.getClassLoader());
            }
        }
        catch (Exception e) {
            throw new GradleException("Could not shut down the Groovy system for " + this.leakingLoader, (Throwable)e);
        }
    }

    @Override
    public void discardTypesFrom(ClassLoader classLoader) {
        if (classLoader == this.leakingLoader) {
            throw new IllegalStateException("Cannot remove own types from Groovy loader.");
        }
        try {
            Iterator<?> it = this.globalClassSetIterator();
            while (it.hasNext()) {
                Class clazz;
                Object classInfo = it.next();
                if (classInfo == null || (clazz = (Class)this.clazzField.get(classInfo)).getClassLoader() != classLoader) continue;
                this.removeFromGlobalClassValue.invoke(this.globalClassValue, clazz);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Removed ClassInfo from {} loaded by {}", (Object)clazz.getName(), (Object)clazz.getClassLoader());
            }
        }
        catch (Exception e) {
            throw new GradleException("Could not remove types for ClassLoader " + classLoader + " from the Groovy system " + this.leakingLoader, (Throwable)e);
        }
    }

    private Iterator<?> globalClassSetIterator() throws IllegalAccessException, InvocationTargetException {
        return (Iterator)this.globalClassSetIteratorMethod.invoke(this.globalClassSetItems, new Object[0]);
    }
}

