/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.local.internal;

import java.io.File;
import java.io.IOException;
import org.gradle.api.Action;
import org.gradle.api.UncheckedIOException;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.local.internal.BuildCacheTempFileStore;
import org.gradle.util.GFileUtils;

public class DefaultBuildCacheTempFileStore
implements BuildCacheTempFileStore {
    private final File dir;
    private final String partialFileSuffix;

    public DefaultBuildCacheTempFileStore(File dir, String partialFileSuffix) {
        this.dir = dir;
        this.partialFileSuffix = partialFileSuffix;
        GFileUtils.mkdirs((File)this.dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void allocateTempFile(BuildCacheKey key, Action<? super File> action) {
        File tempFile;
        String hashCode = key.getHashCode();
        try {
            tempFile = File.createTempFile(hashCode, this.partialFileSuffix, this.dir);
        }
        catch (IOException ex) {
            throw new UncheckedIOException((Throwable)ex);
        }
        try {
            action.execute((Object)tempFile);
        }
        finally {
            if (tempFile.exists()) {
                GFileUtils.deleteQuietly((File)tempFile);
            }
        }
    }
}

