/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.internal;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.component.ChildComponent;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.component.SoftwareComponentInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.internal.PublicationInternal;
import org.gradle.internal.text.TreeFormatter;

public class ProjectDependencyPublicationResolver {
    public ModuleVersionIdentifier resolve(ProjectDependency dependency) {
        Project dependencyProject = dependency.getDependencyProject();
        ((ProjectInternal)dependencyProject).evaluate();
        PublishingExtension publishing = (PublishingExtension)dependencyProject.getExtensions().findByType(PublishingExtension.class);
        if (publishing == null || publishing.getPublications().withType(PublicationInternal.class).isEmpty()) {
            return new DefaultModuleVersionIdentifier(dependency.getGroup(), dependencyProject.getName(), dependency.getVersion());
        }
        NamedDomainObjectSet publications = publishing.getPublications().withType(PublicationInternal.class);
        HashSet<SoftwareComponentInternal> components = new HashSet<SoftwareComponentInternal>(publications.size());
        for (PublicationInternal publication : publications) {
            if (publication.getComponent() == null) continue;
            components.add(publication.getComponent());
        }
        LinkedHashSet<PublicationInternal> topLevel = new LinkedHashSet<PublicationInternal>();
        for (PublicationInternal publication : publications) {
            if (publication.getComponent() == null || !(publication.getComponent() instanceof ChildComponent)) {
                topLevel.add(publication);
                continue;
            }
            ChildComponent childComponent = (ChildComponent)publication.getComponent();
            if (components.contains(childComponent.getOwner())) continue;
            topLevel.add(publication);
        }
        Iterator iterator = topLevel.iterator();
        ModuleVersionIdentifier candidate = ((PublicationInternal)iterator.next()).getCoordinates();
        while (iterator.hasNext()) {
            ModuleVersionIdentifier alternative = ((PublicationInternal)iterator.next()).getCoordinates();
            if (candidate.equals(alternative)) continue;
            TreeFormatter formatter = new TreeFormatter();
            formatter.node("Publishing is not yet able to resolve a dependency on a project with multiple publications that have different coordinates.");
            formatter.node("Found the following publications in " + dependencyProject.getDisplayName());
            formatter.startChildren();
            for (PublicationInternal publication : publications) {
                formatter.node("Publication '" + publication.getName() + "' with coordinates " + publication.getCoordinates());
            }
            formatter.endChildren();
            throw new UnsupportedOperationException(formatter.toString());
        }
        return candidate;
    }
}

