/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.resolver;

import java.io.File;
import java.net.URI;
import javax.annotation.Nullable;
import org.gradle.api.internal.artifacts.repositories.resolver.ExternalResourceAccessor;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.ResourceExceptions;
import org.gradle.internal.resource.local.FileStore;
import org.gradle.internal.resource.local.LocallyAvailableExternalResource;
import org.gradle.internal.resource.local.LocallyAvailableResource;
import org.gradle.internal.resource.transfer.CacheAwareExternalResourceAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExternalResourceAccessor
implements ExternalResourceAccessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExternalResourceAccessor.class);
    private final FileStore<String> fileStore;
    private final CacheAwareExternalResourceAccessor resourceAccessor;

    public DefaultExternalResourceAccessor(FileStore<String> fileStore, CacheAwareExternalResourceAccessor resourceAccessor) {
        this.fileStore = fileStore;
        this.resourceAccessor = resourceAccessor;
    }

    @Override
    @Nullable
    public LocallyAvailableExternalResource resolveUri(URI uri) {
        return this.resolve(new ExternalResourceName(uri), uri);
    }

    @Override
    @Nullable
    public LocallyAvailableExternalResource resolveResource(ExternalResourceName resource) {
        return this.resolve(resource, resource.getUri());
    }

    private LocallyAvailableExternalResource resolve(final ExternalResourceName resource, URI uri) {
        LOGGER.debug("Loading {}", (Object)resource);
        try {
            return this.resourceAccessor.getResource(resource, new CacheAwareExternalResourceAccessor.ResourceFileStore(){

                @Override
                public LocallyAvailableResource moveIntoCache(File downloadedResource) {
                    String key = Hashing.sha1().hashString((CharSequence)resource.toString()).toString();
                    return DefaultExternalResourceAccessor.this.fileStore.move((Object)key, downloadedResource);
                }
            }, null);
        }
        catch (Exception e) {
            throw ResourceExceptions.getFailed((URI)uri, (Throwable)e);
        }
    }
}

