/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit.report;

import org.gradle.api.tasks.testing.TestResult;
import org.gradle.internal.time.TimeFormatting;

public abstract class TestResultModel {
    public abstract TestResult.ResultType getResultType();

    public abstract long getDuration();

    public abstract String getTitle();

    public String getFormattedDuration() {
        return TimeFormatting.formatDurationVeryTerse((long)this.getDuration());
    }

    public String getStatusClass() {
        switch (this.getResultType()) {
            case SUCCESS: {
                return "success";
            }
            case FAILURE: {
                return "failures";
            }
            case SKIPPED: {
                return "skipped";
            }
        }
        throw new IllegalStateException();
    }

    public String getFormattedResultType() {
        switch (this.getResultType()) {
            case SUCCESS: {
                return "passed";
            }
            case FAILURE: {
                return "failed";
            }
            case SKIPPED: {
                return "ignored";
            }
        }
        throw new IllegalStateException();
    }
}

