/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.gamma;

import java.util.LinkedList;
import java.util.List;
import org.multiverse.api.BackoffPolicy;
import org.multiverse.api.DefaultBackoffPolicy;
import org.multiverse.api.IsolationLevel;
import org.multiverse.api.LockMode;
import org.multiverse.api.PropagationLevel;
import org.multiverse.api.TraceLevel;
import org.multiverse.api.lifecycle.TxnListener;

public final class GammaStmConfig {
    public List<TxnListener> permanentListeners = new LinkedList<TxnListener>();
    public PropagationLevel propagationLevel = PropagationLevel.Requires;
    public IsolationLevel isolationLevel = IsolationLevel.Snapshot;
    public LockMode readLockMode = LockMode.None;
    public LockMode writeLockMode = LockMode.None;
    public boolean blockingAllowed = true;
    public boolean interruptible = false;
    public long timeoutNs = Long.MAX_VALUE;
    public boolean readonly = false;
    public int spinCount = 64;
    public boolean dirtyCheck = true;
    public int minimalVariableLengthTransactionSize = 4;
    public boolean trackReads = true;
    public int maxRetries = 1000;
    public boolean speculativeConfigEnabled = true;
    public int maxFixedLengthTransactionSize = 20;
    public BackoffPolicy backoffPolicy = DefaultBackoffPolicy.MAX_100_MS;
    public TraceLevel traceLevel = TraceLevel.None;
    public boolean controlFlowErrorsReused = true;
    public boolean isFat = false;
    public int maximumPoorMansConflictScanLength = 20;
    public int readBiasedThreshold = 128;

    public void validate() {
        if (this.timeoutNs < 0L) {
            throw new IllegalStateException("[GammaStmConfig] timeoutNs can't be smaller than 0, timeoutNs was " + this.timeoutNs);
        }
        if (this.readBiasedThreshold < 0) {
            throw new IllegalStateException("[GammaStmConfig] readBiasedThreshold can't be smaller than 0, readBiasedThreshold was " + this.readBiasedThreshold);
        }
        if (this.readBiasedThreshold > 1023) {
            throw new IllegalStateException("[GammaStmConfig] readBiasedThreshold can't be larger than 1023, readBiasedThreshold was " + this.readBiasedThreshold);
        }
        if (this.maximumPoorMansConflictScanLength < 0) {
            throw new IllegalStateException("[GammaStmConfig] maximumFullConflictScanSize can't be smaller than 0, maximumFullConflictScanSize was " + this.maxFixedLengthTransactionSize);
        }
        if (this.readLockMode == null) {
            throw new IllegalStateException("[GammaStmConfig] readLockMode can't be null");
        }
        if (this.writeLockMode == null) {
            throw new IllegalStateException("[GammaStmConfig] writeLockMode can't be null");
        }
        if (this.writeLockMode.asInt() < this.readLockMode.asInt()) {
            throw new IllegalStateException(String.format("[GammaStmConfig] writeLockMode [%s] can't be lower than readLockMode [%s]", this.writeLockMode, this.readLockMode));
        }
        if (this.isolationLevel == null) {
            throw new IllegalStateException("[GammaStmConfig] isolationLevel can't be null");
        }
        if (this.isolationLevel.doesAllowWriteSkew() && !this.trackReads) {
            throw new IllegalStateException(String.format("[GammaStmConfig] isolation level '%s' can't be combined with readtrackingis false since it is needed to prevent the writeskew problem", new Object[]{this.isolationLevel}));
        }
        if (this.blockingAllowed && !this.trackReads) {
            throw new IllegalStateException("[GammaStmConfig] blockingAllowed can't be true if trackReads is false");
        }
        if (this.spinCount < 0) {
            throw new IllegalStateException("[GammaStmConfig] spinCount can't be smaller than 0, but was " + this.spinCount);
        }
        if (this.minimalVariableLengthTransactionSize < 1) {
            throw new IllegalStateException("[GammaStmConfig] minimalVariableLengthTransactionSize can't be smaller than 1, but was " + this.minimalVariableLengthTransactionSize);
        }
        if (this.maxRetries < 0) {
            throw new IllegalStateException("[GammaStmConfig] maxRetries can't be smaller than 0, but was " + this.maxRetries);
        }
        if (this.maxFixedLengthTransactionSize < 2) {
            throw new IllegalStateException("[GammaStmConfig] maxFixedLengthTransactionSize can't be smaller than 2, but was " + this.maxFixedLengthTransactionSize);
        }
        if (this.backoffPolicy == null) {
            throw new IllegalStateException("[GammaStmConfig] backoffPolicy can't be null");
        }
        if (this.traceLevel == null) {
            throw new IllegalStateException("[GammaStmConfig] traceLevel can't be null");
        }
        if (this.propagationLevel == null) {
            throw new IllegalStateException("[GammaStmConfig] propagationLevel can't be null");
        }
        if (this.permanentListeners == null) {
            throw new IllegalStateException("[GammaStmConfig] permanentListeners can't be null");
        }
        for (int k = 0; k < this.permanentListeners.size(); ++k) {
            TxnListener listener = this.permanentListeners.get(k);
            if (listener != null) continue;
            throw new IllegalStateException(String.format("[GammaStmConfig] permanentListener at index %s can't be null", k));
        }
    }
}

