#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: cassava
version: 0.5.1.0
id: cassava-0.5.1.0-JJ8yHSgDAFr8h4bsmPdKSU
key: cassava-0.5.1.0-JJ8yHSgDAFr8h4bsmPdKSU
license: BSD3
copyright: (c) 2012 Johan Tibell
           (c) 2012 Bryan O'\''Sullivan
           (c) 2011 MailRank, Inc.
maintainer: hvr@gnu.org
homepage: https://github.com/hvr/cassava
synopsis: A CSV parsing and encoding library
description:
    @cassava@ is a library for parsing and encoding [RFC 4180](https://tools.ietf.org/html/rfc4180)
    compliant [comma-separated values (CSV)](https://en.wikipedia.org/wiki/Comma-separated_values) data,
    which is a textual line-oriented format commonly used for exchanging tabular data.
    .
    @cassava@'\''s API includes support for
    .
    - Index-based record-conversion
    - Name-based record-conversion
    - Typeclass directed conversion of fields and records
    - Built-in field-conversion instances for standard types
    - Customizable record-conversion instance derivation via GHC generics
    - Low-level [bytestring](https://hackage.haskell.org/package/bytestring) builders (see "Data.Csv.Builder")
    - Incremental decoding and encoding API (see "Data.Csv.Incremental")
    - Streaming API for constant-space decoding (see "Data.Csv.Streaming")
    .
    Moreover, this library is designed to be easy to use; for instance, here'\''s a
    very simple example of encoding CSV data:
    .
    >>> Data.Csv.encode [("John",27),("Jane",28)]
    "John,27\r\nJane,28\r\n"
    .
    Please refer to the documentation in "Data.Csv" and the included [README](#readme) for more usage examples.
category: Text, Web, CSV
author: Johan Tibell
exposed: True
indefinite: False
exposed-modules:
    Data.Csv Data.Csv.Builder Data.Csv.Incremental Data.Csv.Parser
    Data.Csv.Streaming
hidden-modules: Data.Csv.Conversion Data.Csv.Conversion.Internal
                Data.Csv.Encoding Data.Csv.Types Data.Csv.Util
abi: 2d0baade731b6a40462d4814a7a9b54a
trusted: False
import-dirs: /usr/lib/ghc-8.2.2/site-local/cassava-0.5.1.0
library-dirs: /usr/lib/ghc-8.2.2/site-local/cassava-0.5.1.0
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.2/cassava-0.5.1.0
hs-libraries: HScassava-0.5.1.0-JJ8yHSgDAFr8h4bsmPdKSU
depends:
    array-0.5.2.0 attoparsec-0.13.2.0-1AORA640dG8HmlrlyiwzkH
    base-4.10.1.0 bytestring-0.10.8.2 containers-0.5.10.2
    deepseq-1.4.3.0 hashable-1.2.6.1-9ZXmUmZR8Ja1wkFjzrwxTy
    scientific-0.3.5.2-Lc8fLx9ZwucCofr91mB0B5
    text-1.2.2.2-E3rQA0mJl73IvZIzvmwqAj
    unordered-containers-0.2.8.0-I4wGGMV7X9X97sk1hrOqCV
    vector-0.12.0.1-IUGn3M9mkBh8CyXcBnfTR4
    Only-0.1-K3HSyq2koL8JtFXn0ZkrT6
    text-short-0.1.1-3Uwa5h6yaLO2eRReBlFhSC
abi-depends: array-0.5.2.0=567646df31883e5d21d17233cc6e3caf
             attoparsec-0.13.2.0-1AORA640dG8HmlrlyiwzkH=166a433e56e808d42a86e30017dad920
             base-4.10.1.0=0ea45191c57c268b2351cb731ab6a0d6
             bytestring-0.10.8.2=4b2726b654ceeff6535e698a2a1e724e
             containers-0.5.10.2=0f9db0d1b935cacba444aac19f4cb54d
             deepseq-1.4.3.0=e843b5d736cc095915bf2399fddf152e
             hashable-1.2.6.1-9ZXmUmZR8Ja1wkFjzrwxTy=6e4b4a70e10d525b7db51e3859aab169
             scientific-0.3.5.2-Lc8fLx9ZwucCofr91mB0B5=7c20e5f5e59fd4e457b5ba5744572d2c
             text-1.2.2.2-E3rQA0mJl73IvZIzvmwqAj=19cd54ed0f93cc2e72d3ff0c754f5306
             unordered-containers-0.2.8.0-I4wGGMV7X9X97sk1hrOqCV=db9131d5548eea6d7a3eab9f0d172004
             vector-0.12.0.1-IUGn3M9mkBh8CyXcBnfTR4=d8375a46a4155c3f449ce3d319b3dbaa
             Only-0.1-K3HSyq2koL8JtFXn0ZkrT6=21cb887b2dde313bd9095bf1e74d7359
             text-short-0.1.1-3Uwa5h6yaLO2eRReBlFhSC=ca536c1cb0849144e5c582455db9efdc
haddock-interfaces: /usr/share/doc/haskell-cassava/html/cassava.haddock
haddock-html: /usr/share/doc/haskell-cassava/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

