#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: vty
version: 5.18.1
id: vty-5.18.1-1ArmFyNsA4q47eJ7kNxO
key: vty-5.18.1-1ArmFyNsA4q47eJ7kNxO
license: BSD3
maintainer: Jonathan Daugherty (cygnus@foobox.com)
homepage: https://github.com/jtdaugherty/vty
synopsis: A simple terminal UI library
description:
    vty is terminal GUI library in the niche of ncurses. It is intended to
    be easy to use, have no confusing corner cases, and good support for
    common terminal types.
    .
    See the @vty-examples@ package as well as the program
    @test/interactive_terminal_test.hs@ included in the @vty@ package for
    examples on how to use the library.
    .
    Import the "Graphics.Vty" convenience module to get access to the core
    parts of the library.
    .
    &#169; 2006-2007 Stefan O'\''Rear; BSD3 license.
    .
    &#169; Corey O'\''Connor; BSD3 license.
    .
    &#169; Jonathan Daugherty; BSD3 license.
category: User Interfaces
author: AUTHORS
exposed: True
indefinite: False
exposed-modules:
    Codec.Binary.UTF8.Debug Data.Terminfo.Eval Data.Terminfo.Parse
    Graphics.Text.Width Graphics.Vty Graphics.Vty.Attributes
    Graphics.Vty.Config Graphics.Vty.Debug
    Graphics.Vty.DisplayAttributes Graphics.Vty.Error
    Graphics.Vty.Image Graphics.Vty.Image.Internal Graphics.Vty.Inline
    Graphics.Vty.Inline.Unsafe Graphics.Vty.Input
    Graphics.Vty.Input.Classify Graphics.Vty.Input.Classify.Parse
    Graphics.Vty.Input.Classify.Types Graphics.Vty.Input.Events
    Graphics.Vty.Input.Focus Graphics.Vty.Input.Loop
    Graphics.Vty.Input.Mouse Graphics.Vty.Input.Paste
    Graphics.Vty.Input.Terminfo Graphics.Vty.Output
    Graphics.Vty.Output.Interface Graphics.Vty.Output.Mock
    Graphics.Vty.Output.TerminfoBased Graphics.Vty.Output.XTermColor
    Graphics.Vty.Picture Graphics.Vty.PictureToSpans Graphics.Vty.Span
hidden-modules: Graphics.Vty.Attributes.Color
                Graphics.Vty.Attributes.Color240 Graphics.Vty.Debug.Image
                Graphics.Vty.Input.Terminfo.ANSIVT
abi: 15fd3d7aee30360d6215f6e34ef3966b
trusted: False
import-dirs: /usr/lib/ghc-8.2.2/site-local/vty-5.18.1
library-dirs: /usr/lib/ghc-8.2.2/site-local/vty-5.18.1
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.2/vty-5.18.1
hs-libraries: HSvty-5.18.1-1ArmFyNsA4q47eJ7kNxO
depends:
    base-4.10.1.0 blaze-builder-0.4.0.2-ClyQj7ny9rnJd2QFCbHKRH
    bytestring-0.10.8.2 containers-0.5.10.2 deepseq-1.4.3.0
    directory-1.3.0.2 filepath-1.4.1.2
    microlens-0.4.8.1-7SYUbX7BsEv8bVxypsAUmf
    microlens-mtl-0.1.11.0-I3xc8yNAKhRDow99zskwam
    microlens-th-0.4.1.1-HZwVEq73HCOxGGKdEpftc
    hashable-1.2.6.1-9ZXmUmZR8Ja1wkFjzrwxTy
    mtl-2.2.1-DscMMmDQUE6GBfOSl4qMUH
    parallel-3.2.1.1-6PIhrl6oqe7Af1Z2sa6T1
    parsec-3.1.11-4HFX6l6YojG1oyYQULsuQ1
    stm-2.4.4.1-E6EjE1bszQZJ9orPdUNxjw terminfo-0.4.1.0
    transformers-0.5.2.0 text-1.2.2.2-E3rQA0mJl73IvZIzvmwqAj
    unix-2.7.2.2 utf8-string-1.0.1.1-7sQ7eR5H5ED7poickls5aO
    vector-0.12.0.1-IUGn3M9mkBh8CyXcBnfTR4
abi-depends: base-4.10.1.0=0ea45191c57c268b2351cb731ab6a0d6
             blaze-builder-0.4.0.2-ClyQj7ny9rnJd2QFCbHKRH=9a0562647033c21b2abf88c991a65d08
             bytestring-0.10.8.2=4b2726b654ceeff6535e698a2a1e724e
             containers-0.5.10.2=0f9db0d1b935cacba444aac19f4cb54d
             deepseq-1.4.3.0=e843b5d736cc095915bf2399fddf152e
             directory-1.3.0.2=7b913664ccd770192b307d7c4c6817cc
             filepath-1.4.1.2=a40cd48e5480796e558f3c29652ee19a
             microlens-0.4.8.1-7SYUbX7BsEv8bVxypsAUmf=4a2398c3f847dcb0d93febf5e9ae665a
             microlens-mtl-0.1.11.0-I3xc8yNAKhRDow99zskwam=c58acf4ea4acdf12cb62f8e505c94b97
             microlens-th-0.4.1.1-HZwVEq73HCOxGGKdEpftc=c38adc99f710ad60976790e1bdd28c3d
             hashable-1.2.6.1-9ZXmUmZR8Ja1wkFjzrwxTy=6e4b4a70e10d525b7db51e3859aab169
             mtl-2.2.1-DscMMmDQUE6GBfOSl4qMUH=a1f89647d7228db4bf59b7aaec52e888
             parallel-3.2.1.1-6PIhrl6oqe7Af1Z2sa6T1=f329a0732f0d1ccfb717a7145bfd3a72
             parsec-3.1.11-4HFX6l6YojG1oyYQULsuQ1=893424ff0bd1ccfdf429c25df7ce2aa4
             stm-2.4.4.1-E6EjE1bszQZJ9orPdUNxjw=63c518eabfb1b430d925fb35cc544a7c
             terminfo-0.4.1.0=acb5ccd00d0581773cc2733d8844bf64
             transformers-0.5.2.0=b5dee110a615d751493b7ce1c6f95946
             text-1.2.2.2-E3rQA0mJl73IvZIzvmwqAj=19cd54ed0f93cc2e72d3ff0c754f5306
             unix-2.7.2.2=3df01ca0d7640dab598065ff1b1cffeb
             utf8-string-1.0.1.1-7sQ7eR5H5ED7poickls5aO=4a40da384793deade7b4b9c9224acdb7
             vector-0.12.0.1-IUGn3M9mkBh8CyXcBnfTR4=d8375a46a4155c3f449ce3d319b3dbaa
haddock-interfaces: /usr/share/doc/haskell-vty/html/vty.haddock
haddock-html: /usr/share/doc/haskell-vty/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

