/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.openstreetmap.josm.actions.OpenFileAction;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class RecentlyOpenedFilesMenu
extends JMenu {
    private ClearAction clearAction;

    public RecentlyOpenedFilesMenu() {
        super(I18n.tr("Open Recent", new Object[0]));
        this.setToolTipText(I18n.tr("List of recently opened files", new Object[0]));
        this.setIcon(ImageProvider.get("openrecent", ImageProvider.ImageSizes.MENU));
        this.putClientProperty("help", HelpUtil.ht("/Action/OpenRecent"));
        this.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                RecentlyOpenedFilesMenu.this.rebuild();
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
    }

    private void rebuild() {
        this.removeAll();
        List<String> fileHistory = Config.getPref().getList("file-open.history");
        for (String file : fileHistory) {
            this.add(new OpenRecentAction(file));
        }
        this.add(new JSeparator());
        if (this.clearAction == null) {
            this.clearAction = new ClearAction();
        }
        JMenuItem clearItem = new JMenuItem(this.clearAction);
        clearItem.setEnabled(!fileHistory.isEmpty());
        this.add(clearItem);
    }

    private static class ClearAction
    extends AbstractAction {
        ClearAction() {
            super(I18n.tr("Clear", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Clear the list of recently opened files", new Object[0]));
            this.putValue("help", HelpUtil.ht("/Action/OpenRecent"));
            this.putValue("toolbar", "recentlyopenedfiles/clear");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Config.getPref().putList("file-open.history", null);
        }
    }

    static final class OpenRecentAction
    extends AbstractAction {
        private final String file;

        OpenRecentAction(String file) {
            this.file = file;
            this.putValue("Name", file);
            this.putValue("help", HelpUtil.ht("/Action/OpenRecent"));
            this.putValue("toolbar", Boolean.FALSE);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OpenFileAction.OpenFileTask task = new OpenFileAction.OpenFileTask(Collections.singletonList(new File(this.file)), null);
            task.setRecordHistory(true);
            MainApplication.worker.submit(task);
        }
    }
}

