/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tokenizers;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.tagging.ManualTagger;
import org.languagetool.tagging.Tagger;
import org.languagetool.tokenizers.ManualTaggerAdapter;

public class ManualTaggerAdapterTest {
    private static final String TEST_DATA = "# some test data\ninflectedform11\tlemma1\tPOS1\ninflectedform121\tlemma1\tPOS2\ninflectedform122\tlemma1\tPOS2\ninflectedform123\tlemma1\tPOS3\ninflectedform2\tlemma2\tPOS1a\ninflectedform2\tlemma2\tPOS1b\ninflectedform2\tlemma2\tPOS1c\ninflectedform3\tlemma3a\tPOS3a\ninflectedform3\tlemma3b\tPOS3b\ninflectedform3\tlemma3c\tPOS3c\ninflectedform3\tlemma3d\tPOS3d\n";
    protected Tagger tagger;

    @Before
    public void setUp() throws Exception {
        this.tagger = new ManualTaggerAdapter(new ManualTagger((InputStream)new ByteArrayInputStream(TEST_DATA.getBytes("UTF-8"))));
    }

    @Test
    public void testMultipleLemma() throws Exception {
        List<String> l = Arrays.asList("inflectedform3");
        List analyzedTokenReadings = this.tagger.tag(l);
        Assert.assertNotNull((Object)analyzedTokenReadings);
        Assert.assertEquals((long)1L, (long)analyzedTokenReadings.size());
        AnalyzedTokenReadings analyzedTokenReading = (AnalyzedTokenReadings)analyzedTokenReadings.get(0);
        Assert.assertEquals((Object)"inflectedform3", (Object)analyzedTokenReading.getToken());
        Assert.assertNotNull((Object)analyzedTokenReading.getReadings());
        Assert.assertEquals((long)4L, (long)analyzedTokenReading.getReadingsLength());
        AnalyzedToken analyzedToken = (AnalyzedToken)analyzedTokenReading.getReadings().get(0);
        Assert.assertEquals((Object)"inflectedform3", (Object)analyzedToken.getToken());
        Assert.assertEquals((Object)"lemma3a", (Object)analyzedToken.getLemma());
        Assert.assertEquals((Object)"POS3a", (Object)analyzedToken.getPOSTag());
        analyzedToken = (AnalyzedToken)analyzedTokenReading.getReadings().get(1);
        Assert.assertEquals((Object)"inflectedform3", (Object)analyzedToken.getToken());
        Assert.assertEquals((Object)"lemma3b", (Object)analyzedToken.getLemma());
        Assert.assertEquals((Object)"POS3b", (Object)analyzedToken.getPOSTag());
        analyzedToken = (AnalyzedToken)analyzedTokenReading.getReadings().get(2);
        Assert.assertEquals((Object)"inflectedform3", (Object)analyzedToken.getToken());
        Assert.assertEquals((Object)"lemma3c", (Object)analyzedToken.getLemma());
        Assert.assertEquals((Object)"POS3c", (Object)analyzedToken.getPOSTag());
        analyzedToken = (AnalyzedToken)analyzedTokenReading.getReadings().get(3);
        Assert.assertEquals((Object)"inflectedform3", (Object)analyzedToken.getToken());
        Assert.assertEquals((Object)"lemma3d", (Object)analyzedToken.getLemma());
        Assert.assertEquals((Object)"POS3d", (Object)analyzedToken.getPOSTag());
    }

    @Test
    public void testMultiplePOS() throws Exception {
        List<String> l = Arrays.asList("inflectedform2");
        List analyzedTokenReadings = this.tagger.tag(l);
        Assert.assertNotNull((Object)analyzedTokenReadings);
        Assert.assertEquals((long)1L, (long)analyzedTokenReadings.size());
        AnalyzedTokenReadings analyzedTokenReading = (AnalyzedTokenReadings)analyzedTokenReadings.get(0);
        Assert.assertEquals((Object)"inflectedform2", (Object)analyzedTokenReading.getToken());
        Assert.assertNotNull((Object)analyzedTokenReading.getReadings());
        Assert.assertEquals((long)3L, (long)analyzedTokenReading.getReadingsLength());
        AnalyzedToken analyzedToken = (AnalyzedToken)analyzedTokenReading.getReadings().get(0);
        Assert.assertEquals((Object)"POS1a", (Object)analyzedToken.getPOSTag());
        Assert.assertEquals((Object)"inflectedform2", (Object)analyzedToken.getToken());
        Assert.assertEquals((Object)"lemma2", (Object)analyzedToken.getLemma());
        analyzedToken = (AnalyzedToken)analyzedTokenReading.getReadings().get(1);
        Assert.assertEquals((Object)"POS1b", (Object)analyzedToken.getPOSTag());
        Assert.assertEquals((Object)"inflectedform2", (Object)analyzedToken.getToken());
        Assert.assertEquals((Object)"lemma2", (Object)analyzedToken.getLemma());
        analyzedToken = (AnalyzedToken)analyzedTokenReading.getReadings().get(2);
        Assert.assertEquals((Object)"POS1c", (Object)analyzedToken.getPOSTag());
        Assert.assertEquals((Object)"inflectedform2", (Object)analyzedToken.getToken());
        Assert.assertEquals((Object)"lemma2", (Object)analyzedToken.getLemma());
    }

    @Test
    public void testMultipleWords() throws Exception {
        List<String> l = Arrays.asList("inflectedform2", "inflectedform3");
        List analyzedTokenReadings = this.tagger.tag(l);
        Assert.assertNotNull((Object)analyzedTokenReadings);
        Assert.assertEquals((long)2L, (long)analyzedTokenReadings.size());
        AnalyzedTokenReadings analyzedTokenReading = (AnalyzedTokenReadings)analyzedTokenReadings.get(0);
        Assert.assertEquals((Object)"inflectedform2", (Object)analyzedTokenReading.getToken());
        Assert.assertNotNull((Object)analyzedTokenReading.getReadings());
        Assert.assertEquals((long)3L, (long)analyzedTokenReading.getReadingsLength());
        analyzedTokenReading = (AnalyzedTokenReadings)analyzedTokenReadings.get(1);
        Assert.assertEquals((Object)"inflectedform3", (Object)analyzedTokenReading.getToken());
        Assert.assertNotNull((Object)analyzedTokenReading.getReadings());
        Assert.assertEquals((long)4L, (long)analyzedTokenReading.getReadingsLength());
    }
}

