/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwt.impl;

import com.auth0.jwt.impl.JsonNodeClaim;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.Header;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class BasicHeader
implements Header {
    private final String algorithm;
    private final String type;
    private final String contentType;
    private final String keyId;
    private final Map<String, JsonNode> tree;

    BasicHeader(String algorithm, String type, String contentType, String keyId, Map<String, JsonNode> tree) {
        this.algorithm = algorithm;
        this.type = type;
        this.contentType = contentType;
        this.keyId = keyId;
        this.tree = Collections.unmodifiableMap(tree == null ? new HashMap() : tree);
    }

    Map<String, JsonNode> getTree() {
        return this.tree;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getKeyId() {
        return this.keyId;
    }

    @Override
    public Claim getHeaderClaim(String name) {
        return JsonNodeClaim.extractClaim(name, this.tree);
    }
}

