package Lire::SQLExt::LrTimeslot;

use strict;

use Lire::WeekCalculator;

use vars qw/ $calc /;

my %unit_index = ( 'h' => 2,
                   'd' => 6,
                   'M' => 4,
                   'm' => 1,
                   's' => 0 );

sub lr_timeslot {
    my ( $t, $mult, $unit ) = @_;

    return undef unless ( defined $t && defined $mult && defined $unit );

    my $idx = $unit_index{$unit};
    return undef unless defined $idx;

    my $x = ( localtime ( $t ) )[$idx];

    return $x - ( $x % $mult );
}

sub lr_timeslot_week {
    my ( $t, $mult ) = @_;

    return undef unless ( defined $t && defined $mult );

    $calc ||= new Lire::WeekCalculator();

    return int( ($calc->week_number( $t ) - 1) / $mult ) * $mult + 1;
}

1;
__END__

=pod

=head1 NAME

Lire::SQLExt::LrTimeslot - FILL ME IN

=head1 SYNOPSIS

  FILL ME IN

=head1 DESCRIPTION

  FILL ME IN

=head1 SEE ALSO

Lire::DlfConverter(3pm)

=head1 VERSION

Id: LrTimeslot.pm,v 1.3 2003/10/14 12:59:55 wsourdeau Exp $

=head1 AUTHOR

  Francis J. Lacoste <flacoste@logreport.org>
  Wolfgang Sourdeau <wolfgang@logreport.org>

=head1 COPYRIGHT

Copyright (C) 2003 Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html.

=cut

