/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.figures;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.Collection;
import java.util.LinkedList;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.BoundsOutlineHandle;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.ResizeHandleKit;
import org.jhotdraw.draw.TransformHandleKit;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.geom.GrowStroke;
import org.jhotdraw.samples.svg.Gradient;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.samples.svg.figures.LinkHandle;
import org.jhotdraw.samples.svg.figures.SVGAttributedFigure;
import org.jhotdraw.samples.svg.figures.SVGFigure;
import org.jhotdraw.samples.svg.figures.SVGRectRadiusHandle;

public class SVGRectFigure
extends SVGAttributedFigure
implements SVGFigure {
    public static final String ARC_WIDTH_PROPERTY = "arcWidth";
    public static final String ARC_HEIGHT_PROPERTY = "arcHeight";
    private static final double acv;
    private RoundRectangle2D.Double roundrect;
    private transient Shape cachedTransformedShape;
    private transient Shape cachedHitShape;

    public SVGRectFigure() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public SVGRectFigure(double d, double d2, double d3, double d4) {
        this(d, d2, d3, d4, 0.0, 0.0);
    }

    public SVGRectFigure(double d, double d2, double d3, double d4, double d5, double d6) {
        this.roundrect = new RoundRectangle2D.Double(d, d2, d3, d4, d5, d6);
        SVGAttributeKeys.setDefaults(this);
    }

    @Override
    protected void drawFill(Graphics2D graphics2D) {
        if (this.getArcHeight() == 0.0 && this.getArcWidth() == 0.0) {
            graphics2D.fill(this.roundrect.getBounds2D());
        } else {
            graphics2D.fill(this.roundrect);
        }
    }

    @Override
    protected void drawStroke(Graphics2D graphics2D) {
        if (this.roundrect.archeight == 0.0 && this.roundrect.arcwidth == 0.0) {
            graphics2D.draw(this.roundrect.getBounds2D());
        } else {
            GeneralPath generalPath = new GeneralPath();
            double d = this.roundrect.arcwidth / 2.0;
            double d2 = this.roundrect.archeight / 2.0;
            generalPath.moveTo((float)(this.roundrect.x + d), (float)this.roundrect.y);
            generalPath.lineTo((float)(this.roundrect.x + this.roundrect.width - d), (float)this.roundrect.y);
            generalPath.curveTo((float)(this.roundrect.x + this.roundrect.width - d * acv), (float)this.roundrect.y, (float)(this.roundrect.x + this.roundrect.width), (float)(this.roundrect.y + d2 * acv), (float)(this.roundrect.x + this.roundrect.width), (float)(this.roundrect.y + d2));
            generalPath.lineTo((float)(this.roundrect.x + this.roundrect.width), (float)(this.roundrect.y + this.roundrect.height - d2));
            generalPath.curveTo((float)(this.roundrect.x + this.roundrect.width), (float)(this.roundrect.y + this.roundrect.height - d2 * acv), (float)(this.roundrect.x + this.roundrect.width - d * acv), (float)(this.roundrect.y + this.roundrect.height), (float)(this.roundrect.x + this.roundrect.width - d), (float)(this.roundrect.y + this.roundrect.height));
            generalPath.lineTo((float)(this.roundrect.x + d), (float)(this.roundrect.y + this.roundrect.height));
            generalPath.curveTo((float)(this.roundrect.x + d * acv), (float)(this.roundrect.y + this.roundrect.height), (float)this.roundrect.x, (float)(this.roundrect.y + this.roundrect.height - d2 * acv), (float)this.roundrect.x, (float)(this.roundrect.y + this.roundrect.height - d2));
            generalPath.lineTo((float)this.roundrect.x, (float)(this.roundrect.y + d2));
            generalPath.curveTo((float)this.roundrect.x, (float)(this.roundrect.y + d2 * acv), (float)(this.roundrect.x + d * acv), (float)this.roundrect.y, (float)(this.roundrect.x + d), (float)this.roundrect.y);
            generalPath.closePath();
            graphics2D.draw(generalPath);
        }
    }

    public double getX() {
        return this.roundrect.x;
    }

    public double getY() {
        return this.roundrect.y;
    }

    public double getWidth() {
        return this.roundrect.width;
    }

    public double getHeight() {
        return this.roundrect.height;
    }

    public double getArcWidth() {
        return this.roundrect.arcwidth;
    }

    public double getArcHeight() {
        return this.roundrect.archeight;
    }

    public void setArcWidth(double d) {
        double d2 = this.roundrect.arcwidth;
        this.roundrect.arcwidth = d;
        this.firePropertyChange(ARC_WIDTH_PROPERTY, d2, d);
    }

    public void setArcHeight(double d) {
        double d2 = this.roundrect.archeight;
        this.roundrect.archeight = d;
        this.firePropertyChange(ARC_HEIGHT_PROPERTY, d2, d);
    }

    public void setArc(double d, double d2) {
        this.setArcWidth(d);
        this.setArcHeight(d2);
    }

    @Override
    public Rectangle2D.Double getBounds() {
        return (Rectangle2D.Double)this.roundrect.getBounds2D();
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        Rectangle2D.Double double_;
        Rectangle2D rectangle2D = this.getTransformedShape().getBounds2D();
        Rectangle2D.Double double_2 = double_ = rectangle2D instanceof Rectangle2D.Double ? (Rectangle2D.Double)rectangle2D : new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        if (this.get(SVGAttributeKeys.TRANSFORM) == null) {
            double d = SVGAttributeKeys.getPerpendicularHitGrowth(this) * 2.0 + 1.0;
            Geom.grow(double_, d, d);
        } else {
            double d = AttributeKeys.getStrokeTotalWidth(this);
            double d2 = d / 2.0;
            if ((Integer)this.get(SVGAttributeKeys.STROKE_JOIN) == 0) {
                d2 *= ((Double)this.get(SVGAttributeKeys.STROKE_MITER_LIMIT)).doubleValue();
            }
            if ((Integer)this.get(SVGAttributeKeys.STROKE_CAP) != 0) {
                d2 += d * 2.0;
            }
            Geom.grow(double_, d2 += 1.0, d2);
        }
        return double_;
    }

    @Override
    public boolean contains(Point2D.Double double_) {
        return this.getHitShape().contains(double_);
    }

    @Override
    public void setBounds(Point2D.Double double_, Point2D.Double double_2) {
        this.invalidateTransformedShape();
        this.roundrect.x = Math.min(double_.x, double_2.x);
        this.roundrect.y = Math.min(double_.y, double_2.y);
        this.roundrect.width = Math.max(0.1, Math.abs(double_2.x - double_.x));
        this.roundrect.height = Math.max(0.1, Math.abs(double_2.y - double_.y));
        this.invalidate();
    }

    private void invalidateTransformedShape() {
        this.cachedTransformedShape = null;
        this.cachedHitShape = null;
    }

    private Shape getTransformedShape() {
        if (this.cachedTransformedShape == null) {
            this.cachedTransformedShape = this.getArcHeight() == 0.0 || this.getArcWidth() == 0.0 ? this.roundrect.getBounds2D() : (Shape)this.roundrect.clone();
            if (this.get(SVGAttributeKeys.TRANSFORM) != null) {
                this.cachedTransformedShape = ((AffineTransform)this.get(SVGAttributeKeys.TRANSFORM)).createTransformedShape(this.cachedTransformedShape);
            }
        }
        return this.cachedTransformedShape;
    }

    private Shape getHitShape() {
        if (this.cachedHitShape == null) {
            this.cachedHitShape = this.get(SVGAttributeKeys.FILL_COLOR) != null || this.get(SVGAttributeKeys.FILL_GRADIENT) != null ? new GrowStroke((float)SVGAttributeKeys.getStrokeTotalWidth(this) / 2.0f, (float)SVGAttributeKeys.getStrokeTotalMiterLimit(this)).createStrokedShape(this.getTransformedShape()) : SVGAttributeKeys.getHitStroke(this).createStrokedShape(this.getTransformedShape());
        }
        return this.cachedHitShape;
    }

    @Override
    public void transform(AffineTransform affineTransform) {
        this.invalidateTransformedShape();
        if (this.get(SVGAttributeKeys.TRANSFORM) != null || (affineTransform.getType() & 1) != affineTransform.getType()) {
            if (this.get(SVGAttributeKeys.TRANSFORM) == null) {
                this.set(SVGAttributeKeys.TRANSFORM, (AffineTransform)affineTransform.clone());
            } else {
                AffineTransform affineTransform2 = (AffineTransform)SVGAttributeKeys.TRANSFORM.getClone(this);
                affineTransform2.preConcatenate(affineTransform);
                this.set(SVGAttributeKeys.TRANSFORM, affineTransform2);
            }
        } else {
            Gradient gradient;
            Point2D.Double double_ = this.getStartPoint();
            Point2D.Double double_2 = this.getEndPoint();
            this.setBounds((Point2D.Double)affineTransform.transform(double_, double_), (Point2D.Double)affineTransform.transform(double_2, double_2));
            if (this.get(SVGAttributeKeys.FILL_GRADIENT) != null && !this.get(SVGAttributeKeys.FILL_GRADIENT).isRelativeToFigureBounds()) {
                gradient = SVGAttributeKeys.FILL_GRADIENT.getClone(this);
                gradient.transform(affineTransform);
                this.set(SVGAttributeKeys.FILL_GRADIENT, gradient);
            }
            if (this.get(SVGAttributeKeys.STROKE_GRADIENT) != null && !this.get(SVGAttributeKeys.STROKE_GRADIENT).isRelativeToFigureBounds()) {
                gradient = SVGAttributeKeys.STROKE_GRADIENT.getClone(this);
                gradient.transform(affineTransform);
                this.set(SVGAttributeKeys.STROKE_GRADIENT, gradient);
            }
        }
    }

    @Override
    public void restoreTransformTo(Object object) {
        this.invalidateTransformedShape();
        Object[] objectArray = (Object[])object;
        this.roundrect = (RoundRectangle2D.Double)((RoundRectangle2D.Double)objectArray[0]).clone();
        SVGAttributeKeys.TRANSFORM.setClone(this, (AffineTransform)objectArray[1]);
        SVGAttributeKeys.FILL_GRADIENT.setClone(this, (Gradient)objectArray[2]);
        SVGAttributeKeys.STROKE_GRADIENT.setClone(this, (Gradient)objectArray[3]);
    }

    @Override
    public Object getTransformRestoreData() {
        return new Object[]{this.roundrect.clone(), SVGAttributeKeys.TRANSFORM.getClone(this), SVGAttributeKeys.FILL_GRADIENT.getClone(this), SVGAttributeKeys.STROKE_GRADIENT.getClone(this)};
    }

    @Override
    public Collection<Handle> createHandles(int n) {
        LinkedList<Handle> linkedList = new LinkedList<Handle>();
        switch (n % 2) {
            case -1: {
                linkedList.add(new BoundsOutlineHandle(this, false, true));
                break;
            }
            case 0: {
                ResizeHandleKit.addResizeHandles(this, linkedList);
                linkedList.add(new SVGRectRadiusHandle(this));
                linkedList.add(new LinkHandle(this));
                break;
            }
            case 1: {
                TransformHandleKit.addTransformHandles(this, linkedList);
                break;
            }
        }
        return linkedList;
    }

    @Override
    public boolean canConnect() {
        return false;
    }

    @Override
    public Connector findConnector(Point2D.Double double_, ConnectionFigure connectionFigure) {
        return null;
    }

    @Override
    public Connector findCompatibleConnector(Connector connector, boolean bl) {
        return null;
    }

    @Override
    public SVGRectFigure clone() {
        SVGRectFigure sVGRectFigure = (SVGRectFigure)super.clone();
        sVGRectFigure.roundrect = (RoundRectangle2D.Double)this.roundrect.clone();
        sVGRectFigure.cachedTransformedShape = null;
        sVGRectFigure.cachedHitShape = null;
        return sVGRectFigure;
    }

    @Override
    public boolean isEmpty() {
        Rectangle2D.Double double_ = this.getBounds();
        return double_.width <= 0.0 || double_.height <= 0.0;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.invalidateTransformedShape();
    }

    static {
        double d = 0.7853981633974483;
        double d2 = 1.0 - Math.cos(d);
        double d3 = Math.tan(d);
        double d4 = Math.sqrt(1.0 + d3 * d3) - 1.0 + d2;
        double d5 = 1.3333333333333333 * d2 * d3 / d4;
        acv = 1.0 - d5;
    }
}

