/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMember;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.EnclosingMethodAttribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttribute;
import proguard.classfile.attribute.annotation.AnnotationElementValue;
import proguard.classfile.attribute.annotation.AnnotationsAttribute;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ClassElementValue;
import proguard.classfile.attribute.annotation.ConstantElementValue;
import proguard.classfile.attribute.annotation.ElementValue;
import proguard.classfile.attribute.annotation.EnumConstantElementValue;
import proguard.classfile.attribute.annotation.ParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.ElementValueVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.InterfaceMethodrefConstant;
import proguard.classfile.constant.MethodrefConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.editor.StackSizeUpdater;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class MemberReferenceFixer
extends SimplifiedVisitor
implements ClassVisitor,
ConstantVisitor,
MemberVisitor,
AttributeVisitor,
AnnotationVisitor,
ElementValueVisitor {
    private static final boolean DEBUG = false;
    private final StackSizeUpdater stackSizeUpdater = new StackSizeUpdater();
    private int constantIndex;
    private boolean isInterfaceMethod;
    private boolean stackSizesMayHaveChanged;

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        this.stackSizesMayHaveChanged = false;
        for (int i = 1; i < programClass.u2constantPoolCount; ++i) {
            Constant constant = programClass.constantPool[i];
            if (constant == null) continue;
            this.constantIndex = i;
            constant.accept(programClass, this);
        }
        programClass.fieldsAccept(this);
        programClass.methodsAccept(this);
        programClass.attributesAccept(this);
    }

    @Override
    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    @Override
    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        Member member = stringConstant.referencedMember;
        if (member != null) {
            Clazz clazz2 = stringConstant.referencedClass;
            String string = member.getName(clazz2);
            if (!stringConstant.getString(clazz).equals(string)) {
                stringConstant.u2stringIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(string);
            }
        }
    }

    @Override
    public void visitFieldrefConstant(Clazz clazz, FieldrefConstant fieldrefConstant) {
        Member member = fieldrefConstant.referencedMember;
        if (member != null) {
            Clazz clazz2 = fieldrefConstant.referencedClass;
            String string = member.getName(clazz2);
            String string2 = member.getDescriptor(clazz2);
            if (!fieldrefConstant.getName(clazz).equals(string) || !fieldrefConstant.getType(clazz).equals(string2)) {
                fieldrefConstant.u2nameAndTypeIndex = new ConstantPoolEditor((ProgramClass)clazz).addNameAndTypeConstant(string, string2);
            }
        }
    }

    @Override
    public void visitInterfaceMethodrefConstant(Clazz clazz, InterfaceMethodrefConstant interfaceMethodrefConstant) {
        Member member = interfaceMethodrefConstant.referencedMember;
        if (member != null) {
            Clazz clazz2 = interfaceMethodrefConstant.referencedClass;
            String string = member.getName(clazz2);
            String string2 = member.getDescriptor(clazz2);
            if (!interfaceMethodrefConstant.getName(clazz).equals(string) || !interfaceMethodrefConstant.getType(clazz).equals(string2)) {
                interfaceMethodrefConstant.u2nameAndTypeIndex = new ConstantPoolEditor((ProgramClass)clazz).addNameAndTypeConstant(string, string2);
                this.stackSizesMayHaveChanged = true;
            }
            this.isInterfaceMethod = true;
            clazz.constantPoolEntryAccept(interfaceMethodrefConstant.u2classIndex, this);
            if (!this.isInterfaceMethod) {
                ((ProgramClass)clazz).constantPool[this.constantIndex] = new MethodrefConstant(interfaceMethodrefConstant.u2classIndex, interfaceMethodrefConstant.u2nameAndTypeIndex, clazz2, member);
            }
        }
    }

    @Override
    public void visitMethodrefConstant(Clazz clazz, MethodrefConstant methodrefConstant) {
        Member member = methodrefConstant.referencedMember;
        if (member != null) {
            Clazz clazz2 = methodrefConstant.referencedClass;
            String string = member.getName(clazz2);
            String string2 = member.getDescriptor(clazz2);
            if (!methodrefConstant.getName(clazz).equals(string) || !methodrefConstant.getType(clazz).equals(string2)) {
                methodrefConstant.u2nameAndTypeIndex = new ConstantPoolEditor((ProgramClass)clazz).addNameAndTypeConstant(string, string2);
                this.stackSizesMayHaveChanged = true;
            }
            this.isInterfaceMethod = false;
            clazz.constantPoolEntryAccept(methodrefConstant.u2classIndex, this);
            if (this.isInterfaceMethod) {
                ((ProgramClass)clazz).constantPool[this.constantIndex] = new InterfaceMethodrefConstant(methodrefConstant.u2classIndex, methodrefConstant.u2nameAndTypeIndex, clazz2, member);
            }
        }
    }

    @Override
    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        if (ClassUtil.isInternalArrayType(classConstant.getName(clazz))) {
            this.isInterfaceMethod = false;
        } else {
            Clazz clazz2 = classConstant.referencedClass;
            if (clazz2 != null) {
                this.isInterfaceMethod = (clazz2.getAccessFlags() & 0x200) != 0;
            }
        }
    }

    @Override
    public void visitProgramMember(ProgramClass programClass, ProgramMember programMember) {
        programMember.attributesAccept(programClass, this);
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitEnclosingMethodAttribute(Clazz clazz, EnclosingMethodAttribute enclosingMethodAttribute) {
        Method method = enclosingMethodAttribute.referencedMethod;
        if (method != null) {
            Clazz clazz2 = enclosingMethodAttribute.referencedClass;
            String string = method.getName(clazz2);
            String string2 = method.getDescriptor(clazz2);
            if (!enclosingMethodAttribute.getName(clazz).equals(string) || !enclosingMethodAttribute.getType(clazz).equals(string2)) {
                enclosingMethodAttribute.u2nameAndTypeIndex = new ConstantPoolEditor((ProgramClass)clazz).addNameAndTypeConstant(string, string2);
            }
        }
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        if (this.stackSizesMayHaveChanged) {
            this.stackSizeUpdater.visitCodeAttribute(clazz, method, codeAttribute);
        }
        codeAttribute.attributesAccept(clazz, method, this);
    }

    @Override
    public void visitAnyAnnotationsAttribute(Clazz clazz, AnnotationsAttribute annotationsAttribute) {
        annotationsAttribute.annotationsAccept(clazz, this);
    }

    @Override
    public void visitAnyParameterAnnotationsAttribute(Clazz clazz, Method method, ParameterAnnotationsAttribute parameterAnnotationsAttribute) {
        parameterAnnotationsAttribute.annotationsAccept(clazz, method, this);
    }

    @Override
    public void visitAnnotationDefaultAttribute(Clazz clazz, Method method, AnnotationDefaultAttribute annotationDefaultAttribute) {
        annotationDefaultAttribute.defaultValueAccept(clazz, this);
    }

    @Override
    public void visitAnnotation(Clazz clazz, Annotation annotation) {
        annotation.elementValuesAccept(clazz, this);
    }

    @Override
    public void visitConstantElementValue(Clazz clazz, Annotation annotation, ConstantElementValue constantElementValue) {
        this.fixElementValue(clazz, annotation, constantElementValue);
    }

    @Override
    public void visitEnumConstantElementValue(Clazz clazz, Annotation annotation, EnumConstantElementValue enumConstantElementValue) {
        this.fixElementValue(clazz, annotation, enumConstantElementValue);
    }

    @Override
    public void visitClassElementValue(Clazz clazz, Annotation annotation, ClassElementValue classElementValue) {
        this.fixElementValue(clazz, annotation, classElementValue);
    }

    @Override
    public void visitAnnotationElementValue(Clazz clazz, Annotation annotation, AnnotationElementValue annotationElementValue) {
        this.fixElementValue(clazz, annotation, annotationElementValue);
        annotationElementValue.annotationAccept(clazz, this);
    }

    @Override
    public void visitArrayElementValue(Clazz clazz, Annotation annotation, ArrayElementValue arrayElementValue) {
        this.fixElementValue(clazz, annotation, arrayElementValue);
        arrayElementValue.elementValuesAccept(clazz, annotation, this);
    }

    private void fixElementValue(Clazz clazz, Annotation annotation, ElementValue elementValue) {
        String string;
        String string2;
        Method method = elementValue.referencedMethod;
        if (method != null && !(string2 = elementValue.getMethodName(clazz)).equals(string = method.getName(elementValue.referencedClass))) {
            elementValue.u2elementNameIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(string);
        }
    }

    private void debug(Clazz clazz, StringConstant stringConstant, Clazz clazz2, Member member) {
        System.out.println("MemberReferenceFixer:");
        System.out.println("  [" + clazz.getName() + "]: String [" + stringConstant.getString(clazz) + "] -> [" + clazz2.getName() + "." + member.getName(clazz2) + " " + member.getDescriptor(clazz2) + "]");
    }

    private void debug(Clazz clazz, RefConstant refConstant, Clazz clazz2, Member member) {
        System.out.println("MemberReferenceFixer:");
        System.out.println("  [" + clazz.getName() + "]: [" + refConstant.getClassName(clazz) + "." + refConstant.getName(clazz) + " " + refConstant.getType(clazz) + "] -> [" + clazz2.getName() + "." + member.getName(clazz2) + " " + member.getDescriptor(clazz2) + "]");
    }
}

