/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.control.basics.geom;

import com.baselet.control.basics.geom.PointDouble;

public class Point {
    public int x;
    public int y;

    public Point() {
    }

    public Point(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public Point move(int diffX, int diffY) {
        this.x += diffX;
        this.y += diffY;
        return this;
    }

    public double distance(Point o) {
        double distX = o.getX() - this.getX();
        double distY = o.getY() - this.getY();
        return Math.sqrt(distX * distX + distY * distY);
    }

    public Point copy() {
        return new Point(this.x, this.y);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Point other = (Point)obj;
        if (this.x != other.x) {
            return false;
        }
        return this.y == other.y;
    }

    public String toString() {
        return "p(x=" + this.x + ", y=" + this.y + ")";
    }

    public PointDouble toPointDouble() {
        return new PointDouble(this.x, this.y);
    }
}

