/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.proxy;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.log4j.Logger;
import org.parosproxy.paros.common.AbstractParam;
import org.parosproxy.paros.network.SSLConnector;

public class ProxyParam
extends AbstractParam {
    private static final Logger logger = Logger.getLogger(ProxyParam.class);
    private static final String PROXY_BASE_KEY = "proxy";
    private static final String PROXY_IP = "proxy.ip";
    private static final String PROXY_PORT = "proxy.port";
    private static final String USE_REVERSE_PROXY = "proxy.reverseProxy.use";
    private static final String REVERSE_PROXY_IP = "proxy.reverseProxy.ip";
    private static final String REVERSE_PROXY_HTTP_PORT = "proxy.reverseProxy.httpPort";
    private static final String REVERSE_PROXY_HTTPS_PORT = "proxy.reverseProxy.httpsPort";
    private static final String PROXY_BEHIND_NAT = "proxy.behindnat";
    private static final String SECURITY_PROTOCOLS_ENABLED = "proxy.securityProtocolsEnabled";
    private static final String ALL_SECURITY_PROTOCOLS_ENABLED_KEY = "proxy.securityProtocolsEnabled.protocol";
    private static final String REMOVE_UNSUPPORTED_ENCODINGS = "proxy.removeUnsupportedEncodings";
    private static final String ALWAYS_DECODE_GZIP = "proxy.decodeGzip";
    private String proxyIp = "localhost";
    private int proxyPort = 8080;
    private int proxySSLPort = 8443;
    private int useReverseProxy = 0;
    private String reverseProxyIp = "localhost";
    private int reverseProxyHttpPort = 80;
    private int reverseProxyHttpsPort = 443;
    private boolean proxyIpAnyLocalAddress;
    private boolean removeUnsupportedEncodings = true;
    private boolean alwaysDecodeGzip = true;
    private boolean behindNat;
    private String[] securityProtocolsEnabled;

    @Override
    protected void parse() {
        this.proxyIp = this.getConfig().getString(PROXY_IP, "localhost");
        this.determineProxyIpAnyLocalAddress();
        try {
            this.proxyPort = this.getConfig().getInt(PROXY_PORT, 8080);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.proxySSLPort = 8443;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.reverseProxyIp = this.getConfig().getString(REVERSE_PROXY_IP);
        if (this.reverseProxyIp.equalsIgnoreCase("localhost") || this.reverseProxyIp.equalsIgnoreCase("127.0.0.1")) {
            try {
                this.reverseProxyIp = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                logger.error((Object)unknownHostException.getMessage(), (Throwable)unknownHostException);
            }
        }
        this.reverseProxyHttpPort = this.getConfig().getInt(REVERSE_PROXY_HTTP_PORT, 80);
        this.reverseProxyHttpsPort = this.getConfig().getInt(REVERSE_PROXY_HTTPS_PORT, 443);
        this.useReverseProxy = this.getConfig().getInt(USE_REVERSE_PROXY, 0);
        this.removeUnsupportedEncodings = this.getConfig().getBoolean(REMOVE_UNSUPPORTED_ENCODINGS, true);
        this.alwaysDecodeGzip = this.getConfig().getBoolean(ALWAYS_DECODE_GZIP, true);
        this.loadSecurityProtocolsEnabled();
        try {
            this.behindNat = this.getConfig().getBoolean(PROXY_BEHIND_NAT, false);
        }
        catch (ConversionException conversionException) {
            logger.error((Object)"Failed to read 'proxy.behindnat'", (Throwable)conversionException);
        }
    }

    public String getProxyIp() {
        if (this.isProxyIpAnyLocalAddress()) {
            try {
                return InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                return "localhost";
            }
        }
        return this.proxyIp;
    }

    public String getRawProxyIP() {
        if (this.proxyIp == null || this.proxyIp.length() == 0) {
            return "0.0.0.0";
        }
        return this.proxyIp;
    }

    public void setProxyIp(String string) {
        if (this.proxyIp.equals(string)) {
            return;
        }
        this.proxyIp = string.trim();
        this.getConfig().setProperty(PROXY_IP, (Object)this.proxyIp);
        this.determineProxyIpAnyLocalAddress();
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int n) {
        this.proxyPort = n;
        this.getConfig().setProperty(PROXY_PORT, (Object)Integer.toString(this.proxyPort));
    }

    public int getProxySSLPort() {
        return this.proxySSLPort;
    }

    public String getReverseProxyIp() {
        return this.reverseProxyIp;
    }

    public void setReverseProxyIp(String string) {
        this.reverseProxyIp = string.trim();
        this.getConfig().setProperty(REVERSE_PROXY_IP, (Object)this.reverseProxyIp);
    }

    public int getReverseProxyHttpPort() {
        return this.reverseProxyHttpPort;
    }

    public void setReverseProxyHttpPort(int n) {
        this.reverseProxyHttpPort = n;
        this.getConfig().setProperty(REVERSE_PROXY_HTTP_PORT, (Object)Integer.toString(this.reverseProxyHttpPort));
    }

    public int getReverseProxyHttpsPort() {
        return this.reverseProxyHttpsPort;
    }

    public void setReverseProxyHttpsPort(int n) {
        this.reverseProxyHttpsPort = n;
        this.getConfig().setProperty(REVERSE_PROXY_HTTPS_PORT, (Object)Integer.toString(this.reverseProxyHttpsPort));
    }

    public boolean isUseReverseProxy() {
        return this.useReverseProxy != 0;
    }

    public void setUseReverseProxy(boolean bl) {
        if (bl) {
            this.useReverseProxy = 1;
            this.getConfig().setProperty(USE_REVERSE_PROXY, (Object)Integer.toString(this.useReverseProxy));
            return;
        }
        this.useReverseProxy = 0;
        this.getConfig().setProperty(USE_REVERSE_PROXY, (Object)Integer.toString(this.useReverseProxy));
    }

    @Deprecated
    public void setModifyAcceptEncodingHeader(boolean bl) {
        this.setRemoveUnsupportedEncodings(bl);
    }

    @Deprecated
    public boolean isModifyAcceptEncodingHeader() {
        return this.isRemoveUnsupportedEncodings();
    }

    public void setRemoveUnsupportedEncodings(boolean bl) {
        if (this.removeUnsupportedEncodings != bl) {
            this.removeUnsupportedEncodings = bl;
            this.getConfig().setProperty(REMOVE_UNSUPPORTED_ENCODINGS, (Object)this.removeUnsupportedEncodings);
        }
    }

    public boolean isRemoveUnsupportedEncodings() {
        return this.removeUnsupportedEncodings;
    }

    public boolean isAlwaysDecodeGzip() {
        return this.alwaysDecodeGzip;
    }

    public void setAlwaysDecodeGzip(boolean bl) {
        this.alwaysDecodeGzip = bl;
        this.getConfig().setProperty(ALWAYS_DECODE_GZIP, (Object)bl);
    }

    public String[] getSecurityProtocolsEnabled() {
        return Arrays.copyOf(this.securityProtocolsEnabled, this.securityProtocolsEnabled.length);
    }

    public void setSecurityProtocolsEnabled(String[] stringArray) {
        int n;
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n] != null && !stringArray[n].isEmpty()) continue;
            throw new IllegalArgumentException("The parameter enabledProtocols must not contain null or empty elements.");
        }
        ((HierarchicalConfiguration)this.getConfig()).clearTree(ALL_SECURITY_PROTOCOLS_ENABLED_KEY);
        for (n = 0; n < stringArray.length; ++n) {
            String string = "proxy.securityProtocolsEnabled.protocol(" + n + ")";
            this.getConfig().setProperty(string, (Object)stringArray[n]);
        }
        this.securityProtocolsEnabled = Arrays.copyOf(stringArray, stringArray.length);
        SSLConnector.setServerEnabledProtocols(stringArray);
    }

    private void loadSecurityProtocolsEnabled() {
        List list = this.getConfig().getList(ALL_SECURITY_PROTOCOLS_ENABLED_KEY);
        if (list.size() != 0) {
            this.securityProtocolsEnabled = new String[list.size()];
            this.securityProtocolsEnabled = list.toArray(this.securityProtocolsEnabled);
            SSLConnector.setServerEnabledProtocols(this.securityProtocolsEnabled);
        } else {
            this.setSecurityProtocolsEnabled(SSLConnector.getServerEnabledProtocols());
        }
    }

    public boolean isProxyIpAnyLocalAddress() {
        return this.proxyIpAnyLocalAddress;
    }

    private void determineProxyIpAnyLocalAddress() {
        try {
            this.proxyIpAnyLocalAddress = this.proxyIp.isEmpty() || InetAddress.getByName(this.proxyIp).isAnyLocalAddress();
        }
        catch (UnknownHostException unknownHostException) {
            this.proxyIpAnyLocalAddress = false;
        }
    }

    public boolean isBehindNat() {
        return this.behindNat;
    }

    public void setBehindNat(boolean bl) {
        this.behindNat = bl;
        this.getConfig().setProperty(PROXY_BEHIND_NAT, (Object)bl);
    }
}

