// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `FileParser.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __IceGrid_FileParser_h__
#define __IceGrid_FileParser_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <Ice/Proxy.h>
#include <Ice/Object.h>
#include <Ice/GCObject.h>
#include <Ice/Value.h>
#include <Ice/Incoming.h>
#include <Ice/IncomingAsync.h>
#include <Ice/FactoryTableInit.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/ExceptionHelpers.h>
#include <Ice/SlicedDataF.h>
#include <IceGrid/Admin.h>
#include <IceUtil/UndefSysMacros.h>
#include <IceGrid/Config.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 > 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 0
#       error Ice patch level mismatch!
#   endif
#endif

#ifndef ICEGRID_API
#   if defined(ICE_STATIC_LIBS)
#       define ICEGRID_API /**/
#   elif defined(ICEGRID_API_EXPORTS)
#       define ICEGRID_API ICE_DECLSPEC_EXPORT
#   else
#       define ICEGRID_API ICE_DECLSPEC_IMPORT
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace IceGrid
{

class FileParser;
class FileParserPrx;

}

namespace IceGrid
{

class ICE_CLASS(ICEGRID_API) ParseException : public ::Ice::UserExceptionHelper<ParseException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~ParseException();

    ParseException(const ParseException&) = default;

    ParseException() = default;

    ParseException(const ::std::string& iceP_reason) :
        reason(::std::move(iceP_reason))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(reason);
    }

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    ::std::string reason;
};

static ParseException _iceS_ParseException_init;

}

namespace IceGrid
{

class ICEGRID_API FileParser : public virtual ::Ice::Object
{
public:

    using ProxyType = FileParserPrx;

    virtual bool ice_isA(::std::string, const ::Ice::Current&) const override;
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current&) const override;
    virtual ::std::string ice_id(const ::Ice::Current&) const override;

    static const ::std::string& ice_staticId();

    virtual ::IceGrid::ApplicationDescriptor parse(::std::string, ::std::shared_ptr<::IceGrid::AdminPrx>, const ::Ice::Current&) = 0;
    bool _iceD_parse(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
};

}

namespace IceGrid
{

class ICE_CLASS(ICEGRID_API) FileParserPrx : public virtual ::Ice::Proxy<FileParserPrx, ::Ice::ObjectPrx>
{
public:

    ::IceGrid::ApplicationDescriptor parse(const ::std::string& iceP_xmlFile, const ::std::shared_ptr<::IceGrid::AdminPrx>& iceP_adminProxy, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::IceGrid::ApplicationDescriptor>(true, this, &IceGrid::FileParserPrx::_iceI_parse, iceP_xmlFile, iceP_adminProxy, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto parseAsync(const ::std::string& iceP_xmlFile, const ::std::shared_ptr<::IceGrid::AdminPrx>& iceP_adminProxy, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::IceGrid::ApplicationDescriptor>>().get_future())
    {
        return _makePromiseOutgoing<::IceGrid::ApplicationDescriptor, P>(false, this, &IceGrid::FileParserPrx::_iceI_parse, iceP_xmlFile, iceP_adminProxy, context);
    }

    ::std::function<void()>
    parseAsync(const ::std::string& iceP_xmlFile, const ::std::shared_ptr<::IceGrid::AdminPrx>& iceP_adminProxy,
               ::std::function<void(::IceGrid::ApplicationDescriptor)> response,
               ::std::function<void(::std::exception_ptr)> ex = nullptr,
               ::std::function<void(bool)> sent = nullptr,
               const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::IceGrid::ApplicationDescriptor>(response, ex, sent, this, &IceGrid::FileParserPrx::_iceI_parse, iceP_xmlFile, iceP_adminProxy, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_parse(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceGrid::ApplicationDescriptor>>&, const ::std::string&, const ::std::shared_ptr<::IceGrid::AdminPrx>&, const ::Ice::Context&);

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    FileParserPrx() = default;
    friend ::std::shared_ptr<FileParserPrx> IceInternal::createProxy<FileParserPrx>();

    ICE_MEMBER(ICEGRID_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
};

}

namespace Ice
{

template<typename S>
struct StreamReader<::IceGrid::ParseException, S>
{
    static void read(S* istr, ::IceGrid::ParseException& v)
    {
        istr->readAll(v.reason);
    }
};

}

namespace IceGrid
{

using FileParserPtr = ::std::shared_ptr<FileParser>;
using FileParserPrxPtr = ::std::shared_ptr<FileParserPrx>;

}

#else // C++98 mapping

namespace IceProxy
{

namespace IceGrid
{

class FileParser;
ICEGRID_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::FileParser>&);
ICEGRID_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceGrid::FileParser*);

}

}

namespace IceGrid
{

class FileParser;
ICEGRID_API ::Ice::Object* upCast(::IceGrid::FileParser*);
typedef ::IceInternal::Handle< ::IceGrid::FileParser> FileParserPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::FileParser> FileParserPrx;
typedef FileParserPrx FileParserPrxPtr;
ICEGRID_API void _icePatchObjectPtr(FileParserPtr&, const ::Ice::ObjectPtr&);

}

namespace IceGrid
{

class ICEGRID_API ParseException : public ::Ice::UserException
{
public:

    ParseException() {}
    explicit ParseException(const ::std::string&);
    virtual ~ParseException() throw();

    virtual ::std::string ice_id() const;
    virtual ParseException* ice_clone() const;
    virtual void ice_throw() const;

    ::std::string reason;

protected:

    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
};

static ParseException _iceS_ParseException_init;

}

namespace IceAsync
{

}

namespace IceGrid
{

class Callback_FileParser_parse_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_FileParser_parse_Base> Callback_FileParser_parsePtr;

}

namespace IceProxy
{

namespace IceGrid
{

class ICE_CLASS(ICEGRID_API) FileParser : public virtual ::Ice::Proxy<FileParser, ::IceProxy::Ice::Object>
{
public:

    ICE_MEMBER(ICEGRID_API) ::IceGrid::ApplicationDescriptor parse(const ::std::string& iceP_xmlFile, const ::IceGrid::AdminPrx& iceP_adminProxy, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_parse(_iceI_begin_parse(iceP_xmlFile, iceP_adminProxy, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_parse(const ::std::string& iceP_xmlFile, const ::IceGrid::AdminPrx& iceP_adminProxy, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_parse(iceP_xmlFile, iceP_adminProxy, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_parse(const ::std::string& iceP_xmlFile, const ::IceGrid::AdminPrx& iceP_adminProxy, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_parse(iceP_xmlFile, iceP_adminProxy, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_parse(const ::std::string& iceP_xmlFile, const ::IceGrid::AdminPrx& iceP_adminProxy, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_parse(iceP_xmlFile, iceP_adminProxy, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_parse(const ::std::string& iceP_xmlFile, const ::IceGrid::AdminPrx& iceP_adminProxy, const ::IceGrid::Callback_FileParser_parsePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_parse(iceP_xmlFile, iceP_adminProxy, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_parse(const ::std::string& iceP_xmlFile, const ::IceGrid::AdminPrx& iceP_adminProxy, const ::Ice::Context& context, const ::IceGrid::Callback_FileParser_parsePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_parse(iceP_xmlFile, iceP_adminProxy, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::IceGrid::ApplicationDescriptor end_parse(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_parse(const ::std::string&, const ::IceGrid::AdminPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(ICEGRID_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

}

}

namespace IceGrid
{

class ICEGRID_API FileParser : public virtual ::Ice::Object
{
public:

    typedef FileParserPrx ProxyType;
    typedef FileParserPtr PointerType;

    virtual ~FileParser();

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    virtual ::IceGrid::ApplicationDescriptor parse(const ::std::string&, const ::IceGrid::AdminPrx&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_parse(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
};

inline bool operator==(const FileParser& lhs, const FileParser& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const FileParser& lhs, const FileParser& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

}

namespace Ice
{

template<>
struct StreamableTraits< ::IceGrid::ParseException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceGrid::ParseException, S>
{
    static void write(S* ostr, const ::IceGrid::ParseException& v)
    {
        ostr->write(v.reason);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::ParseException, S>
{
    static void read(S* istr, ::IceGrid::ParseException& v)
    {
        istr->read(v.reason);
    }
};

}

namespace IceGrid
{

template<class T>
class CallbackNC_FileParser_parse : public Callback_FileParser_parse_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::IceGrid::ApplicationDescriptor&);

    CallbackNC_FileParser_parse(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::FileParserPrx proxy = ::IceGrid::FileParserPrx::uncheckedCast(result->getProxy());
        ::IceGrid::ApplicationDescriptor ret;
        try
        {
            ret = proxy->end_parse(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_FileParser_parsePtr
newCallback_FileParser_parse(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::ApplicationDescriptor&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_FileParser_parse<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_FileParser_parsePtr
newCallback_FileParser_parse(T* instance, void (T::*cb)(const ::IceGrid::ApplicationDescriptor&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_FileParser_parse<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_FileParser_parse : public Callback_FileParser_parse_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::IceGrid::ApplicationDescriptor&, const CT&);

    Callback_FileParser_parse(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::FileParserPrx proxy = ::IceGrid::FileParserPrx::uncheckedCast(result->getProxy());
        ::IceGrid::ApplicationDescriptor ret;
        try
        {
            ret = proxy->end_parse(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_FileParser_parsePtr
newCallback_FileParser_parse(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::ApplicationDescriptor&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_FileParser_parse<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_FileParser_parsePtr
newCallback_FileParser_parse(T* instance, void (T::*cb)(const ::IceGrid::ApplicationDescriptor&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_FileParser_parse<T, CT>(instance, cb, excb, sentcb);
}

}

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
