/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import org.netbeans.core.NbErrorManager;
import org.netbeans.core.startup.CLIOptions;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public final class NotifyExcPanel
extends JPanel
implements ActionListener {
    static final long serialVersionUID = 3680397500573480127L;
    private static NotifyExcPanel INSTANCE = null;
    private static final int SIZE_PREFERRED_WIDTH = 550;
    private static final int SIZE_PREFERRED_HEIGHT = 250;
    private static ArrayListPos exceptions;
    private NbErrorManager.Exc current;
    private DialogDescriptor descriptor;
    Dialog dialog;
    private JButton next;
    private JButton previous;
    private JButton details;
    private JTextPane output;
    private static boolean showDetails;
    private static Rectangle lastBounds;
    private static int extraH;
    private static int extraW;

    private NotifyExcPanel() {
        ResourceBundle resourceBundle = NbBundle.getBundle(NotifyExcPanel.class);
        this.next = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.next, (String)resourceBundle.getString("CTL_NextException"));
        this.next.setDefaultCapable(false);
        this.previous = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.previous, (String)resourceBundle.getString("CTL_PreviousException"));
        this.previous.setDefaultCapable(false);
        this.details = new JButton();
        this.details.setDefaultCapable(false);
        this.output = new JTextPane(){

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return false;
            }
        };
        this.output.setEditable(false);
        Font font = this.output.getFont();
        this.output.setFont(new Font("Monospaced", 0, null == font ? 12 : font.getSize() + 1));
        this.output.setForeground(UIManager.getColor("Label.foreground"));
        this.output.setBackground(UIManager.getColor("Label.background"));
        this.setLayout(new BorderLayout());
        this.add(new JScrollPane(this.output));
        this.setBorder(new BevelBorder(1));
        this.next.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_NextException"));
        this.previous.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_PreviousException"));
        this.output.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_ExceptionStackTrace"));
        this.output.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_ExceptionStackTrace"));
        this.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_NotifyExceptionPanel"));
        this.descriptor = new DialogDescriptor((Object)"", "");
        this.descriptor.setMessageType(0);
        this.descriptor.setOptions(NotifyExcPanel.computeOptions(this.previous, this.next));
        this.descriptor.setAdditionalOptions(new Object[]{this.details});
        this.descriptor.setClosingOptions(new Object[0]);
        this.descriptor.setButtonListener((ActionListener)this);
        this.descriptor.setModal(NotifyExcPanel.isModalDialogPresent() && WindowManager.getDefault().getMainWindow().isVisible());
        this.setPreferredSize(new Dimension(550 + extraW, 250 + extraH));
        this.dialog = DialogDisplayer.getDefault().createDialog(this.descriptor);
        if (null != lastBounds) {
            NotifyExcPanel.lastBounds.width = Math.max(NotifyExcPanel.lastBounds.width, 550 + extraW);
            this.dialog.setBounds(lastBounds);
        }
        this.dialog.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACN_NotifyExcPanel_Dialog"));
        this.dialog.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACD_NotifyExcPanel_Dialog"));
    }

    static Object[] computeOptions(Object object, Object object2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        arrayList.add(object2);
        extraH = 0;
        extraW = 0;
        for (Handler handler : Logger.getLogger("").getHandlers()) {
            if (!(handler instanceof Callable)) continue;
            boolean bl = false;
            for (Type type : handler.getClass().getGenericInterfaces()) {
                ParameterizedType parameterizedType;
                Type[] typeArray;
                if (!(type instanceof ParameterizedType) || (typeArray = (parameterizedType = (ParameterizedType)type).getActualTypeArguments()).length != 1 || typeArray[0] != JButton.class) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            try {
                Object v = ((Callable)((Object)handler)).call();
                if (v == null) continue;
                assert (v instanceof JButton);
                JButton jButton = (JButton)v;
                extraH += jButton.getPreferredSize().height;
                extraW += jButton.getPreferredSize().width;
                arrayList.add(v);
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
        arrayList.add(NotifyDescriptor.CANCEL_OPTION);
        return arrayList.toArray();
    }

    private static boolean isModalDialogPresent() {
        return NotifyExcPanel.hasModalDialog(WindowManager.getDefault().getMainWindow()) || NotifyExcPanel.hasModalDialog(new JDialog().getOwner());
    }

    private static boolean hasModalDialog(Window window) {
        if (window == null) {
            return false;
        }
        Window[] windowArray = window.getOwnedWindows();
        for (int i = 0; i < windowArray.length; ++i) {
            if (windowArray[i] instanceof Dialog && ((Dialog)windowArray[i]).isModal() && windowArray[i].isVisible()) {
                return true;
            }
            if (!NotifyExcPanel.hasModalDialog(windowArray[i])) continue;
            return true;
        }
        return false;
    }

    static void cleanInstance() {
        INSTANCE = null;
    }

    static void notify(final NbErrorManager.Exc exc) {
        if (!exc.isUserQuestion() && !NotifyExcPanel.shallNotify(exc.getSeverity(), false)) {
            return;
        }
        if (GraphicsEnvironment.isHeadless()) {
            exc.printStackTrace(System.err);
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String string = exc.getLocalizedMessage();
                Level level = exc.getSeverity();
                boolean bl = exc.isLocalized();
                if (exc.isUserQuestion() && bl) {
                    Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)string, 2));
                    if (object == NotifyDescriptor.OK_OPTION) {
                        try {
                            exc.confirm();
                        }
                        catch (IOException iOException) {
                            Exceptions.printStackTrace((Throwable)iOException);
                        }
                    }
                    return;
                }
                if (bl) {
                    if (level == Level.WARNING) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 2));
                        return;
                    }
                    if (level.intValue() == 1973) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 1));
                        return;
                    }
                    if (level == Level.SEVERE) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 0));
                        return;
                    }
                }
                if (null == exceptions) {
                    exceptions = new ArrayListPos();
                }
                exceptions.add(exc);
                exceptions.position = exceptions.size() - 1;
                if (NotifyExcPanel.shallNotify(exc.getSeverity(), true)) {
                    if (INSTANCE == null) {
                        INSTANCE = new NotifyExcPanel();
                    }
                    INSTANCE.updateState(exc);
                } else if (null == INSTANCE) {
                    ImageIcon imageIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/core/resources/exception.gif", (boolean)true);
                    String string2 = NotifyExcPanel.getExceptionSummary(exc);
                    ExceptionFlasher exceptionFlasher = ExceptionFlasher.notify(string2, imageIcon);
                } else {
                    if (INSTANCE == null) {
                        INSTANCE = new NotifyExcPanel();
                    }
                    INSTANCE.updateState(exc);
                }
            }
        });
    }

    private static String getExceptionSummary(NbErrorManager.Exc exc) {
        String string = exc.getLocalizedMessage();
        String string2 = string != null ? string : (exc.getMessage() != null ? exc.getMessage() : exc.getClassName());
        assert (string2 != null);
        return string2;
    }

    private void updateState(NbErrorManager.Exc exc) {
        if (!exceptions.existsNextElement()) {
            this.current = exc;
            this.update();
        } else {
            this.next.setVisible(true);
            this.dialog.pack();
        }
        try {
            this.ensurePreferredSize();
            this.dialog.setVisible(true);
        }
        catch (Exception exception) {
            exceptions.add(NbErrorManager.createExc(exception, Level.SEVERE, null));
            this.next.setVisible(true);
        }
    }

    private void ensurePreferredSize() {
        if (null != lastBounds) {
            return;
        }
        Dimension dimension = this.dialog.getSize();
        Dimension dimension2 = this.dialog.getPreferredSize();
        if (dimension2.height == 0) {
            dimension2.height = 250;
        }
        if (dimension2.width == 0) {
            dimension2.width = 550;
        }
        if (!dimension.equals(dimension2)) {
            this.dialog.setSize(dimension2.width, dimension2.height);
            this.dialog.validate();
            this.dialog.repaint();
        }
    }

    private void update() {
        boolean bl;
        boolean bl2 = this.current.isLocalized();
        boolean bl3 = this.next.isVisible();
        boolean bl4 = this.previous.isVisible();
        this.next.setVisible(exceptions.existsNextElement());
        this.previous.setVisible(exceptions.existsPreviousElement());
        boolean bl5 = bl = this.next.isVisible() != bl3 || this.previous.isVisible() != bl4;
        if (showDetails) {
            Mnemonics.setLocalizedText((AbstractButton)this.details, (String)NbBundle.getBundle(NotifyExcPanel.class).getString("CTL_Exception_Hide_Details"));
            this.details.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NotifyExcPanel.class).getString("ACSD_Exception_Hide_Details"));
        } else {
            Mnemonics.setLocalizedText((AbstractButton)this.details, (String)NbBundle.getBundle(NotifyExcPanel.class).getString("CTL_Exception_Show_Details"));
            this.details.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NotifyExcPanel.class).getString("ACSD_Exception_Show_Details"));
        }
        String string = NbBundle.getBundle(NotifyExcPanel.class).getString("CTL_Title_Exception");
        if (showDetails) {
            this.descriptor.setMessage((Object)this);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StringWriter stringWriter = new StringWriter();
                    NotifyExcPanel.this.current.printStackTrace(new PrintWriter((Writer)stringWriter, true));
                    NotifyExcPanel.this.output.setText(stringWriter.toString());
                    NotifyExcPanel.this.output.getCaret().setDot(0);
                    NotifyExcPanel.this.output.requestFocus();
                }
            });
        } else if (bl2) {
            String string2 = this.current.getLocalizedMessage();
            if (string2 != null) {
                this.descriptor.setMessage((Object)string2);
            }
        } else {
            ResourceBundle resourceBundle = NbBundle.getBundle(NotifyExcPanel.class);
            if (this.current.getSeverity() == Level.WARNING) {
                this.descriptor.setMessage((Object)MessageFormat.format(resourceBundle.getString("NTF_ExceptionWarning"), this.current.getClassName()));
                string = resourceBundle.getString("NTF_ExceptionWarningTitle");
            } else {
                this.descriptor.setMessage((Object)MessageFormat.format(resourceBundle.getString("NTF_ExceptionalException"), this.current.getClassName(), CLIOptions.getLogDir()));
                string = resourceBundle.getString("NTF_ExceptionalExceptionTitle");
            }
        }
        this.descriptor.setTitle(string);
        if (bl) {
            this.dialog.pack();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.next && exceptions.setNextElement() || object == this.previous && exceptions.setPreviousElement()) {
            this.current = exceptions.get();
            LogRecord logRecord = new LogRecord(Level.CONFIG, "NotifyExcPanel: " + actionEvent.getActionCommand());
            String string = this.current.getMessage();
            String string2 = this.current.getClassName();
            if (string != null) {
                string2 = string2 + ": " + string;
            }
            Object[] objectArray = new Object[]{string2, this.current.getFirstStacktraceLine()};
            logRecord.setParameters(objectArray);
            Logger.getLogger("org.netbeans.ui.NotifyExcPanel").log(logRecord);
            this.update();
            return;
        }
        if (object == this.details) {
            showDetails = !showDetails;
            lastBounds = null;
            try {
                this.update();
                this.ensurePreferredSize();
            }
            catch (Exception exception) {
                exceptions.add(NbErrorManager.createExc(exception, Level.SEVERE, null));
                this.next.setVisible(true);
            }
            return;
        }
        if (object == NotifyDescriptor.OK_OPTION || object == NotifyDescriptor.CLOSED_OPTION || object == NotifyDescriptor.CANCEL_OPTION) {
            LogRecord logRecord = new LogRecord(Level.CONFIG, "NotifyExcPanel:  close");
            logRecord.setParameters(null);
            Logger.getLogger("org.netbeans.ui.NotifyExcPanel").log(logRecord);
            try {
                if (null != exceptions) {
                    exceptions.removeAll();
                }
                lastBounds = this.dialog.getBounds();
                this.dialog.dispose();
                exceptions = null;
                INSTANCE = null;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            finally {
                exceptions = null;
                INSTANCE = null;
            }
        }
    }

    private static boolean shallNotify(Level level, boolean bl) {
        int n = Integer.getInteger("netbeans.exception.alert.min.level", 900);
        boolean bl2 = false;
        if (!$assertionsDisabled) {
            bl2 = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        int n2 = bl2 ? 900 : 1001;
        int n3 = Integer.getInteger("netbeans.exception.report.min.level", n2);
        if (bl) {
            return level.intValue() >= n3;
        }
        return level.intValue() >= n || level.intValue() >= n3;
    }

    static {
        extraH = 0;
        extraW = 0;
    }

    static class ArrayListPos
    extends ArrayList<NbErrorManager.Exc> {
        static final long serialVersionUID = 2L;
        protected int position = 0;

        protected ArrayListPos() {
        }

        protected boolean existsElement() {
            return this.size() > 0;
        }

        protected boolean existsNextElement() {
            return this.position + 1 < this.size();
        }

        protected boolean existsPreviousElement() {
            return this.position > 0 && this.size() > 0;
        }

        protected boolean setNextElement() {
            if (!this.existsNextElement()) {
                return false;
            }
            ++this.position;
            return true;
        }

        protected boolean setPreviousElement() {
            if (!this.existsPreviousElement()) {
                return false;
            }
            --this.position;
            return true;
        }

        protected NbErrorManager.Exc get() {
            return this.existsElement() ? (NbErrorManager.Exc)this.get(this.position) : null;
        }

        protected void removeAll() {
            this.clear();
            this.position = 0;
        }
    }

    static class ExceptionFlasher
    implements ActionListener {
        static ExceptionFlasher flash;
        Notification note;
        private final Timer timer = new Timer(300000, this);

        private static synchronized ExceptionFlasher notify(String string, ImageIcon imageIcon) {
            if (flash == null) {
                flash = new ExceptionFlasher();
            } else {
                ExceptionFlasher.flash.timer.restart();
                ExceptionFlasher.flash.note.clear();
            }
            JComponent jComponent = ExceptionFlasher.getDetailsPanel(string);
            JComponent jComponent2 = ExceptionFlasher.getDetailsPanel(string);
            ExceptionFlasher.flash.note = NotificationDisplayer.getDefault().notify(NbBundle.getMessage(NotifyExcPanel.class, (String)"NTF_ExceptionalExceptionTitle"), (Icon)imageIcon, jComponent2, jComponent, NotificationDisplayer.Priority.SILENT, NotificationDisplayer.Category.ERROR);
            return flash;
        }

        public ExceptionFlasher() {
            this.timer.setRepeats(false);
            this.timer.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.timer) {
                this.timeout();
                return;
            }
            Class<ExceptionFlasher> clazz = ExceptionFlasher.class;
            synchronized (ExceptionFlasher.class) {
                if (this.note != null) {
                    this.note.clear();
                }
                flash = null;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                if (null != exceptions && exceptions.size() > 0) {
                    if (INSTANCE == null) {
                        INSTANCE = new NotifyExcPanel();
                    }
                    INSTANCE.updateState((NbErrorManager.Exc)exceptions.get(exceptions.size() - 1));
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void timeout() {
            Class<ExceptionFlasher> clazz = ExceptionFlasher.class;
            synchronized (ExceptionFlasher.class) {
                assert (EventQueue.isDispatchThread());
                if (null != INSTANCE) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                if (null != exceptions) {
                    exceptions.clear();
                }
                exceptions = null;
                flash = null;
                this.timer.stop();
                if (null != this.note) {
                    this.note.clear();
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        private static JComponent getDetailsPanel(String string) {
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setOpaque(false);
            JLabel jLabel = new JLabel(string);
            JButton jButton = new JButton("<html><a href=\"_blank\">" + NbBundle.getMessage(NotifyExcPanel.class, (String)"NTF_ExceptionalExceptionReport"));
            jButton.setFocusable(false);
            jButton.setBorder(BorderFactory.createEmptyBorder());
            jButton.setBorderPainted(false);
            jButton.setFocusPainted(false);
            jButton.setOpaque(false);
            jButton.setContentAreaFilled(false);
            jButton.addActionListener(flash);
            jButton.setCursor(Cursor.getPredefinedCursor(12));
            jPanel.add((Component)jButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 0, 3, 0), 0, 0));
            jPanel.add((Component)jLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 0, 3, 0), 0, 0));
            return jPanel;
        }
    }
}

