/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.selector.ui;

import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.selector.ui.Bundle;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;

public abstract class SearchPanel
extends JPanel {
    private static final String SEARCHPANEL_PERMANENT = "searchPanel.shownDefault";
    private static final String SEARCH_NEXT_NAME = "search.next";
    private static final String SEARCH_PREV_NAME = "search.prev";
    private final JTextField searchField = new JTextField("");
    private final int findKeyEvent = 114;
    private final int closeKeyEvent = 27;
    private boolean permanent;
    private Action nextAction = new AbstractAction("", Icons.getIcon((String)"GeneralIcons.FindNext")){
        {
            KeyStroke keyStroke = KeyStroke.getKeyStroke(114, 0);
            this.putValue("AcceleratorKey", keyStroke);
            this.putValue("ShortDescription", Bundle.DSC_FindNext(SearchPanel.this.getAcceleratorDesc(keyStroke)));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SearchPanel.this.performNext();
        }
    };
    private Action prevAction = new AbstractAction("", Icons.getIcon((String)"GeneralIcons.FindPrevious")){
        {
            KeyStroke keyStroke = KeyStroke.getKeyStroke(114, 64);
            this.putValue("AcceleratorKey", keyStroke);
            this.putValue("ShortDescription", Bundle.DSC_FindPrevious(SearchPanel.this.getAcceleratorDesc(keyStroke)));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SearchPanel.this.performPrevious();
        }
    };
    private Action closeAction = new AbstractAction("", Icons.getIcon((String)"GeneralIcons.Stop")){
        {
            KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
            this.putValue("AcceleratorKey", keyStroke);
            this.putValue("ShortDescription", Bundle.DSC_Close(SearchPanel.this.getAcceleratorDesc(keyStroke)));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SearchPanel.this.setVisible(false);
            SearchPanel.this.onClose();
        }
    };
    private JButton prev = new JButton(this.prevAction);
    private JButton next = new JButton(this.nextAction);
    private JButton close = new JButton(this.closeAction);

    SearchPanel(@NonNull JComponent jComponent) {
        this.permanent = NbPreferences.forModule(SearchPanel.class).getBoolean(SEARCHPANEL_PERMANENT, true);
        this.setLayout(new BoxLayout(this, 2));
        this.add(new JLabel(Bundle.LBL_Find()));
        this.add(this.searchField);
        this.searchField.setOpaque(false);
        this.prev.setBorderPainted(false);
        this.next.setBorderPainted(false);
        this.close.setBorderPainted(false);
        this.add(this.prev);
        this.add(this.next);
        this.add(this.close);
        jComponent.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.isAltDown() || keyEvent.isAltGraphDown() || keyEvent.isControlDown() || keyEvent.isMetaDown() || keyEvent.isActionKey()) {
                    return;
                }
                if (!Character.isUnicodeIdentifierStart(keyEvent.getKeyChar())) {
                    return;
                }
                if (keyEvent.getKeyCode() != 10 && keyEvent.getKeyCode() != 32 && keyEvent.getKeyCode() != 27) {
                    if (!SearchPanel.this.isVisible()) {
                        SearchPanel.this.open();
                    } else {
                        SearchPanel.this.searchField.requestFocus();
                    }
                    SearchPanel.this.setSearchText(String.valueOf(keyEvent.getKeyChar()));
                    keyEvent.consume();
                } else if (SearchPanel.this.isVisible() && keyEvent.getKeyCode() == 27) {
                    SearchPanel.this.onCancel();
                    SearchPanel.this.setVisible(false);
                    keyEvent.consume();
                }
            }
        });
        jComponent.getInputMap().put((KeyStroke)this.nextAction.getValue("AcceleratorKey"), SEARCH_NEXT_NAME);
        jComponent.getInputMap().put((KeyStroke)this.prevAction.getValue("AcceleratorKey"), SEARCH_PREV_NAME);
        jComponent.getActionMap().put(SEARCH_NEXT_NAME, this.nextAction);
        jComponent.getActionMap().put(SEARCH_PREV_NAME, this.prevAction);
        this.searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n;
                if (SearchPanel.this.isVisible() && ((n = keyEvent.getKeyCode()) == 10 || n == 27)) {
                    keyEvent.consume();
                    if (n == 10) {
                        SearchPanel.this.performFind();
                    } else {
                        SearchPanel.this.onCancel();
                    }
                    if (!SearchPanel.this.permanent || n == 27) {
                        SearchPanel.this.setVisible(false);
                        SearchPanel.this.onClose();
                    }
                }
            }
        });
        this.setVisible(this.permanent);
    }

    void reset() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SearchPanel.this.searchField.setText("");
                SearchPanel.this.setVisible(SearchPanel.this.permanent);
            }
        });
    }

    void open() {
        this.setVisible(true);
        this.searchField.requestFocus();
        this.onOpen();
    }

    void setSearchText(String string) {
        this.searchField.setText(string);
    }

    String getSearchText() {
        return this.searchField.getText();
    }

    void setPermanent(boolean bl) {
        this.permanent = bl;
        NbPreferences.forModule(SearchPanel.class).putBoolean(SEARCHPANEL_PERMANENT, bl);
    }

    KeyStroke getNextShortcut() {
        return (KeyStroke)this.nextAction.getValue("AcceleratorKey");
    }

    KeyStroke getPrevShortcut() {
        return (KeyStroke)this.prevAction.getValue("AcceleratorKey");
    }

    protected abstract void performFind();

    protected abstract void performNext();

    protected abstract void performPrevious();

    protected void onCancel() {
    }

    protected void onClose() {
    }

    protected void onOpen() {
    }

    private String getAcceleratorDesc(KeyStroke keyStroke) {
        String string = Utilities.keyToString((KeyStroke)keyStroke);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
        if (stringTokenizer.countTokens() == 1) {
            return stringTokenizer.nextToken();
        }
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        StringBuilder stringBuilder = new StringBuilder();
        block6: for (char c : string2.toCharArray()) {
            switch (c) {
                case 'S': {
                    stringBuilder.append("Shift+");
                    continue block6;
                }
                case 'A': 
                case 'O': {
                    stringBuilder.append("Alt+");
                    continue block6;
                }
                case 'C': 
                case 'D': {
                    stringBuilder.append("Ctrl+");
                    continue block6;
                }
                case 'M': {
                    stringBuilder.append("Meta+");
                }
            }
        }
        stringBuilder.append(string3);
        return stringBuilder.toString();
    }
}

