/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.projection;

import java.util.Collection;
import java.util.Collections;
import org.openstreetmap.josm.gui.preferences.projection.ListProjectionChoice;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class PuwgProjectionChoice
extends ListProjectionChoice {
    private static final String[] CODES = new String[]{"EPSG:2180", "EPSG:2176", "EPSG:2177", "EPSG:2178", "EPSG:2179"};
    private static final String[] NAMES = new String[]{I18n.tr("PUWG 1992 (Poland)", new Object[0]), I18n.tr("PUWG 2000 Zone {0} (Poland)", 5), I18n.tr("PUWG 2000 Zone {0} (Poland)", 6), I18n.tr("PUWG 2000 Zone {0} (Poland)", 7), I18n.tr("PUWG 2000 Zone {0} (Poland)", 8)};

    public PuwgProjectionChoice() {
        super(I18n.tr("PUWG (Poland)", new Object[0]), "core:puwg", NAMES, I18n.tr("PUWG Zone", new Object[0]));
    }

    @Override
    public String getCurrentCode() {
        return CODES[this.index];
    }

    @Override
    public String getProjectionName() {
        return NAMES[this.index];
    }

    @Override
    public String[] allCodes() {
        return Utils.copyArray(CODES);
    }

    @Override
    public Collection<String> getPreferencesFromCode(String code) {
        for (String code2 : CODES) {
            if (!code.equals(code2)) continue;
            return Collections.singleton(code2);
        }
        return null;
    }

    @Override
    protected String indexToZone(int index) {
        return CODES[index];
    }

    @Override
    protected int zoneToIndex(String zone) {
        for (int i = 0; i < CODES.length; ++i) {
            if (!zone.equals(CODES[i])) continue;
            return i;
        }
        return this.defaultIndex;
    }
}

