/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.EventObject;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.TagMap;
import org.openstreetmap.josm.gui.datatransfer.OsmTransferHandler;
import org.openstreetmap.josm.gui.tagging.TagCellEditor;
import org.openstreetmap.josm.gui.tagging.TagCellRenderer;
import org.openstreetmap.josm.gui.tagging.TagEditorModel;
import org.openstreetmap.josm.gui.tagging.TagModel;
import org.openstreetmap.josm.gui.tagging.TagTableColumnModelBuilder;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionManager;
import org.openstreetmap.josm.gui.widgets.JosmTable;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public class TagTable
extends JosmTable
implements TagEditorModel.EndEditListener {
    private TagCellEditor editor;
    private final TagEditorModel model;
    private Component nextFocusComponent;
    private final CopyOnWriteArrayList<Component> doNotStopCellEditingWhenFocused = new CopyOnWriteArrayList();
    private transient CellEditorRemover editorRemover;
    private DeleteAction deleteAction;
    private AddAction addAction;
    private PasteAction pasteAction;

    public DeleteAction getDeleteAction() {
        return this.deleteAction;
    }

    public AddAction getAddAction() {
        return this.addAction;
    }

    public PasteAction getPasteAction() {
        return this.pasteAction;
    }

    protected final void init(int maxCharacters) {
        this.setAutoResizeMode(0);
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(true);
        this.setSelectionMode(1);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0, false), "selectNextColumnCell");
        this.getActionMap().put("selectNextColumnCell", new SelectNextColumnCellAction());
        this.getActionMap().put("selectPreviousColumnCell", new SelectPreviousColumnCellAction());
        this.deleteAction = new DeleteAction();
        this.addAction = new AddAction();
        this.getInputMap(1).put(KeyStroke.getKeyStroke(107, 128), "addTag");
        this.getActionMap().put("addTag", this.addAction);
        this.pasteAction = new PasteAction();
        TagCellEditor tmpEditor = new TagCellEditor(maxCharacters);
        this.setRowHeight(tmpEditor.getEditor().getPreferredSize().height);
        this.setTagCellEditor(tmpEditor);
    }

    public TagTable(TagEditorModel model, int maxCharacters) {
        super(model, new TagTableColumnModelBuilder(new TagCellRenderer(), I18n.tr("Key", new Object[0]), I18n.tr("Value", new Object[0])).setSelectionModel(model.getColumnSelectionModel()).build(), model.getRowSelectionModel());
        this.model = model;
        model.setEndEditListener(this);
        this.init(maxCharacters);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getPreferredFullWidthSize();
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (e.getKeyCode() == 127) {
            if (this.isEditing() && this.getSelectedColumnCount() == 1 && this.getSelectedRowCount() == 1) {
                return super.processKeyBinding(ks, e, condition, pressed);
            }
            this.getDeleteAction().actionPerformed(null);
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    public void setAutoCompletionList(AutoCompletionList autoCompletionList) {
        if (autoCompletionList == null) {
            return;
        }
        if (this.editor != null) {
            this.editor.setAutoCompletionList(autoCompletionList);
        }
    }

    public void setAutoCompletionManager(AutoCompletionManager autocomplete) {
        if (autocomplete == null) {
            Logging.warn("argument autocomplete should not be null. Aborting.");
            Logging.error(new Exception());
            return;
        }
        if (this.editor != null) {
            this.editor.setAutoCompletionManager(autocomplete);
        }
    }

    public AutoCompletionList getAutoCompletionList() {
        if (this.editor != null) {
            return this.editor.getAutoCompletionList();
        }
        return null;
    }

    public void setNextFocusComponent(Component nextFocusComponent) {
        this.nextFocusComponent = nextFocusComponent;
    }

    public TagCellEditor getTableCellEditor() {
        return this.editor;
    }

    public void setTagCellEditor(TagCellEditor editor) {
        this.endCellEditing();
        this.editor = editor;
        this.getColumnModel().getColumn(0).setCellEditor(editor);
        this.getColumnModel().getColumn(1).setCellEditor(editor);
    }

    public void requestFocusInCell(int row, int col) {
        this.changeSelection(row, col, false, false);
        this.editCellAt(row, col);
        Component c = this.getEditorComponent();
        if (c != null) {
            c.requestFocusInWindow();
            if (c instanceof JTextComponent) {
                ((JTextComponent)c).selectAll();
            }
        }
    }

    public void addComponentNotStoppingCellEditing(Component component) {
        if (component == null) {
            return;
        }
        this.doNotStopCellEditingWhenFocused.addIfAbsent(component);
    }

    public void removeComponentNotStoppingCellEditing(Component component) {
        if (component == null) {
            return;
        }
        this.doNotStopCellEditingWhenFocused.remove(component);
    }

    @Override
    public boolean editCellAt(int row, int column, EventObject e) {
        if (this.cellEditor != null && !this.cellEditor.stopCellEditing()) {
            return false;
        }
        if (row < 0 || row >= this.getRowCount() || column < 0 || column >= this.getColumnCount()) {
            return false;
        }
        if (!this.isCellEditable(row, column)) {
            return false;
        }
        if (this.editorRemover == null) {
            KeyboardFocusManager fm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.editorRemover = new CellEditorRemover(fm);
            fm.addPropertyChangeListener("permanentFocusOwner", this.editorRemover);
        }
        return super.editCellAt(row, column, e);
    }

    @Override
    public void endCellEditing() {
        TableCellEditor cEditor;
        if (this.isEditing() && (cEditor = this.getCellEditor()) != null) {
            cEditor.stopCellEditing();
            cEditor.cancelCellEditing();
        }
    }

    @Override
    public void removeEditor() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this.editorRemover);
        this.editorRemover = null;
        super.removeEditor();
    }

    @Override
    public void removeNotify() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this.editorRemover);
        this.editorRemover = null;
        super.removeNotify();
    }

    class CellEditorRemover
    implements PropertyChangeListener {
        private final KeyboardFocusManager focusManager;

        CellEditorRemover(KeyboardFocusManager fm) {
            this.focusManager = fm;
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            if (!TagTable.this.isEditing()) {
                return;
            }
            for (Component c = this.focusManager.getPermanentFocusOwner(); c != null; c = c.getParent()) {
                if (c == TagTable.this) {
                    return;
                }
                if (TagTable.this.doNotStopCellEditingWhenFocused.contains(c)) {
                    return;
                }
                if (!(c instanceof Window)) continue;
                if (c != SwingUtilities.getRoot(TagTable.this) || TagTable.this.getCellEditor().stopCellEditing()) break;
                TagTable.this.getCellEditor().cancelCellEditing();
                break;
            }
        }
    }

    class PasteAction
    extends AbstractAction
    implements PropertyChangeListener {
        PasteAction() {
            new ImageProvider("pastetags").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Paste tags from buffer", new Object[0]));
            TagTable.this.addPropertyChangeListener(this);
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Relation relation = new Relation();
            TagTable.this.model.applyToPrimitive(relation);
            new OsmTransferHandler().pasteTags(Collections.singleton(relation));
            TagTable.this.model.updateTags(new TagMap(relation.getKeys()).getTags());
        }

        protected final void updateEnabledState() {
            this.setEnabled(TagTable.this.isEnabled());
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.updateEnabledState();
        }
    }

    class AddAction
    extends AbstractAction
    implements PropertyChangeListener {
        AddAction() {
            new ImageProvider("dialogs", "add").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Add a new tag", new Object[0]));
            TagTable.this.addPropertyChangeListener(this);
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int rowIdx;
            TableCellEditor cEditor = TagTable.this.getCellEditor();
            if (cEditor != null) {
                cEditor.stopCellEditing();
            }
            if ((rowIdx = TagTable.this.model.getRowCount() - 1) < 0 || !((TagModel)TagTable.this.model.getValueAt(rowIdx, 0)).getName().trim().isEmpty()) {
                TagTable.this.model.appendNewTag();
            }
            TagTable.this.requestFocusInCell(TagTable.this.model.getRowCount() - 1, 0);
        }

        protected final void updateEnabledState() {
            this.setEnabled(TagTable.this.isEnabled());
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.updateEnabledState();
        }
    }

    class DeleteAction
    extends AbstractAction
    implements ListSelectionListener {
        DeleteAction() {
            new ImageProvider("dialogs", "delete").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Delete the selection in the tag table", new Object[0]));
            TagTable.this.getSelectionModel().addListSelectionListener(this);
            TagTable.this.getColumnModel().getSelectionModel().addListSelectionListener(this);
            this.updateEnabledState();
        }

        protected void deleteTagNames() {
            int[] rows = TagTable.this.getSelectedRows();
            TagTable.this.model.deleteTagNames(rows);
        }

        protected void deleteTagValues() {
            int[] rows = TagTable.this.getSelectedRows();
            TagTable.this.model.deleteTagValues(rows);
        }

        protected void deleteTags() {
            int[] rows = TagTable.this.getSelectedRows();
            TagTable.this.model.deleteTags(rows);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            switch (TagTable.this.getSelectedColumnCount()) {
                case 1: {
                    if (TagTable.this.getSelectedColumn() == 0) {
                        this.deleteTagNames();
                        break;
                    }
                    if (TagTable.this.getSelectedColumn() != 1) break;
                    this.deleteTagValues();
                    break;
                }
                case 2: {
                    this.deleteTags();
                    break;
                }
            }
            TagTable.this.endCellEditing();
            if (TagTable.this.model.getRowCount() == 0) {
                TagTable.this.model.ensureOneTag();
                TagTable.this.requestFocusInCell(0, 0);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }

        protected final void updateEnabledState() {
            if (TagTable.this.getSelectedColumnCount() >= 1 && TagTable.this.getSelectedRowCount() >= 1) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    class SelectPreviousColumnCellAction
    extends AbstractAction {
        SelectPreviousColumnCellAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int col = TagTable.this.getSelectedColumn();
            int row = TagTable.this.getSelectedRow();
            if (TagTable.this.getCellEditor() != null) {
                TagTable.this.getCellEditor().stopCellEditing();
            }
            if (col > 0 || row > 0) {
                if (col == 1) {
                    --col;
                } else {
                    col = 1;
                    --row;
                }
            }
            TagTable.this.requestFocusInCell(row, col);
        }
    }

    class SelectNextColumnCellAction
    extends AbstractAction {
        SelectNextColumnCellAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.run();
        }

        public void run() {
            int col = TagTable.this.getSelectedColumn();
            int row = TagTable.this.getSelectedRow();
            if (TagTable.this.getCellEditor() != null) {
                TagTable.this.getCellEditor().stopCellEditing();
            }
            if (row == -1 && col == -1) {
                TagTable.this.requestFocusInCell(0, 0);
                return;
            }
            if (col == 0) {
                ++col;
            } else if (col == 1 && row < TagTable.this.getRowCount() - 1) {
                col = 0;
                ++row;
            } else if (col == 1 && row == TagTable.this.getRowCount() - 1) {
                String key = ((TagModel)TagTable.this.model.getValueAt(row, 0)).getName();
                if (!key.trim().isEmpty()) {
                    TagTable.this.model.appendNewTag();
                    col = 0;
                    ++row;
                } else {
                    TagTable.this.clearSelection();
                    if (TagTable.this.nextFocusComponent != null) {
                        TagTable.this.nextFocusComponent.requestFocusInWindow();
                    }
                    return;
                }
            }
            TagTable.this.requestFocusInCell(row, col);
        }
    }
}

