/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.fop.area.AbstractOffDocumentItem;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.Resolvable;
import org.apache.fop.fo.pagination.bookmarks.Bookmark;
import org.apache.fop.fo.pagination.bookmarks.BookmarkTree;

public class BookmarkData
extends AbstractOffDocumentItem
implements Resolvable {
    private List<BookmarkData> subData = new ArrayList<BookmarkData>();
    private String bookmarkTitle;
    private boolean showChildren = true;
    private String idRef;
    private PageViewport pageRef;
    private Map<String, List<Resolvable>> unresolvedIDRefs = new HashMap<String, List<Resolvable>>();

    public BookmarkData(BookmarkTree bookmarkTree) {
        this.idRef = null;
        this.whenToProcess = 2;
        this.showChildren = true;
        for (int count = 0; count < bookmarkTree.getBookmarks().size(); ++count) {
            Bookmark bkmk = (Bookmark)bookmarkTree.getBookmarks().get(count);
            this.addSubData(this.createBookmarkData(bkmk));
        }
    }

    public BookmarkData(Bookmark bookmark) {
        this.bookmarkTitle = bookmark.getBookmarkTitle();
        this.showChildren = bookmark.showChildItems();
        this.idRef = bookmark.getInternalDestination();
    }

    private void putUnresolved(String id, BookmarkData bd) {
        List<Resolvable> refs = this.unresolvedIDRefs.get(id);
        if (refs == null) {
            refs = new ArrayList<Resolvable>();
            this.unresolvedIDRefs.put(id, refs);
        }
        refs.add(bd);
    }

    public BookmarkData() {
        this.idRef = null;
        this.whenToProcess = 2;
        this.showChildren = true;
    }

    public BookmarkData(String title, boolean showChildren, PageViewport pv, String idRef) {
        this.bookmarkTitle = title;
        this.showChildren = showChildren;
        this.pageRef = pv;
        this.idRef = idRef;
    }

    public String getIDRef() {
        return this.idRef;
    }

    public void addSubData(BookmarkData sub) {
        this.subData.add(sub);
        if (sub.pageRef == null) {
            String[] ids;
            this.putUnresolved(sub.getIDRef(), sub);
            for (String id : ids = sub.getIDRefs()) {
                this.putUnresolved(id, sub);
            }
        }
    }

    public String getBookmarkTitle() {
        return this.bookmarkTitle;
    }

    public boolean showChildItems() {
        return this.showChildren;
    }

    public int getCount() {
        return this.subData.size();
    }

    public BookmarkData getSubData(int count) {
        return this.subData.get(count);
    }

    public PageViewport getPageViewport() {
        return this.pageRef;
    }

    @Override
    public boolean isResolved() {
        return this.unresolvedIDRefs == null || this.unresolvedIDRefs.size() == 0;
    }

    @Override
    public String[] getIDRefs() {
        return this.unresolvedIDRefs.keySet().toArray(new String[this.unresolvedIDRefs.keySet().size()]);
    }

    @Override
    public void resolveIDRef(String id, List<PageViewport> pages) {
        List<Resolvable> refs;
        if (id.equals(this.idRef)) {
            this.pageRef = pages.get(0);
        }
        if ((refs = this.unresolvedIDRefs.get(id)) != null) {
            for (Resolvable res : refs) {
                res.resolveIDRef(id, pages);
            }
        }
        this.unresolvedIDRefs.remove(id);
    }

    @Override
    public String getName() {
        return "Bookmarks";
    }

    private BookmarkData createBookmarkData(Bookmark bookmark) {
        BookmarkData data = new BookmarkData(bookmark);
        for (int count = 0; count < bookmark.getChildBookmarks().size(); ++count) {
            Bookmark bkmk = (Bookmark)bookmark.getChildBookmarks().get(count);
            data.addSubData(this.createBookmarkData(bkmk));
        }
        return data;
    }
}

