/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.general;

import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.gephi.datalab.spi.ManipulatorUI;
import org.gephi.datalab.spi.general.GeneralActionsManipulator;
import org.gephi.desktop.project.api.ProjectControllerUI;
import org.gephi.io.importer.spi.FileImporterBuilder;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ImportCSV
implements GeneralActionsManipulator {
    private final ProjectControllerUI pc = (ProjectControllerUI)Lookup.getDefault().lookup(ProjectControllerUI.class);
    private final FileImporterBuilder[] spreadsheetImporterBuilders;

    public ImportCSV() {
        ArrayList<FileImporterBuilder> list = new ArrayList<FileImporterBuilder>();
        for (FileImporterBuilder builder : Lookup.getDefault().lookupAll(FileImporterBuilder.class)) {
            if (!builder.getName().startsWith("spreadsheet")) continue;
            list.add(builder);
        }
        this.spreadsheetImporterBuilders = list.toArray(new FileImporterBuilder[0]);
    }

    public void execute() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ImportCSV.this.pc.openFile(ImportCSV.this.spreadsheetImporterBuilders);
            }
        });
    }

    public String getName() {
        return NbBundle.getMessage(ImportCSV.class, (String)"ImportCSV.name");
    }

    public String getDescription() {
        return "";
    }

    public boolean canExecute() {
        return true;
    }

    public ManipulatorUI getUI() {
        return null;
    }

    public int getType() {
        return 100;
    }

    public int getPosition() {
        return 100;
    }

    public Icon getIcon() {
        return ImageUtilities.loadImageIcon((String)"org/gephi/datalab/plugin/manipulators/resources/table-excel.png", (boolean)true);
    }
}

