/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.internal;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.component.ComponentWithVariants;
import org.gradle.api.internal.component.SoftwareComponentInternal;
import org.gradle.api.internal.component.UsageContext;
import org.gradle.internal.scopeids.id.BuildInvocationScopeId;
import org.gradle.util.GUtil;
import org.gradle.util.GradleVersion;

public class ModuleMetadataFileGenerator {
    private final BuildInvocationScopeId buildInvocationScopeId;

    public ModuleMetadataFileGenerator(BuildInvocationScopeId buildInvocationScopeId) {
        this.buildInvocationScopeId = buildInvocationScopeId;
    }

    public void generateTo(ModuleVersionIdentifier coordinates, ComponentWithVariants component, Writer writer) throws IOException {
        JsonWriter jsonWriter = new JsonWriter(writer);
        jsonWriter.setHtmlSafe(false);
        jsonWriter.setIndent("  ");
        jsonWriter.beginObject();
        jsonWriter.name("formatVersion");
        jsonWriter.value("0.1");
        jsonWriter.name("createdBy");
        jsonWriter.beginObject();
        jsonWriter.name("gradle");
        jsonWriter.beginObject();
        jsonWriter.name("version");
        jsonWriter.value(GradleVersion.current().getVersion());
        jsonWriter.name("buildId");
        jsonWriter.value(this.buildInvocationScopeId.getId().asString());
        jsonWriter.endObject();
        jsonWriter.endObject();
        LinkedHashSet<UsageContext> variants = new LinkedHashSet<UsageContext>();
        this.collectVariants(component, variants);
        if (!variants.isEmpty()) {
            jsonWriter.name("variants");
            jsonWriter.beginArray();
            for (UsageContext variant : variants) {
                jsonWriter.beginObject();
                jsonWriter.name("name");
                jsonWriter.value(variant.getUsage().getName());
                jsonWriter.name("attributes");
                jsonWriter.beginObject();
                jsonWriter.name("usage");
                jsonWriter.value(variant.getUsage().getName());
                jsonWriter.endObject();
                if (!variant.getArtifacts().isEmpty()) {
                    jsonWriter.name("files");
                    jsonWriter.beginArray();
                    for (PublishArtifact artifact : variant.getArtifacts()) {
                        jsonWriter.beginObject();
                        jsonWriter.name("name");
                        jsonWriter.value(artifact.getFile().getName());
                        jsonWriter.name("url");
                        StringBuilder artifactPath = new StringBuilder();
                        artifactPath.append(coordinates.getName());
                        artifactPath.append('-');
                        artifactPath.append(coordinates.getVersion());
                        if (GUtil.isTrue((Object)artifact.getClassifier())) {
                            artifactPath.append('-');
                            artifactPath.append(artifact.getClassifier());
                        }
                        if (GUtil.isTrue((Object)artifact.getExtension())) {
                            artifactPath.append('.');
                            artifactPath.append(artifact.getExtension());
                        }
                        jsonWriter.value(artifactPath.toString());
                        jsonWriter.endObject();
                    }
                    jsonWriter.endArray();
                }
                jsonWriter.endObject();
            }
            jsonWriter.endArray();
        }
        jsonWriter.endObject();
        jsonWriter.flush();
        writer.append('\n');
    }

    private void collectVariants(ComponentWithVariants component, Set<UsageContext> dest) {
        if (component instanceof SoftwareComponentInternal) {
            SoftwareComponentInternal softwareComponentInternal = (SoftwareComponentInternal)component;
            dest.addAll(softwareComponentInternal.getUsages());
        }
    }
}

