/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.scala;

import java.io.File;
import java.util.Arrays;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.tasks.compile.BaseForkOptionsConverter;
import org.gradle.api.internal.tasks.compile.daemon.AbstractDaemonCompiler;
import org.gradle.api.internal.tasks.scala.ScalaJavaJointCompileSpec;
import org.gradle.api.tasks.compile.BaseForkOptions;
import org.gradle.api.tasks.compile.ForkOptions;
import org.gradle.api.tasks.scala.ScalaForkOptions;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.process.JavaForkOptions;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.DaemonForkOptionsBuilder;
import org.gradle.workers.internal.KeepAliveMode;
import org.gradle.workers.internal.WorkerDaemonFactory;
import org.gradle.workers.internal.WorkerFactory;

public class DaemonScalaCompiler<T extends ScalaJavaJointCompileSpec>
extends AbstractDaemonCompiler<T> {
    private static final Iterable<String> SHARED_PACKAGES = Arrays.asList("scala", "com.typesafe.zinc", "xsbti", "com.sun.tools.javac", "sbt");
    private final Iterable<File> zincClasspath;
    private final FileResolver fileResolver;
    private final File daemonWorkingDir;

    public DaemonScalaCompiler(File daemonWorkingDir, Compiler<T> delegate, WorkerDaemonFactory workerDaemonFactory, Iterable<File> zincClasspath, FileResolver fileResolver) {
        super(delegate, (WorkerFactory)workerDaemonFactory);
        this.zincClasspath = zincClasspath;
        this.fileResolver = fileResolver;
        this.daemonWorkingDir = daemonWorkingDir;
    }

    protected AbstractDaemonCompiler.InvocationContext toInvocationContext(T spec) {
        ForkOptions javaOptions = spec.getCompileOptions().getForkOptions();
        ScalaForkOptions scalaOptions = spec.getScalaCompileOptions().getForkOptions();
        JavaForkOptions javaForkOptions = new BaseForkOptionsConverter(this.fileResolver).transform(this.mergeForkOptions((BaseForkOptions)javaOptions, scalaOptions));
        File invocationWorkingDir = javaForkOptions.getWorkingDir();
        javaForkOptions.setWorkingDir(this.daemonWorkingDir);
        DaemonForkOptions daemonForkOptions = new DaemonForkOptionsBuilder(this.fileResolver).javaForkOptions(javaForkOptions).classpath(this.zincClasspath).sharedPackages(SHARED_PACKAGES).keepAliveMode(KeepAliveMode.SESSION).build();
        return new AbstractDaemonCompiler.InvocationContext(invocationWorkingDir, daemonForkOptions);
    }
}

