/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.filewatch;

import java.io.File;
import javax.annotation.Nullable;

public class FileWatcherEvent {
    private final Type type;
    private final File file;

    private FileWatcherEvent(Type type, File file) {
        this.type = type;
        this.file = file;
    }

    public Type getType() {
        return this.type;
    }

    @Nullable
    public File getFile() {
        return this.file;
    }

    public String toString() {
        return "FileWatcherEvent{type=" + (Object)((Object)this.type) + ", file=" + this.file + '}';
    }

    public static FileWatcherEvent create(File file) {
        return new FileWatcherEvent(Type.CREATE, file);
    }

    public static FileWatcherEvent modify(File file) {
        return new FileWatcherEvent(Type.MODIFY, file);
    }

    public static FileWatcherEvent delete(File file) {
        return new FileWatcherEvent(Type.DELETE, file);
    }

    public static FileWatcherEvent undefined() {
        return new FileWatcherEvent(Type.UNDEFINED, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        CREATE,
        MODIFY,
        DELETE,
        UNDEFINED;

    }
}

