/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.ClassExtension;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.ElementManipulator;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;

public class ElementManipulators
extends ClassExtension<ElementManipulator> {
    @NonNls
    public static final String EP_NAME = "org.jetbrains.kotlin.com.intellij.lang.elementManipulator";
    public static final ElementManipulators INSTANCE = new ElementManipulators();
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.ElementManipulators");

    private ElementManipulators() {
        super(EP_NAME);
    }

    public static <T extends PsiElement> ElementManipulator<T> getManipulator(@NotNull T element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/ElementManipulators", "getManipulator"));
        }
        return (ElementManipulator)INSTANCE.forClass(element.getClass());
    }

    public static int getOffsetInElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/ElementManipulators", "getOffsetInElement"));
        }
        ElementManipulator<PsiElement> manipulator = ElementManipulators.getNotNullManipulator(element);
        return manipulator.getRangeInElement(element).getStartOffset();
    }

    @NotNull
    public static <T extends PsiElement> ElementManipulator<T> getNotNullManipulator(@NotNull T element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/ElementManipulators", "getNotNullManipulator"));
        }
        ElementManipulator<T> manipulator = ElementManipulators.getManipulator(element);
        LOG.assertTrue(manipulator != null, element.getClass().getName());
        ElementManipulator<T> elementManipulator = manipulator;
        if (elementManipulator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/ElementManipulators", "getNotNullManipulator"));
        }
        return elementManipulator;
    }

    public static TextRange getValueTextRange(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/ElementManipulators", "getValueTextRange"));
        }
        ElementManipulator<PsiElement> manipulator = ElementManipulators.getManipulator(element);
        return manipulator == null ? TextRange.from(0, element.getTextLength()) : manipulator.getRangeInElement(element);
    }

    @NotNull
    public static String getValueText(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/ElementManipulators", "getValueText"));
        }
        TextRange valueTextRange = ElementManipulators.getValueTextRange(element);
        if (valueTextRange.isEmpty()) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/ElementManipulators", "getValueText"));
            }
            return "";
        }
        String text2 = element.getText();
        if (valueTextRange.getEndOffset() > text2.length()) {
            LOG.error("Wrong range for " + element + " text: " + text2 + " range " + valueTextRange);
        }
        String string = valueTextRange.substring(text2);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/ElementManipulators", "getValueText"));
        }
        return string;
    }

    public static <T extends PsiElement> T handleContentChange(@NotNull T element, String text2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/ElementManipulators", "handleContentChange"));
        }
        ElementManipulator<T> manipulator = ElementManipulators.getNotNullManipulator(element);
        return manipulator.handleContentChange(element, text2);
    }
}

