/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.graph.Graph;
import org.jetbrains.kotlin.com.intellij.util.graph.InboundSemiGraph;
import org.jetbrains.kotlin.gnu.trove.THashMap;
import org.jetbrains.kotlin.gnu.trove.THashSet;

public class GraphGenerator<Node>
implements Graph<Node> {
    private final InboundSemiGraph<Node> myGraph;
    private final Map<Node, List<Node>> myOuts;

    @NotNull
    public static <T> Graph<T> generate(InboundSemiGraph<T> graph2) {
        GraphGenerator<T> graphGenerator = new GraphGenerator<T>(graph2);
        if (graphGenerator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/graph/GraphGenerator", "generate"));
        }
        return graphGenerator;
    }

    private GraphGenerator(@NotNull InboundSemiGraph<Node> graph2) {
        if (graph2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "org/jetbrains/kotlin/com/intellij/util/graph/GraphGenerator", "<init>"));
        }
        this.myGraph = graph2;
        this.myOuts = new THashMap<Node, List<Node>>();
        this.buildOuts();
    }

    private void buildOuts() {
        THashSet<Pair<Node, Node>> edges = new THashSet<Pair<Node, Node>>();
        Collection<Node> nodes = this.myGraph.getNodes();
        for (Node node : nodes) {
            Iterator<Node> inIt = this.myGraph.getIn(node);
            while (inIt.hasNext()) {
                Node inNode = inIt.next();
                if (!edges.add(Pair.create(inNode, node))) continue;
                List<Node> edgesFromInNode = this.myOuts.get(inNode);
                if (edgesFromInNode == null) {
                    edgesFromInNode = new ArrayList<Node>();
                    this.myOuts.put(inNode, edgesFromInNode);
                }
                edgesFromInNode.add(node);
            }
        }
    }

    @Override
    public Collection<Node> getNodes() {
        return this.myGraph.getNodes();
    }

    @Override
    public Iterator<Node> getIn(Node n) {
        return this.myGraph.getIn(n);
    }

    @Override
    public Iterator<Node> getOut(Node n) {
        List<Node> outNodes = this.myOuts.get(n);
        return outNodes != null ? outNodes.iterator() : ContainerUtil.emptyIterator();
    }

    public static interface SemiGraph
    extends InboundSemiGraph {
    }
}

