/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters.jq;

import java.util.List;
import org.testng.ISuite;
import org.testng.ITestResult;
import org.testng.Reporter;
import org.testng.reporters.XMLStringBuffer;
import org.testng.reporters.jq.BaseMultiSuitePanel;
import org.testng.reporters.jq.Model;

public class ReporterPanel
extends BaseMultiSuitePanel {
    public ReporterPanel(Model model) {
        super(model);
    }

    public String getPrefix() {
        return "reporter-";
    }

    public String getHeader(ISuite suite) {
        return "Reporter output for " + suite.getName();
    }

    public String getContent(ISuite suite, XMLStringBuffer main) {
        XMLStringBuffer xsb = new XMLStringBuffer(main.getCurrentIndent());
        for (ITestResult tr : this.getModel().getAllTestResults(suite)) {
            List<String> lines = Reporter.getOutput(tr);
            if (lines.isEmpty()) continue;
            xsb.push("div", "class", "reporter-method-div");
            xsb.addRequired("span", Model.getTestResultName(tr), "class", "reporter-method-name");
            xsb.push("div", "class", "reporter-method-output-div");
            for (String output : lines) {
                xsb.addRequired("span", output, "class", "reporter-method-output");
            }
            xsb.pop("div");
            xsb.pop("div");
        }
        return xsb.toXML();
    }

    public String getNavigatorLink(ISuite suite) {
        return "Reporter output";
    }
}

