/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.read.CyclicBufferAppender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.LoggerFactory;

public class LogCollector
extends CyclicBufferAppender<ILoggingEvent> {
    private static LogCollector instance = new LogCollector();
    private Layout<ILoggingEvent> layout;
    @Nullable
    private ILogListener listener;

    public static LogCollector getInstance() {
        return instance;
    }

    public static void register() {
        Logger rootLogger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        LoggerContext loggerContext = rootLogger.getLoggerContext();
        PatternLayout layout = new PatternLayout();
        layout.setContext((Context)loggerContext);
        layout.setPattern("%-5level: %msg%n");
        layout.start();
        instance.setContext((Context)loggerContext);
        instance.setLayout((Layout<ILoggingEvent>)layout);
        instance.start();
        rootLogger.addAppender((Appender)instance);
    }

    public LogCollector() {
        this.setName("LogCollector");
        this.setMaxSize(5000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void append(ILoggingEvent event) {
        super.append((Object)event);
        if (this.listener != null && event.getLevel().isGreaterOrEqual(this.listener.getFilterLevel())) {
            LogCollector logCollector = this;
            synchronized (logCollector) {
                this.listener.onAppend(this.layout.doLayout((Object)event));
            }
        }
    }

    public void setLayout(Layout<ILoggingEvent> layout) {
        this.layout = layout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(@NotNull ILogListener listener) {
        this.listener = listener;
        LogCollector logCollector = this;
        synchronized (logCollector) {
            listener.onAppend(this.init(listener.getFilterLevel()));
        }
    }

    public void resetListener() {
        this.listener = null;
    }

    private String init(Level filterLevel) {
        StringBuilder sb = new StringBuilder();
        int length = this.getLength();
        for (int i = 0; i < length; ++i) {
            ILoggingEvent event = (ILoggingEvent)this.get(i);
            if (!event.getLevel().isGreaterOrEqual(filterLevel)) continue;
            sb.append(this.layout.doLayout((Object)event));
        }
        return sb.toString();
    }

    public static interface ILogListener {
        public Level getFilterLevel();

        public void onAppend(String var1);
    }
}

