/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.upload.UploadNotesTask;
import org.openstreetmap.josm.data.osm.NoteData;
import org.openstreetmap.josm.gui.layer.NoteLayer;
import org.openstreetmap.josm.gui.progress.swing.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public class UploadNotesAction
extends JosmAction {
    public UploadNotesAction() {
        this.putValue("ShortDescription", I18n.tr("Upload note changes to server", new Object[0]));
        this.putValue("Name", I18n.tr("Upload notes", new Object[0]));
        new ImageProvider("upload").getResource().attachImageIcon(this, true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List<NoteLayer> noteLayers = this.getLayerManager().getLayersOfType(NoteLayer.class);
        if (noteLayers.isEmpty()) {
            Logging.error("No note layer found");
            return;
        }
        NoteLayer layer = noteLayers.get(0);
        Logging.debug("uploading note changes");
        NoteData noteData = layer.getNoteData();
        if (noteData == null || !noteData.isModified()) {
            Logging.debug("No changed notes to upload");
            return;
        }
        new UploadNotesTask().uploadNotes(noteData, new PleaseWaitProgressMonitor(I18n.tr("Uploading notes to server", new Object[0])));
    }
}

