/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public interface WordIndexer<W>
extends Serializable {
    public int getOrAddIndex(W var1);

    public int getOrAddIndexFromString(String var1);

    public int getIndexPossiblyUnk(W var1);

    public W getWord(int var1);

    public int numWords();

    public W getStartSymbol();

    public void setStartSymbol(W var1);

    public W getEndSymbol();

    public void setEndSymbol(W var1);

    public W getUnkSymbol();

    public void setUnkSymbol(W var1);

    public void trimAndLock();

    public static class StaticMethods {
        public static <W> int[] toArray(WordIndexer<W> wordIndexer, List<W> list) {
            int[] ret = new int[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                ret[i] = wordIndexer.getIndexPossiblyUnk(list.get(i));
            }
            return ret;
        }

        public static <W> int[] toArrayFromStrings(WordIndexer<W> wordIndexer, List<String> list) {
            int[] ret = new int[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                ret[i] = wordIndexer.getOrAddIndexFromString(list.get(i));
            }
            return ret;
        }

        public static <W> List<W> toList(WordIndexer<W> wordIndexer, int[] intNgram, int startPos, int endPos) {
            ArrayList<W> l = new ArrayList<W>(endPos - startPos);
            for (int i = startPos; i < endPos; ++i) {
                l.add(wordIndexer.getWord(intNgram[i]));
            }
            return l;
        }

        public static <W> List<W> toList(WordIndexer<W> wordIndexer, int[] intNgram) {
            return StaticMethods.toList(wordIndexer, intNgram, 0, intNgram.length);
        }
    }
}

